/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotException;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.LanguageAccessor;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.Truffle;
import org.pkl.thirdparty.truffle.api.TruffleStackTraceElement;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.FrameInstance;
import org.pkl.thirdparty.truffle.api.frame.FrameInstanceVisitor;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;
import org.pkl.thirdparty.truffle.api.nodes.ControlFlowException;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class TruffleStackTrace
extends Exception {
    private static final TruffleStackTrace EMPTY = new TruffleStackTrace(Collections.emptyList(), 0);
    private List<TruffleStackTraceElement> frames;
    private final int lazyFrames;
    private Throwable materializedHostException;

    private TruffleStackTrace(List<TruffleStackTraceElement> frames, int lazyFrames) {
        this.frames = frames;
        this.lazyFrames = lazyFrames;
    }

    private void materializeHostException() {
        if (this.materializedHostException == null) {
            this.materializedHostException = new Exception();
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    StackTraceElement[] getInternalStackTrace() {
        Throwable hostException = this.materializedHostException;
        if (hostException == null) {
            hostException = this;
        }
        StackTraceElement[] hostFrames = hostException.getStackTrace();
        if (this.lazyFrames == 0) {
            return hostFrames;
        }
        StackTraceElement[] extended = new StackTraceElement[hostFrames.length + this.lazyFrames];
        System.arraycopy(hostFrames, 0, extended, this.lazyFrames, hostFrames.length);
        return extended;
    }

    @Override
    public String toString() {
        return "Attached Guest Language Frames (" + this.frames.size() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleStackTraceElement> getStackTrace(Throwable throwable) {
        TruffleStackTrace stack = TruffleStackTrace.fillIn(throwable);
        if (stack != null) {
            return stack.frames;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleStackTraceElement> getAsynchronousStackTrace(CallTarget target, Frame frame) {
        Objects.requireNonNull(target, "CallTarget must not be null");
        Objects.requireNonNull(frame, "Frame must not be null");
        assert (LanguageAccessor.ENGINE.hasCurrentContext());
        return LanguageAccessor.ACCESSOR.nodeSupport().findAsynchronousFrames(target, frame);
    }

    private static LazyStackTrace findImpl(Throwable t) {
        assert (!(t instanceof ControlFlowException));
        for (Throwable suppressed : t.getSuppressed()) {
            if (!(suppressed instanceof LazyStackTrace)) continue;
            return (LazyStackTrace)suppressed;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleStackTrace fillIn(Throwable throwable) {
        int stackFrameLimit;
        Node topCallSite;
        Objects.requireNonNull(throwable);
        if (throwable instanceof ControlFlowException) {
            return EMPTY;
        }
        LazyStackTrace lazy = TruffleStackTrace.getOrCreateLazyStackTrace(throwable);
        if (lazy.stackTrace != null) {
            return lazy.stackTrace;
        }
        boolean isTruffleException = LanguageAccessor.EXCEPTIONS.isException(throwable);
        if (isTruffleException) {
            topCallSite = LanguageAccessor.EXCEPTIONS.getLocation(throwable);
            stackFrameLimit = LanguageAccessor.EXCEPTIONS.getStackTraceElementLimit(throwable);
        } else {
            topCallSite = null;
            stackFrameLimit = -1;
        }
        ArrayList<TracebackElement> elements = new ArrayList<TracebackElement>();
        TracebackElement currentElement = lazy.current;
        while (currentElement != null) {
            elements.add(currentElement);
            currentElement = currentElement.last;
        }
        ArrayList<TruffleStackTraceElement> frames = new ArrayList<TruffleStackTraceElement>();
        ListIterator iterator2 = elements.listIterator(elements.size());
        while (iterator2.hasPrevious()) {
            TracebackElement element = (TracebackElement)iterator2.previous();
            if (element.root != null) {
                frames.add(new TruffleStackTraceElement(topCallSite, element.root, element.frame));
                topCallSite = null;
            }
            if (element.callNode == null) continue;
            topCallSite = element.callNode;
        }
        int lazyFrames = frames.size();
        TruffleStackTrace.addStackFrames(stackFrameLimit, lazyFrames, topCallSite, frames);
        TruffleStackTrace fullStackTrace = new TruffleStackTrace(frames, lazyFrames);
        if (isTruffleException && !TruffleStackTrace.isHostException(throwable)) {
            fullStackTrace.materializeHostException();
        }
        lazy.stackTrace = fullStackTrace;
        return fullStackTrace;
    }

    private static boolean isHostException(Throwable throwable) {
        Object polyglotEngine = LanguageAccessor.ENGINE.getCurrentPolyglotEngine();
        return polyglotEngine != null && LanguageAccessor.ENGINE.getHostService(polyglotEngine).isHostException(throwable);
    }

    static void addStackFrameInfo(Node callNode, RootCallTarget root, Throwable t, Frame currentFrame) {
        if (t instanceof ControlFlowException) {
            return;
        }
        if (t instanceof PolyglotException) {
            return;
        }
        boolean isTProfiled = CompilerDirectives.isPartialEvaluationConstant(t.getClass());
        MaterializedFrame frame = null;
        if (currentFrame != null && root.getRootNode().isCaptureFramesForTrace()) {
            frame = currentFrame.materialize();
        }
        TruffleStackTrace.callInnerAddStackFrameInfo(isTProfiled, callNode, root, t, frame);
    }

    private static void callInnerAddStackFrameInfo(boolean isTProfiled, Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        if (isTProfiled) {
            TruffleStackTrace.innerAddStackFrameInfo(callNode, root, t, currentFrame);
        } else {
            TruffleStackTrace.innerAddStackFrameInfoBoundary(callNode, root, t, currentFrame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void innerAddStackFrameInfoBoundary(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        TruffleStackTrace.innerAddStackFrameInfo(callNode, root, t, currentFrame);
    }

    private static void innerAddStackFrameInfo(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        if (!LanguageAccessor.EXCEPTIONS.isException(t)) {
            TruffleStackTrace.fillIn(t);
            return;
        }
        int stackTraceElementLimit = LanguageAccessor.EXCEPTIONS.getStackTraceElementLimit(t);
        LazyStackTrace lazy = (LazyStackTrace)LanguageAccessor.EXCEPTIONS.getLazyStackTrace(t);
        if (lazy == null) {
            lazy = new LazyStackTrace();
            LanguageAccessor.EXCEPTIONS.setLazyStackTrace(t, lazy);
        }
        TruffleStackTrace.appendLazyStackTrace(callNode, root, currentFrame, lazy, stackTraceElementLimit);
    }

    @CompilerDirectives.TruffleBoundary
    static LazyStackTrace getOrCreateLazyStackTrace(Throwable throwable) {
        LazyStackTrace lazy;
        if (LanguageAccessor.EXCEPTIONS.isException(throwable)) {
            lazy = (LazyStackTrace)LanguageAccessor.EXCEPTIONS.getLazyStackTrace(throwable);
            if (lazy == null) {
                lazy = new LazyStackTrace();
                LanguageAccessor.EXCEPTIONS.setLazyStackTrace(throwable, lazy);
            }
        } else {
            lazy = TruffleStackTrace.findImpl(throwable);
            if (lazy == null && !TruffleStackTrace.tryAddSuppressed(throwable, lazy = new LazyStackTrace())) {
                lazy.stackTrace = EMPTY;
            }
        }
        return lazy;
    }

    private static boolean tryAddSuppressed(Throwable throwable, LazyStackTrace lazy) {
        if (throwable instanceof StackOverflowError || throwable instanceof OutOfMemoryError) {
            return false;
        }
        throwable.addSuppressed(lazy);
        return throwable.getSuppressed().length != 0;
    }

    private static void appendLazyStackTrace(Node callNode, RootCallTarget root, MaterializedFrame currentFrame, LazyStackTrace lazy, int stackTraceElementLimit) {
        if (lazy.stackTrace == null) {
            if (stackTraceElementLimit >= 0 && lazy.frameCount >= stackTraceElementLimit) {
                return;
            }
            lazy.current = new TracebackElement(lazy.current, callNode, root, currentFrame);
            if (root != null && LanguageAccessor.ACCESSOR.nodeSupport().countsTowardsStackTraceLimit(root.getRootNode())) {
                ++lazy.frameCount;
            }
        }
    }

    private static void addStackFrames(final int stackFrameLimit, final int lazyFrames, final Node topCallSite, final List<TruffleStackTraceElement> frames) {
        if (stackFrameLimit >= 0 && lazyFrames >= stackFrameLimit) {
            return;
        }
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
            boolean first = true;
            int stackFrameIndex = lazyFrames;

            @Override
            public FrameInstance visitFrame(FrameInstance frameInstance) {
                if (stackFrameLimit >= 0 && this.stackFrameIndex >= stackFrameLimit) {
                    return frameInstance;
                }
                Node location = frameInstance.getCallNode();
                RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
                if (this.first) {
                    location = topCallSite;
                    this.first = false;
                }
                boolean captureFrames = target != null && target.getRootNode().isCaptureFramesForTrace();
                Frame frame = captureFrames ? frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY) : null;
                frames.add(new TruffleStackTraceElement(location, target, frame));
                this.first = false;
                if (target != null && LanguageAccessor.ACCESSOR.nodeSupport().countsTowardsStackTraceLimit(target.getRootNode())) {
                    ++this.stackFrameIndex;
                }
                return null;
            }
        });
    }

    static final class LazyStackTrace
    extends Throwable {
        private TracebackElement current;
        private TruffleStackTrace stackTrace;
        public int frameCount;

        LazyStackTrace() {
            super(null, null, false, false);
        }

        public TruffleStackTrace getInternalStackTrace() {
            return this.stackTrace;
        }

        @Override
        public String toString() {
            return "Attached Guest Language Frames (" + (this.frameCount + (this.stackTrace != null ? this.stackTrace.frames.size() : 0)) + ")";
        }
    }

    private static final class TracebackElement {
        private final TracebackElement last;
        private final Node callNode;
        private final RootCallTarget root;
        private final MaterializedFrame frame;

        TracebackElement(TracebackElement last2, Node callNode, RootCallTarget root, MaterializedFrame frame) {
            this.last = last2;
            this.callNode = callNode;
            this.root = root;
            this.frame = frame;
        }
    }
}

