/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.TruffleStackTrace;
import org.pkl.thirdparty.truffle.api.TruffleStackTraceElement;
import org.pkl.thirdparty.truffle.api.debug.BreakpointExceptionFilter;
import org.pkl.thirdparty.truffle.api.debug.DebugStackFrame;
import org.pkl.thirdparty.truffle.api.debug.DebugStackTraceElement;
import org.pkl.thirdparty.truffle.api.debug.DebugValue;
import org.pkl.thirdparty.truffle.api.debug.Debugger;
import org.pkl.thirdparty.truffle.api.debug.DebuggerSession;
import org.pkl.thirdparty.truffle.api.debug.SuspendedEvent;
import org.pkl.thirdparty.truffle.api.frame.FrameInstance;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.nodes.LanguageInfo;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class DebugException
extends RuntimeException {
    private static final long serialVersionUID = 5017970176581546348L;
    private static final String CAUSE_CAPTION = "Caused by: ";
    private final DebuggerSession session;
    private final Throwable exception;
    private final LanguageInfo preferredLanguage;
    private final Node throwLocation;
    private final StackTraceElement[] rawStackTrace;
    private volatile boolean isCatchNodeComputed;
    private volatile CatchLocation catchLocation;
    private SuspendedEvent suspendedEvent;
    private List<DebugStackTraceElement> debugStackTrace;
    private List<List<DebugStackTraceElement>> debugAsyncStacks;
    private StackTraceElement[] javaLikeStackTrace;

    static DebugException create(DebuggerSession session, String message) {
        return new DebugException(session, message, null, null, null, true, null);
    }

    static DebugException create(DebuggerSession session, Throwable exception, LanguageInfo preferredLanguage) {
        return DebugException.create(session, exception, preferredLanguage, null, true, null);
    }

    static DebugException create(DebuggerSession session, Throwable exception, LanguageInfo preferredLanguage, Node throwLocation, boolean isCatchNodeComputed, CatchLocation catchLocation) {
        return new DebugException(session, DebugException.getTheMessage(exception), exception, preferredLanguage, throwLocation, isCatchNodeComputed, catchLocation);
    }

    private DebugException(DebuggerSession session, String message, Throwable exception, LanguageInfo preferredLanguage, Node throwLocation, boolean isCatchNodeComputed, CatchLocation catchLocation) {
        super(message);
        StackTraceElement[] exceptionStackTrace = null;
        if (session.isShowHostStackFrames()) {
            StackTraceElement[] stackTrace;
            if (exception != null && (stackTrace = exception.getStackTrace()).length > 0) {
                exceptionStackTrace = stackTrace;
            }
            if (exceptionStackTrace == null) {
                Throwable t = super.fillInStackTrace();
                assert (this == t);
            }
        }
        this.rawStackTrace = exceptionStackTrace;
        this.session = session;
        this.exception = exception;
        this.preferredLanguage = preferredLanguage;
        this.throwLocation = throwLocation;
        this.isCatchNodeComputed = isCatchNodeComputed;
        this.catchLocation = catchLocation != null ? catchLocation.cloneFor(session) : null;
        super.setStackTrace(this.getStackTrace());
    }

    private static String getTheMessage(Throwable exception) {
        if (DebugException.isTruffleException(exception)) {
            try {
                return InteropLibrary.getUncached().asString(InteropLibrary.getUncached().getExceptionMessage(exception));
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        return exception.getLocalizedMessage();
    }

    void setSuspendedEvent(SuspendedEvent suspendedEvent) {
        assert (this.session == suspendedEvent.getSession());
        if (this.catchLocation != null) {
            this.catchLocation.setSuspendedEvent(suspendedEvent);
        }
        this.suspendedEvent = suspendedEvent;
    }

    Throwable getRawException() {
        return this.exception;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        for (int i2 = 0; i2 < stackTrace.length; ++i2) {
            if (stackTrace[i2] != null) continue;
            throw new NullPointerException("stackTrace[" + i2 + "]");
        }
    }

    private StackTraceElement[] getRawStackTrace() {
        if (this.rawStackTrace != null) {
            return this.rawStackTrace;
        }
        return super.getStackTrace();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.javaLikeStackTrace == null) {
            if (this.isInternalError()) {
                return this.getRawStackTrace();
            }
            List<DebugStackTraceElement> debugStack = this.getDebugStackTrace();
            int size = debugStack.size();
            this.javaLikeStackTrace = new StackTraceElement[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.javaLikeStackTrace[i2] = debugStack.get(i2).toTraceElement();
            }
        }
        return (StackTraceElement[])this.javaLikeStackTrace.clone();
    }

    public List<DebugStackTraceElement> getDebugStackTrace() {
        if (this.debugStackTrace == null) {
            if (this.exception != null) {
                List<TruffleStackTraceElement> stackTrace = TruffleStackTrace.getStackTrace(this.exception);
                int n = stackTrace.size();
                ArrayList<DebugStackTraceElement> debugStack = new ArrayList<DebugStackTraceElement>(n);
                boolean hostInfo = this.session.isShowHostStackFrames();
                for (int i2 = 0; i2 < n; ++i2) {
                    TruffleStackTraceElement tframe = stackTrace.get(i2);
                    RootNode root = tframe.getTarget().getRootNode();
                    if (root.getLanguageInfo() != null) {
                        debugStack.add(new DebugStackTraceElement(this.session, tframe));
                        continue;
                    }
                    if (!hostInfo) continue;
                    debugStack.add(null);
                }
                if (hostInfo) {
                    StackTraceElement[] stack = SuspendedEvent.cutToHostDepth(this.getRawStackTrace());
                    Object polyglotInstrument = Debugger.ACCESSOR.instrumentSupport().getPolyglotInstrument(this.session.getDebugger().getEnv());
                    Object polyglotEngine = Debugger.ACCESSOR.engineSupport().getEngineFromPolyglotObject(polyglotInstrument);
                    Iterator<DebugStackTraceElement> mergedElements = Debugger.ACCESSOR.engineSupport().mergeHostGuestFrames(polyglotEngine, stack, debugStack.iterator(), true, true, new Function<StackTraceElement, DebugStackTraceElement>(){

                        @Override
                        public DebugStackTraceElement apply(StackTraceElement element) {
                            return new DebugStackTraceElement(DebugException.this.session, element);
                        }
                    }, Function.identity());
                    ArrayList<DebugStackTraceElement> elementsList = new ArrayList<DebugStackTraceElement>();
                    while (mergedElements.hasNext()) {
                        elementsList.add(mergedElements.next());
                    }
                    this.debugStackTrace = Collections.unmodifiableList(elementsList);
                } else {
                    this.debugStackTrace = Collections.unmodifiableList(debugStack);
                }
            } else {
                this.debugStackTrace = Collections.emptyList();
            }
        }
        return this.debugStackTrace;
    }

    public List<List<DebugStackTraceElement>> getDebugAsynchronousStacks() {
        if (this.debugAsyncStacks == null) {
            int size = this.getDebugStackTrace().size();
            if (size == 0) {
                return Collections.emptyList();
            }
            this.debugAsyncStacks = new SuspendedEvent.DebugAsyncStackFrameLists(this.session, this.getDebugStackTrace());
        }
        return this.debugAsyncStacks;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintStream(this.session.getDebugger().getEnv().err()));
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        super.printStackTrace(s2);
        if (!DebugException.isTruffleException(this.exception)) {
            s2.print(CAUSE_CAPTION);
            this.exception.printStackTrace(s2);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        super.printStackTrace(s2);
        if (!DebugException.isTruffleException(this.exception)) {
            s2.print(CAUSE_CAPTION);
            this.exception.printStackTrace(s2);
        }
    }

    public boolean isInternalError() {
        if (!DebugException.isTruffleException(this.exception)) {
            if (this.exception instanceof DebugException) {
                return ((DebugException)this.exception).isInternalError();
            }
            return true;
        }
        return false;
    }

    public DebugValue getExceptionObject() {
        RootNode throwRoot;
        if (!DebugException.isTruffleException(this.exception)) {
            return null;
        }
        LanguageInfo language = this.preferredLanguage;
        if (language == null && this.throwLocation != null && (throwRoot = this.throwLocation.getRootNode()) != null) {
            language = throwRoot.getLanguageInfo();
        }
        return new DebugValue.HeapValue(this.session, language, null, this.exception);
    }

    public SourceSection getThrowLocation() {
        InteropLibrary interop = InteropLibrary.getUncached();
        if (interop.isException(this.exception) && interop.hasSourceLocation(this.exception)) {
            try {
                return interop.getSourceLocation(this.exception);
            }
            catch (UnsupportedMessageException ume) {
                CompilerDirectives.shouldNotReachHere(ume);
            }
        }
        if (this.throwLocation != null) {
            return this.throwLocation.getSourceSection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatchLocation getCatchLocation() {
        if (!this.isCatchNodeComputed) {
            DebugException debugException = this;
            synchronized (debugException) {
                if (!this.isCatchNodeComputed) {
                    if (DebugException.isTruffleException(this.exception)) {
                        this.catchLocation = BreakpointExceptionFilter.getCatchNode(this.throwLocation, this.exception);
                        if (this.catchLocation != null) {
                            this.catchLocation.setSuspendedEvent(this.suspendedEvent);
                            this.catchLocation = this.catchLocation.cloneFor(this.session);
                        }
                    }
                    this.isCatchNodeComputed = true;
                }
            }
        }
        return this.catchLocation;
    }

    public Throwable getRawException(Class<? extends TruffleLanguage<?>> languageClass) {
        Objects.requireNonNull(languageClass);
        RootNode rootNode = this.getThrowLocationNode().getRootNode();
        if (rootNode == null) {
            return null;
        }
        TruffleLanguage<?> language = Debugger.ACCESSOR.nodeSupport().getLanguage(rootNode);
        return language != null && language.getClass() == languageClass ? this.getRawException() : null;
    }

    Node getThrowLocationNode() {
        return this.throwLocation;
    }

    private static boolean isTruffleException(Throwable t) {
        return t != null && InteropLibrary.getUncached().isException(t);
    }

    public static final class CatchLocation {
        private final DebuggerSession session;
        private final SourceSection section;
        private final FrameInstance frameInstance;
        private final int depth;
        private DebugStackFrame frame;

        CatchLocation(SourceSection section2, FrameInstance frameInstance, int depth) {
            this(null, section2, frameInstance, depth);
        }

        private CatchLocation(DebuggerSession session, SourceSection section2, FrameInstance frameInstance, int depth) {
            this.session = session;
            this.section = section2;
            this.frameInstance = frameInstance;
            this.depth = depth;
        }

        public SourceSection getSourceSection() {
            return this.session.resolveSection(this.section);
        }

        public DebugStackFrame getFrame() {
            return this.frame;
        }

        void setSuspendedEvent(SuspendedEvent suspendedEvent) {
            assert (this.session == null || this.session == suspendedEvent.getSession());
            this.frame = new DebugStackFrame(suspendedEvent, this.depth == 0 ? null : this.frameInstance, this.depth);
        }

        private CatchLocation cloneFor(DebuggerSession ds) {
            assert (this.session == null);
            CatchLocation clon = new CatchLocation(ds, this.section, this.frameInstance, this.depth);
            if (this.frame != null) {
                assert (ds == this.frame.event.getSession());
                clon.frame = this.frame;
            }
            return clon;
        }
    }
}

