/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import java.util.Objects;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.debug.DebugException;
import org.pkl.thirdparty.truffle.api.debug.DebugValue;
import org.pkl.thirdparty.truffle.api.debug.Debugger;
import org.pkl.thirdparty.truffle.api.debug.DebuggerSession;
import org.pkl.thirdparty.truffle.api.debug.SuspendedEvent;
import org.pkl.thirdparty.truffle.api.debug.ValueInteropList;
import org.pkl.thirdparty.truffle.api.debug.ValuePropertiesCollection;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.instrumentation.InstrumentableNode;
import org.pkl.thirdparty.truffle.api.instrumentation.StandardTags;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.InvalidArrayIndexException;
import org.pkl.thirdparty.truffle.api.interop.NodeLibrary;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnknownIdentifierException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.api.nodes.LanguageInfo;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.NodeVisitor;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class DebugScope {
    private static final InteropLibrary INTEROP = InteropLibrary.getUncached();
    private static final NodeLibrary NODE = NodeLibrary.getUncached();
    private final Object scope;
    private final DebuggerSession session;
    private final SuspendedEvent event;
    private final Node node;
    private final Frame frame;
    private final RootNode root;
    private final LanguageInfo language;
    private DebugScope parent;
    private ValuePropertiesCollection variables;

    DebugScope(Object scope2, DebuggerSession session, SuspendedEvent event, Node node, Frame frame, RootNode root) {
        this(scope2, session, event, node, frame, root, null);
    }

    DebugScope(Object scope2, DebuggerSession session, LanguageInfo language) {
        this(scope2, session, null, null, null, null, language);
    }

    private DebugScope(Object scope2, DebuggerSession session, SuspendedEvent event, Node node, Frame frame, RootNode root, LanguageInfo language) {
        this.scope = scope2;
        this.session = session;
        this.event = event;
        this.node = node;
        this.frame = frame;
        this.root = root;
        this.language = language;
    }

    public String getName() {
        try {
            return INTEROP.asString(INTEROP.toDisplayString(this.scope));
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language, this.node, true, null);
        }
    }

    public DebugScope getParent() throws DebugException {
        this.verifyValidState();
        try {
            if (this.parent == null && INTEROP.hasScopeParent(this.scope)) {
                this.parent = new DebugScope(INTEROP.getScopeParent(this.scope), this.session, this.event, this.node, this.frame, this.root, this.language);
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language);
        }
        return this.parent;
    }

    public boolean isFunctionScope() {
        SourceSection rootSourceSection = this.getRootSourceSection();
        try {
            return rootSourceSection != null && INTEROP.hasSourceLocation(this.scope) && rootSourceSection.equals(INTEROP.getSourceLocation(this.scope));
        }
        catch (UnsupportedMessageException e2) {
            return false;
        }
    }

    private SourceSection getRootSourceSection() {
        if (this.root == null) {
            return null;
        }
        SourceSection rootSourceSection = this.root.getSourceSection();
        if (rootSourceSection == null) {
            final SourceSection[] rootSection = new SourceSection[]{null};
            this.root.accept(new NodeVisitor(){

                @Override
                public boolean visit(Node n) {
                    InstrumentableNode inode;
                    if (n instanceof InstrumentableNode && (inode = (InstrumentableNode)((Object)n)).isInstrumentable() && inode.hasTag(StandardTags.RootTag.class)) {
                        rootSection[0] = n.getSourceSection();
                        return false;
                    }
                    return true;
                }
            });
            rootSourceSection = rootSection[0];
        }
        return rootSourceSection;
    }

    public SourceSection getSourceSection() throws DebugException {
        try {
            if (!INTEROP.hasSourceLocation(this.scope)) {
                return null;
            }
            SourceSection location = INTEROP.getSourceLocation(this.scope);
            if (location != null) {
                return this.session.resolveSection(location);
            }
            return null;
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language);
        }
    }

    @Deprecated(since="20.3")
    public Iterable<DebugValue> getArguments() throws DebugException {
        this.verifyValidState();
        if (this.node == null) {
            return null;
        }
        try {
            Object argumentsObj;
            Node argNode;
            for (argNode = this.node; !(argNode == null || argNode instanceof InstrumentableNode && ((InstrumentableNode)((Object)argNode)).hasTag(StandardTags.RootTag.class)); argNode = argNode.getParent()) {
            }
            if (argNode == null || !NODE.hasScope(argNode, this.frame)) {
                return null;
            }
            try {
                argumentsObj = NODE.getScope(argNode, this.frame, true);
                if (INTEROP.hasScopeParent(argumentsObj)) {
                    argumentsObj = new SubtractedVariables(argumentsObj, INTEROP.getScopeParent(argumentsObj));
                }
            }
            catch (UnsupportedMessageException e2) {
                return null;
            }
            if (argumentsObj != null) {
                ValuePropertiesCollection properties2;
                String receiverName = null;
                if (NODE.hasReceiverMember(argNode, this.frame)) {
                    receiverName = INTEROP.asString(NODE.getReceiverMember(argNode, this.frame));
                }
                if ((properties2 = DebugValue.getProperties(argumentsObj, receiverName, this.session, this.getLanguage(), this)) != null) {
                    return properties2;
                }
                if (ValueInteropList.INTEROP.hasArrayElements(argumentsObj)) {
                    return new ValueInteropList(this.session, this.getLanguage(), argumentsObj);
                }
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language);
        }
        return null;
    }

    public DebugValue getReceiver() {
        this.verifyValidState();
        DebugValue.ObjectMemberValue receiverValue = null;
        try {
            if (this.node == null || !NODE.hasReceiverMember(this.node, this.frame)) {
                return null;
            }
            String name = INTEROP.asString(NODE.getReceiverMember(this.node, this.frame));
            if (!INTEROP.isMemberReadable(this.scope, name) || !this.isDeclaredInScope(name)) {
                return null;
            }
            receiverValue = new DebugValue.ObjectMemberValue(this.session, this.getLanguage(), this, this.scope, name);
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language);
        }
        return receiverValue;
    }

    public DebugValue getRootInstance() {
        this.verifyValidState();
        DebugValue.HeapValue functionValue = null;
        try {
            if (this.node == null || !NODE.hasRootInstance(this.node, this.frame)) {
                return null;
            }
            Boolean function = NODE.hasRootInstance(this.node, this.frame);
            if (function != null) {
                String name = INTEROP.hasExecutableName(function) ? INTEROP.asString(INTEROP.getExecutableName(function)) : this.root.getName();
                functionValue = new DebugValue.HeapValue(this.session, this.getLanguage(), name, function);
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable ex) {
            throw DebugException.create(this.session, ex, this.language);
        }
        return functionValue;
    }

    public Iterable<DebugValue> getDeclaredValues() throws DebugException {
        return this.getVariables();
    }

    public DebugValue getDeclaredValue(String name) throws DebugException {
        return this.getVariables().get(name);
    }

    RootNode getRoot() {
        return this.root;
    }

    private ValuePropertiesCollection getVariables() {
        block7: {
            this.verifyValidState();
            try {
                if (this.variables != null) break block7;
                Object scopeParent = null;
                if (INTEROP.hasScopeParent(this.scope)) {
                    try {
                        scopeParent = INTEROP.getScopeParent(this.scope);
                    }
                    catch (UnsupportedMessageException ex) {
                        throw CompilerDirectives.shouldNotReachHere(ex);
                    }
                }
                Object variablesObj = scopeParent != null ? new SubtractedVariables(this.scope, scopeParent) : this.scope;
                String receiverName = null;
                if (this.node != null && NODE.hasReceiverMember(this.node, this.frame)) {
                    receiverName = INTEROP.asString(NODE.getReceiverMember(this.node, this.frame));
                }
                this.variables = DebugValue.getProperties(variablesObj, receiverName, this.session, this.getLanguage(), this);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable ex) {
                throw DebugException.create(this.session, ex, this.language);
            }
        }
        return this.variables;
    }

    private boolean isDeclaredInScope(String name) {
        Object scopeParent = null;
        if (INTEROP.hasScopeParent(this.scope)) {
            try {
                scopeParent = INTEROP.getScopeParent(this.scope);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        if (scopeParent == null) {
            return true;
        }
        return new SubtractedVariables(this.scope, scopeParent).isMemberReadable(name);
    }

    public DebugValue convertRawValue(Class<? extends TruffleLanguage<?>> languageClass, Object rawValue) {
        Objects.requireNonNull(languageClass);
        RootNode rootNode = this.getRoot();
        if (rootNode == null) {
            return null;
        }
        if (!InteropLibrary.isValidValue(rawValue)) {
            throw new IllegalArgumentException("raw value is not an Interop value");
        }
        TruffleLanguage<?> truffleLanguage = Debugger.ACCESSOR.nodeSupport().getLanguage(rootNode);
        return truffleLanguage != null && truffleLanguage.getClass() == languageClass ? new DebugValue.HeapValue(this.session, null, rawValue) : null;
    }

    LanguageInfo getLanguage() {
        if (this.root != null) {
            return this.root.getLanguageInfo();
        }
        return this.language;
    }

    void verifyValidState() {
        if (this.event != null) {
            this.event.verifyValidState(false);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class SubtractedVariables
    implements TruffleObject {
        private final Object allVariables;
        private final InteropLibrary allLibrary;
        private final Object removedVariables;
        private final InteropLibrary removedLibrary;

        SubtractedVariables(Object allVariables, Object removedVariables) {
            this.allVariables = allVariables;
            this.allLibrary = InteropLibrary.getUncached(allVariables);
            this.removedVariables = removedVariables;
            this.removedLibrary = InteropLibrary.getUncached(removedVariables);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMembers() {
            return this.allLibrary.hasMembers(this.allVariables) && this.removedLibrary.hasMembers(this.removedVariables);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
            return new SubtractedKeys(this.allLibrary.getMembers(this.allVariables, includeInternal), this.removedLibrary.getMembers(this.removedVariables, includeInternal));
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberReadable(String member) {
            if (!this.allLibrary.isMemberReadable(this.allVariables, member)) {
                return false;
            }
            if (!this.removedLibrary.isMemberReadable(this.removedVariables, member)) {
                return true;
            }
            return this.isAmongMembers(member);
        }

        private boolean isAmongMembers(String member) {
            try {
                Object members2 = this.getMembers(true);
                InteropLibrary membersLibrary = InteropLibrary.getUncached(members2);
                long n = membersLibrary.getArraySize(members2);
                for (long i2 = 0L; i2 < n; ++i2) {
                    String m = INTEROP.asString(membersLibrary.readArrayElement(members2, i2));
                    if (!member.equals(m)) continue;
                    return true;
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e2) {
                throw CompilerDirectives.shouldNotReachHere(e2);
            }
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object readMember(String member) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.isMemberReadable(member)) {
                return this.allLibrary.readMember(this.allVariables, member);
            }
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberModifiable(String member) {
            if (!this.allLibrary.isMemberModifiable(this.allVariables, member)) {
                return false;
            }
            if (!this.removedLibrary.isMemberModifiable(this.removedVariables, member)) {
                return true;
            }
            return this.isAmongMembers(member);
        }

        @ExportMessage
        final boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final void writeMember(String member, Object value2) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
            if (!this.isMemberModifiable(member)) {
                throw UnknownIdentifierException.create(member);
            }
            this.allLibrary.writeMember(this.allVariables, member, value2);
        }

        @ExportMessage
        final boolean hasMemberReadSideEffects(String member) {
            return this.isMemberReadable(member) && this.allLibrary.hasMemberReadSideEffects(this.allVariables, member);
        }

        @ExportMessage
        final boolean hasMemberWriteSideEffects(String member) {
            return this.isMemberModifiable(member) && this.allLibrary.hasMemberWriteSideEffects(this.allVariables, member);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SubtractedKeys
    implements TruffleObject {
        private final Object allKeys;
        private final long allSize;
        private final long removedSize;

        SubtractedKeys(Object allKeys, Object removedKeys) throws UnsupportedMessageException {
            this.allKeys = allKeys;
            this.allSize = INTEROP.getArraySize(allKeys);
            this.removedSize = INTEROP.getArraySize(removedKeys);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.allSize - this.removedSize;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (0L <= index && index < this.getArraySize()) {
                return INTEROP.readArrayElement(this.allKeys, index);
            }
            throw InvalidArrayIndexException.create(index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            if (0L <= index && index < this.getArraySize()) {
                return INTEROP.isArrayElementReadable(this.allKeys, index);
            }
            return false;
        }
    }
}

