/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.pkl.thirdparty.truffle.api.TruffleContext;
import org.pkl.thirdparty.truffle.api.TruffleFile;
import org.pkl.thirdparty.truffle.api.instrumentation.ContextsListener;
import org.pkl.thirdparty.truffle.api.instrumentation.InstrumentableNode;
import org.pkl.thirdparty.truffle.api.instrumentation.TruffleInstrument;
import org.pkl.thirdparty.truffle.api.nodes.LanguageInfo;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

final class DebugSourcesResolver {
    private final TruffleInstrument.Env env;
    private volatile URI[] sourcePath = new URI[0];
    private final Map<Source, Source> resolvedMap = new WeakHashMap<Source, Source>();

    DebugSourcesResolver(TruffleInstrument.Env env) {
        this.env = env;
    }

    void setSourcePath(Iterable<URI> uris) {
        ArrayList<URI> collection;
        if (uris instanceof Collection) {
            collection = (ArrayList<URI>)uris;
        } else {
            ArrayList<URI> list = new ArrayList<URI>();
            for (URI uri : uris) {
                list.add(uri);
            }
            collection = list;
        }
        URI[] array = collection.toArray(new URI[collection.size()]);
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2].isAbsolute()) continue;
            try {
                array[i2] = new URI("file://" + array[i2].toString());
                continue;
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("URI " + array[i2] + " is not absolute and can not be converted to a file: " + ex.getLocalizedMessage());
            }
        }
        this.sourcePath = array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Source resolve(Source source2) {
        Source resolved;
        if (source2.hasCharacters() || source2.hasBytes()) {
            return source2;
        }
        Map<Source, Source> map2 = this.resolvedMap;
        synchronized (map2) {
            resolved = this.resolvedMap.getOrDefault(source2, source2);
            if (resolved == source2) {
                resolved = this.doResolve(source2);
                this.resolvedMap.put(source2, resolved);
            }
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source doResolve(Source source2) {
        URI uri = source2.getURI();
        InputStream stream = null;
        if (uri.isAbsolute()) {
            try {
                stream = uri.toURL().openConnection().getInputStream();
            }
            catch (IOException ioex) {
                return null;
            }
        } else {
            URI[] roots;
            for (URI root : roots = this.sourcePath) {
                URI resolved = DebugSourcesResolver.resolve(root, uri);
                try {
                    stream = resolved.toURL().openConnection().getInputStream();
                    uri = resolved;
                    break;
                }
                catch (IOException ioex) {
                }
            }
        }
        if (stream == null) {
            return null;
        }
        try {
            Object name;
            Source.SourceBuilder builder = null;
            if ("file".equals(uri.getScheme())) {
                TruffleContext context2 = this.env.getEnteredContext();
                if (context2 == null) {
                    context2 = this.findAnyTruffleContext();
                }
                TruffleFile file2 = this.env.getTruffleFile(context2, uri);
                builder = Source.newBuilder(source2.getLanguage(), file2);
            } else {
                try {
                    URL url2 = uri.toURL();
                    builder = Source.newBuilder(source2.getLanguage(), url2);
                }
                catch (IllegalArgumentException | MalformedURLException exception) {
                    // empty catch block
                }
            }
            if (builder == null) {
                name = uri.getPath() != null ? uri.getPath() : uri.getSchemeSpecificPart();
                builder = Source.newBuilder(source2.getLanguage(), new InputStreamReader(stream), (String)name).uri(uri);
            }
            try {
                name = builder.cached(false).interactive(source2.isInteractive()).internal(source2.isInternal()).mimeType(source2.getMimeType()).build();
                return name;
            }
            catch (IOException | SecurityException e2) {
                this.env.getLogger("").warning(String.format("Failed to resolve %s: %s%s", source2.getURI(), e2.getLocalizedMessage(), System.lineSeparator()));
                Source source3 = null;
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return source3;
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private TruffleContext findAnyTruffleContext() {
        class ContextFinder
        implements ContextsListener {
            TruffleContext truffleContext;

            ContextFinder() {
            }

            @Override
            public void onContextCreated(TruffleContext context2) {
                this.truffleContext = context2;
            }

            @Override
            public void onLanguageContextCreated(TruffleContext context2, LanguageInfo language) {
            }

            @Override
            public void onLanguageContextInitialized(TruffleContext context2, LanguageInfo language) {
            }

            @Override
            public void onLanguageContextFinalized(TruffleContext context2, LanguageInfo language) {
            }

            @Override
            public void onLanguageContextDisposed(TruffleContext context2, LanguageInfo language) {
            }

            @Override
            public void onContextClosed(TruffleContext context2) {
            }
        }
        ContextFinder finder = new ContextFinder();
        this.env.getInstrumenter().attachContextsListener(finder, true).dispose();
        TruffleContext context2 = finder.truffleContext;
        if (context2 != null) {
            while (context2.getParent() != null) {
                context2 = context2.getParent();
            }
        }
        return context2;
    }

    private static URI resolve(URI base2, URI child) {
        String childPath = child.getPath();
        if (childPath == null || childPath.isEmpty()) {
            return base2;
        }
        Object path2 = base2.getPath();
        try {
            URI resolved;
            if (path2 != null) {
                path2 = ((String)path2).endsWith("/") ? (String)path2 + childPath : (String)path2 + "/" + childPath;
                resolved = new URI(base2.getScheme(), base2.getUserInfo(), base2.getHost(), base2.getPort(), (String)path2, base2.getQuery(), base2.getFragment());
            } else {
                Object ssp = base2.getSchemeSpecificPart();
                ssp = ((String)ssp).endsWith("/") ? (String)ssp + childPath : (String)ssp + "/" + childPath;
                resolved = new URI(base2.getScheme(), (String)ssp, base2.getFragment());
            }
            return resolved.normalize();
        }
        catch (URISyntaxException ex) {
            return base2;
        }
    }

    SourceSection resolve(SourceSection section2) {
        if (section2 == null) {
            return null;
        }
        Source source2 = section2.getSource();
        Source rSource = this.resolve(source2);
        if (rSource == source2 || rSource == null) {
            return section2;
        }
        try {
            if (!section2.isAvailable()) {
                return rSource.createUnavailableSection();
            }
            if (section2.hasCharIndex()) {
                return rSource.createSection(section2.getCharIndex(), section2.getCharLength());
            }
            if (section2.hasColumns()) {
                return rSource.createSection(section2.getStartLine(), section2.getStartColumn(), section2.getEndLine(), section2.getEndColumn());
            }
            if (section2.hasLines()) {
                int startColumn;
                int startLine = section2.getStartLine();
                int endLine = section2.getEndLine();
                CharSequence firstLine = rSource.getCharacters(startLine);
                int length2 = firstLine.length();
                for (startColumn = 0; startColumn < length2 && Character.isWhitespace(firstLine.charAt(startColumn)); ++startColumn) {
                }
                if (startColumn == length2) {
                    startColumn = 0;
                }
                return rSource.createSection(startLine, startColumn + 1, endLine, rSource.getLineLength(endLine));
            }
            return section2;
        }
        catch (IllegalArgumentException ex) {
            return section2;
        }
    }

    static SourceSection findEncapsulatedSourceSection(Node node) {
        for (Node n = node; n != null; n = n.getParent()) {
            SourceSection sourceSection;
            if (!(n instanceof InstrumentableNode) || !((InstrumentableNode)((Object)n)).isInstrumentable() || (sourceSection = n.getSourceSection()) == null || !sourceSection.isAvailable()) continue;
            return sourceSection;
        }
        RootNode rootNode = node.getRootNode();
        return rootNode != null ? rootNode.getSourceSection() : null;
    }
}

