/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.pkl.thirdparty.truffle.api.TruffleContext;
import org.pkl.thirdparty.truffle.api.debug.DebugContext;
import org.pkl.thirdparty.truffle.api.debug.DebugContextsListener;
import org.pkl.thirdparty.truffle.api.debug.DebugThreadsListener;
import org.pkl.thirdparty.truffle.api.debug.Debugger;
import org.pkl.thirdparty.truffle.api.debug.DebuggerSession;
import org.pkl.thirdparty.truffle.api.instrumentation.ContextsListener;
import org.pkl.thirdparty.truffle.api.instrumentation.EventBinding;
import org.pkl.thirdparty.truffle.api.instrumentation.Instrumenter;
import org.pkl.thirdparty.truffle.api.instrumentation.ThreadsListener;
import org.pkl.thirdparty.truffle.api.nodes.LanguageInfo;

final class DebuggerExecutionLifecycle
implements ContextsListener,
ThreadsListener {
    private final DebuggerSession session;
    private final Instrumenter lifecycleInstrumenter;
    private EventBinding<ContextsListener> contextsBinding;
    private volatile DebugContextsListener contextsListener;
    private EventBinding<ThreadsListener> threadsBinding;
    private volatile DebugThreadsListener threadsListener;
    private final Map<TruffleContext, DebugContext> contextMap = new ConcurrentHashMap<TruffleContext, DebugContext>();

    DebuggerExecutionLifecycle(DebuggerSession session) {
        this.session = session;
        this.lifecycleInstrumenter = session.getDebugger().getEnv().getInstrumenter();
    }

    synchronized void setContextsListener(DebugContextsListener listener, boolean includeExistingContexts) {
        if (this.contextsBinding != null) {
            this.contextsBinding.dispose();
        }
        this.contextsListener = listener;
        if (listener != null) {
            this.contextsBinding = this.lifecycleInstrumenter.attachContextsListener(this, includeExistingContexts);
        } else {
            this.contextsBinding = null;
            if (this.threadsBinding == null) {
                this.contextMap.clear();
            }
        }
    }

    synchronized void setThreadsListener(DebugThreadsListener listener, boolean includeExistingThreads) {
        if (this.threadsBinding != null) {
            this.threadsBinding.dispose();
        }
        this.threadsListener = listener;
        if (listener != null) {
            this.threadsBinding = this.lifecycleInstrumenter.attachThreadsListener(this, includeExistingThreads);
        } else {
            this.threadsBinding = null;
            if (this.contextsBinding == null) {
                this.contextMap.clear();
            }
        }
    }

    DebugContext getCachedDebugContext(TruffleContext context2) {
        return this.contextMap.computeIfAbsent(context2, new Function<TruffleContext, DebugContext>(){

            @Override
            public DebugContext apply(TruffleContext c) {
                return new DebugContext(DebuggerExecutionLifecycle.this, c);
            }
        });
    }

    Debugger getDebugger() {
        return this.session.getDebugger();
    }

    DebuggerSession getSession() {
        return this.session;
    }

    @Override
    public void onContextCreated(TruffleContext context2) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.contextCreated(dc);
        }
    }

    @Override
    public void onLanguageContextCreated(TruffleContext context2, LanguageInfo language) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.languageContextCreated(dc, language);
        }
    }

    @Override
    public void onLanguageContextInitialized(TruffleContext context2, LanguageInfo language) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.languageContextInitialized(dc, language);
        }
    }

    @Override
    public void onLanguageContextFinalized(TruffleContext context2, LanguageInfo language) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.languageContextFinalized(dc, language);
        }
    }

    @Override
    public void onLanguageContextDisposed(TruffleContext context2, LanguageInfo language) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.languageContextDisposed(dc, language);
        }
    }

    @Override
    public void onContextClosed(TruffleContext context2) {
        DebugContextsListener l = this.contextsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.contextClosed(dc);
        }
    }

    @Override
    public void onThreadInitialized(TruffleContext context2, Thread thread2) {
        DebugThreadsListener l = this.threadsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.threadInitialized(dc, thread2);
        }
    }

    @Override
    public void onThreadDisposed(TruffleContext context2, Thread thread2) {
        DebugThreadsListener l = this.threadsListener;
        if (l != null) {
            DebugContext dc = this.getCachedDebugContext(context2);
            l.threadDisposed(dc, thread2);
        }
    }
}

