/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.pkl.thirdparty.truffle.api.debug.DebugException;
import org.pkl.thirdparty.truffle.api.debug.DebugScope;
import org.pkl.thirdparty.truffle.api.debug.DebugValue;
import org.pkl.thirdparty.truffle.api.debug.DebuggerSession;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.nodes.LanguageInfo;

final class ValuePropertiesCollection
extends AbstractCollection<DebugValue> {
    static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();
    private final DebuggerSession session;
    private final LanguageInfo language;
    private final Object object;
    private final DebugScope scope;
    private final Object keys;
    private final String receiverName;

    ValuePropertiesCollection(DebuggerSession session, LanguageInfo language, Object object, Object keys2, String receiverName, DebugScope scope2) {
        this.session = session;
        this.language = language;
        this.object = object;
        this.keys = keys2;
        this.scope = scope2;
        this.receiverName = receiverName;
    }

    @Override
    public Iterator<DebugValue> iterator() {
        return new PropertiesIterator(this.receiverName);
    }

    @Override
    public int size() {
        try {
            int size = (int)INTEROP.getArraySize(this.keys);
            if (this.receiverName != null) {
                --size;
            }
            return size;
        }
        catch (UnsupportedMessageException e2) {
            return 0;
        }
    }

    DebugValue get(String name) {
        if (name.equals(this.receiverName)) {
            return null;
        }
        if (INTEROP.isMemberExisting(this.object, name)) {
            return new DebugValue.ObjectMemberValue(this.session, this.language, this.scope, this.object, name);
        }
        return null;
    }

    private final class PropertiesIterator
    implements Iterator<DebugValue> {
        private final String ignoredName;
        private long currentIndex = 0L;
        private String nextMember;

        PropertiesIterator(String ignoredName) {
            this.ignoredName = ignoredName;
        }

        @Override
        public boolean hasNext() {
            if (this.ignoredName == null) {
                return INTEROP.isArrayElementExisting(ValuePropertiesCollection.this.keys, this.currentIndex);
            }
            if (this.nextMember != null) {
                return true;
            }
            while (INTEROP.isArrayElementExisting(ValuePropertiesCollection.this.keys, this.currentIndex)) {
                this.nextMember = this.readNext();
                if (this.ignoredName.equals(this.nextMember)) continue;
                return true;
            }
            return false;
        }

        private String readNext() {
            try {
                Object key2 = INTEROP.readArrayElement(ValuePropertiesCollection.this.keys, this.currentIndex);
                String member = INTEROP.asString(key2);
                ++this.currentIndex;
                return member;
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable ex) {
                throw DebugException.create(ValuePropertiesCollection.this.session, ex, ValuePropertiesCollection.this.language);
            }
        }

        @Override
        public DebugValue next() {
            String member;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextMember != null) {
                member = this.nextMember;
                this.nextMember = null;
            } else {
                member = this.readNext();
            }
            return new DebugValue.ObjectMemberValue(ValuePropertiesCollection.this.session, ValuePropertiesCollection.this.language, ValuePropertiesCollection.this.scope, ValuePropertiesCollection.this.object, member);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported.");
        }
    }
}

