/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.dsl;

import java.util.Arrays;
import java.util.Objects;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class UnsupportedSpecializationException
extends RuntimeException {
    private static final long serialVersionUID = -2122892028296836269L;
    private final Node node;
    private final Node[] suppliedNodes;
    private final Object[] suppliedValues;

    @CompilerDirectives.TruffleBoundary
    public UnsupportedSpecializationException(Node node, Node[] suppliedNodes, Object ... suppliedValues) {
        Objects.requireNonNull(suppliedNodes, "The suppliedNodes parameter must not be null.");
        if (suppliedNodes.length != suppliedValues.length) {
            throw new IllegalArgumentException("The length of suppliedNodes must match the length of suppliedValues.");
        }
        this.node = node;
        this.suppliedNodes = suppliedNodes;
        this.suppliedValues = suppliedValues;
    }

    @Override
    public String getMessage() {
        StringBuilder str = new StringBuilder();
        str.append("Unexpected values provided for ").append(this.node).append(": ").append(Arrays.toString(this.suppliedValues)).append(", [");
        for (int i2 = 0; i2 < this.suppliedValues.length; ++i2) {
            str.append(i2 == 0 ? "" : ",").append(this.suppliedValues[i2] == null ? "null" : this.suppliedValues[i2].getClass().getSimpleName());
        }
        return str.append("]").toString();
    }

    public Node getNode() {
        return this.node;
    }

    public Node[] getSuppliedNodes() {
        return this.suppliedNodes;
    }

    public Object[] getSuppliedValues() {
        return this.suppliedValues;
    }
}

