/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.impl;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.pkl.thirdparty.truffle.api.Assumption;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.Truffle;
import org.pkl.thirdparty.truffle.api.TruffleRuntime;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.FrameInstance;
import org.pkl.thirdparty.truffle.api.frame.FrameInstanceVisitor;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.impl.DefaultAssumption;
import org.pkl.thirdparty.truffle.api.impl.DefaultDirectCallNode;
import org.pkl.thirdparty.truffle.api.impl.DefaultIndirectCallNode;
import org.pkl.thirdparty.truffle.api.impl.DefaultLoopNode;
import org.pkl.thirdparty.truffle.api.impl.DefaultTVMCI;
import org.pkl.thirdparty.truffle.api.impl.FrameWithoutBoxing;
import org.pkl.thirdparty.truffle.api.impl.ReadOnlyFrame;
import org.pkl.thirdparty.truffle.api.impl.TVMCI;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RepeatingNode;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;

public final class DefaultTruffleRuntime
implements TruffleRuntime {
    private final ThreadLocal<DefaultFrameInstance> stackTraces = new ThreadLocal();
    private final DefaultTVMCI tvmci = new DefaultTVMCI();
    private final TVMCI.Test<Closeable, CallTarget> testTvmci = new TVMCI.Test<Closeable, CallTarget>(){

        @Override
        protected Closeable createTestContext(String testName) {
            return null;
        }

        @Override
        public CallTarget createTestCallTarget(Closeable testContext, RootNode testNode) {
            return testNode.getCallTarget();
        }

        @Override
        public void finishWarmup(Closeable testContext, CallTarget callTarget) {
        }
    };

    static DefaultTruffleRuntime getRuntime() {
        return (DefaultTruffleRuntime)Truffle.getRuntime();
    }

    public DefaultTVMCI getTvmci() {
        return this.tvmci;
    }

    @Override
    public String getName() {
        return "Interpreted";
    }

    @Override
    public DirectCallNode createDirectCallNode(CallTarget target) {
        Objects.requireNonNull(target);
        return new DefaultDirectCallNode(target);
    }

    @Override
    public IndirectCallNode createIndirectCallNode() {
        return new DefaultIndirectCallNode();
    }

    @Override
    public VirtualFrame createVirtualFrame(Object[] arguments2, FrameDescriptor frameDescriptor) {
        return new FrameWithoutBoxing(frameDescriptor, arguments2);
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments2) {
        return this.createMaterializedFrame(arguments2, new FrameDescriptor());
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments2, FrameDescriptor frameDescriptor) {
        return new FrameWithoutBoxing(frameDescriptor, arguments2);
    }

    @Override
    public Assumption createAssumption() {
        return this.createAssumption(null);
    }

    @Override
    public Assumption createAssumption(String name) {
        return new DefaultAssumption(name);
    }

    @Override
    public <T> T iterateFrames(FrameInstanceVisitor<T> visitor2) {
        return this.iterateFrames(visitor2, 0);
    }

    @Override
    public <T> T iterateFrames(FrameInstanceVisitor<T> visitor2, int skipFrames) {
        if (skipFrames < 0) {
            throw new IllegalArgumentException("The skipFrames parameter must be >= 0.");
        }
        T result2 = null;
        DefaultFrameInstance frameInstance = this.getThreadLocalStackTrace();
        int skipCounter = skipFrames;
        while (frameInstance != null) {
            if (skipCounter <= 0 && (result2 = (T)visitor2.visitFrame(frameInstance)) != null) {
                return result2;
            }
            frameInstance = frameInstance.callerFrame;
            --skipCounter;
        }
        return result2;
    }

    private DefaultFrameInstance getThreadLocalStackTrace() {
        return this.stackTraces.get();
    }

    private void setThreadLocalStackTrace(DefaultFrameInstance topFrame) {
        this.stackTraces.set(topFrame);
    }

    DefaultFrameInstance pushFrame(VirtualFrame frame, CallTarget target) {
        DefaultFrameInstance callerFrame = this.getThreadLocalStackTrace();
        this.setThreadLocalStackTrace(new DefaultFrameInstance(frame, target, null, callerFrame));
        return callerFrame;
    }

    DefaultFrameInstance pushFrame(VirtualFrame frame, CallTarget target, Node parentCallNode) {
        DefaultFrameInstance callerFrame = this.getThreadLocalStackTrace();
        DefaultFrameInstance callerFrameWithCallNode = callerFrame != null ? callerFrame.withCallNode(parentCallNode) : callerFrame;
        this.setThreadLocalStackTrace(new DefaultFrameInstance(frame, target, null, callerFrameWithCallNode));
        return callerFrame;
    }

    void popFrame(DefaultFrameInstance callerFrame) {
        this.setThreadLocalStackTrace(callerFrame);
    }

    @Override
    public <T> T getCapability(Class<T> capability) {
        if (capability == TVMCI.Test.class) {
            return capability.cast(this.testTvmci);
        }
        if (capability == TVMCI.class) {
            return capability.cast(this.tvmci);
        }
        Iterator<T> it = Loader.load(capability).iterator();
        try {
            return it.hasNext() ? (T)it.next() : null;
        }
        catch (ServiceConfigurationError e2) {
            return null;
        }
    }

    @Override
    public void notifyTransferToInterpreter() {
    }

    @Override
    public LoopNode createLoopNode(RepeatingNode repeating) {
        if (!(repeating instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return new DefaultLoopNode(repeating);
    }

    @Override
    public boolean isProfilingEnabled() {
        return false;
    }

    public void markFrameMaterializeCalled(FrameDescriptor descriptor2) {
    }

    static final class DefaultFrameInstance
    implements FrameInstance {
        private final CallTarget target;
        private final VirtualFrame frame;
        private final Node callNode;
        private final DefaultFrameInstance callerFrame;

        DefaultFrameInstance(VirtualFrame frame, CallTarget target, Node callNode, DefaultFrameInstance callerFrame) {
            this.target = target;
            this.frame = frame;
            this.callNode = callNode;
            this.callerFrame = callerFrame;
        }

        @Override
        public Frame getFrame(FrameInstance.FrameAccess access) {
            VirtualFrame localFrame = this.frame;
            switch (access) {
                case READ_ONLY: {
                    return new ReadOnlyFrame(localFrame);
                }
                case READ_WRITE: {
                    return localFrame;
                }
                case MATERIALIZE: {
                    return localFrame.materialize();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public boolean isVirtualFrame() {
            return false;
        }

        @Override
        public CallTarget getCallTarget() {
            return this.target;
        }

        @Override
        public Node getCallNode() {
            return this.callNode;
        }

        DefaultFrameInstance withCallNode(Node otherCallNode) {
            return new DefaultFrameInstance(this.frame, this.target, otherCallNode, this.callerFrame);
        }
    }

    private static final class Loader {
        private static final Method LOAD_METHOD;

        private Loader() {
        }

        static <S> Iterable<S> load(Class<S> service) {
            Module truffleModule = DefaultTruffleRuntime.class.getModule();
            if (!truffleModule.canUse(service)) {
                truffleModule.addUses(service);
            }
            if (LOAD_METHOD != null) {
                try {
                    return (Iterable)LOAD_METHOD.invoke(null, service);
                }
                catch (Exception e2) {
                    throw new InternalError(e2);
                }
            }
            ModuleLayer moduleLayer = truffleModule.getLayer();
            ServiceLoader<S> services = moduleLayer != null ? ServiceLoader.load(moduleLayer, service) : ServiceLoader.load(service, DefaultTruffleRuntime.class.getClassLoader());
            if (!services.iterator().hasNext()) {
                services = ServiceLoader.load(service);
            }
            return services;
        }

        static {
            Method loadMethod = null;
            try {
                Class<?> servicesClass = Class.forName("jdk.vm.ci.services.Services");
                loadMethod = servicesClass.getMethod("load", Class.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException servicesClass) {
                // empty catch block
            }
            if (loadMethod != null) {
                try {
                    try {
                        loadMethod.invoke(null, new Object[]{null});
                    }
                    catch (InvocationTargetException e2) {
                        throw e2.getTargetException();
                    }
                }
                catch (NullPointerException e2) {
                }
                catch (IllegalAccessException iae) {
                    loadMethod = null;
                }
                catch (Throwable e3) {
                    throw new InternalError(e3);
                }
            }
            LOAD_METHOD = loadMethod;
        }
    }
}

