/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.pkl.thirdparty.truffle.api.impl.DispatchOutputStream;

public final class DelegatingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final DispatchOutputStream delegate;

    DelegatingOutputStream(OutputStream out2, DispatchOutputStream delegate2) {
        this.out = out2;
        this.delegate = delegate2;
    }

    @Override
    public void write(int b2) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2);
        }
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2);
        }
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2, off, len);
        }
        this.out.write(b2, off, len);
    }

    @Override
    public void flush() throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.flushMulti();
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.closeMulti();
        }
        this.out.close();
    }
}

