/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.impl.asm.commons;

import java.util.Collections;
import java.util.Comparator;
import org.pkl.thirdparty.truffle.api.impl.asm.MethodVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.MethodNode;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.TryCatchBlockNode;

public class TryCatchBlockSorter
extends MethodNode {
    public TryCatchBlockSorter(MethodVisitor methodVisitor, int access, String name, String descriptor2, String signature2, String[] exceptions) {
        this(589824, methodVisitor, access, name, descriptor2, signature2, exceptions);
        if (this.getClass() != TryCatchBlockSorter.class) {
            throw new IllegalStateException();
        }
    }

    protected TryCatchBlockSorter(int api, MethodVisitor methodVisitor, int access, String name, String descriptor2, String signature2, String[] exceptions) {
        super(api, access, name, descriptor2, signature2, exceptions);
        this.mv = methodVisitor;
    }

    public void visitEnd() {
        Collections.sort(this.tryCatchBlocks, new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode tryCatchBlockNode1, TryCatchBlockNode tryCatchBlockNode2) {
                return this.blockLength(tryCatchBlockNode1) - this.blockLength(tryCatchBlockNode2);
            }

            private int blockLength(TryCatchBlockNode tryCatchBlockNode) {
                int startIndex = TryCatchBlockSorter.this.instructions.indexOf(tryCatchBlockNode.start);
                int endIndex = TryCatchBlockSorter.this.instructions.indexOf(tryCatchBlockNode.end);
                return endIndex - startIndex;
            }
        });
        for (int i2 = 0; i2 < this.tryCatchBlocks.size(); ++i2) {
            ((TryCatchBlockNode)this.tryCatchBlocks.get(i2)).updateIndex(i2);
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }
}

