/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.impl.asm.tree;

import java.util.List;
import org.pkl.thirdparty.truffle.api.impl.asm.AnnotationVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.Attribute;
import org.pkl.thirdparty.truffle.api.impl.asm.ClassVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.RecordComponentVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.TypePath;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.AnnotationNode;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.TypeAnnotationNode;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.UnsupportedClassVersionException;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.Util;

public class RecordComponentNode
extends RecordComponentVisitor {
    public String name;
    public String descriptor;
    public String signature;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;

    public RecordComponentNode(String name, String descriptor2, String signature2) {
        this(589824, name, descriptor2, signature2);
        if (this.getClass() != RecordComponentNode.class) {
            throw new IllegalStateException();
        }
    }

    public RecordComponentNode(int api, String name, String descriptor2, String signature2) {
        super(api);
        this.name = name;
        this.descriptor = descriptor2;
        this.signature = signature2;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationNode annotation = new AnnotationNode(descriptor2);
        if (visible) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotation);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotation);
        }
        return annotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, typePath, descriptor2);
        if (visible) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotation);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotation);
        }
        return typeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        this.attrs = Util.add(this.attrs, attribute);
    }

    public void visitEnd() {
    }

    public void check(int api) {
        if (api < 524288) {
            throw new UnsupportedClassVersionException();
        }
    }

    public void accept(ClassVisitor classVisitor) {
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation;
        int i2;
        int n;
        RecordComponentVisitor recordComponentVisitor = classVisitor.visitRecordComponent(this.name, this.descriptor, this.signature);
        if (recordComponentVisitor == null) {
            return;
        }
        if (this.visibleAnnotations != null) {
            n = this.visibleAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                annotation = this.visibleAnnotations.get(i2);
                annotation.accept(recordComponentVisitor.visitAnnotation(annotation.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n = this.invisibleAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                annotation = this.invisibleAnnotations.get(i2);
                annotation.accept(recordComponentVisitor.visitAnnotation(annotation.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.visibleTypeAnnotations.get(i2);
                typeAnnotation.accept(recordComponentVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i2);
                typeAnnotation.accept(recordComponentVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.attrs != null) {
            n = this.attrs.size();
            for (i2 = 0; i2 < n; ++i2) {
                recordComponentVisitor.visitAttribute(this.attrs.get(i2));
            }
        }
        recordComponentVisitor.visitEnd();
    }
}

