/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.impl.asm.tree;

import java.util.List;
import org.pkl.thirdparty.truffle.api.impl.asm.MethodVisitor;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.LabelNode;
import org.pkl.thirdparty.truffle.api.impl.asm.tree.TypeAnnotationNode;

public class TryCatchBlockNode {
    public LabelNode start;
    public LabelNode end;
    public LabelNode handler;
    public String type;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;

    public TryCatchBlockNode(LabelNode start2, LabelNode end2, LabelNode handler, String type2) {
        this.start = start2;
        this.end = end2;
        this.handler = handler;
        this.type = type2;
    }

    public void updateIndex(int index) {
        int i2;
        int n;
        int newTypeRef = 0x42000000 | index << 8;
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                this.visibleTypeAnnotations.get((int)i2).typeRef = newTypeRef;
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                this.invisibleTypeAnnotations.get((int)i2).typeRef = newTypeRef;
            }
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        TypeAnnotationNode typeAnnotation;
        int i2;
        int n;
        methodVisitor.visitTryCatchBlock(this.start.getLabel(), this.end.getLabel(), this.handler == null ? null : this.handler.getLabel(), this.type);
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.visibleTypeAnnotations.get(i2);
                typeAnnotation.accept(methodVisitor.visitTryCatchAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i2);
                typeAnnotation.accept(methodVisitor.visitTryCatchAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
    }
}

