/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.instrumentation;

import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.pkl.thirdparty.truffle.api.instrumentation.InstrumentableNode;
import org.pkl.thirdparty.truffle.api.instrumentation.NearestSectionFilter;
import org.pkl.thirdparty.truffle.api.instrumentation.Tag;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

final class NearestNodesCollector {
    private final Position position;
    private final boolean anchorBefore;
    private final Set<Class<? extends Tag>> tags;
    private InstrumentableNode exactLineNode;
    private SourceSection exactLineSection;
    private InstrumentableNode exactIndexNode;
    private SourceSection exactIndexSection;
    private SourceSection containsSection;
    private LinkedNodes containsNode;
    private SourceSection previousSection;
    private LinkedNodes previousNode;
    private SourceSection nextSection;
    private LinkedNodes nextNode;
    private boolean isOffsetInRoot = false;

    NearestNodesCollector(NearestSectionFilter nearestFilter) {
        this.position = nearestFilter.getPosition();
        this.anchorBefore = nearestFilter.isAnchorStart();
        this.tags = nearestFilter.getTagClasses();
    }

    Position getPosition() {
        return this.position;
    }

    void loadedSection(Node node, SourceSection sourceSection, SourceSection rootSection) {
        Position p2;
        InstrumentableNode inode;
        assert (node instanceof InstrumentableNode && ((InstrumentableNode)((Object)node)).isInstrumentable());
        if (!this.isOffsetInRoot && rootSection != null) {
            boolean is = this.position.isIn(rootSection);
            if (!is && rootSection.hasLines() && rootSection.getStartLine() == rootSection.getEndLine()) {
                is = Position.startOf(rootSection).isLessThanOrEqual(this.position) && this.position.isLessThanOrEqual(Position.endOf(sourceSection));
            }
            this.isOffsetInRoot = is;
        }
        if (this.matchSectionLine(inode = (InstrumentableNode)((Object)node), sourceSection)) {
            return;
        }
        Position p1 = Position.startOf(sourceSection);
        if (this.matchSectionPosition(inode, sourceSection, p1, p2 = Position.endOf(sourceSection))) {
            return;
        }
        this.findOffsetApproximation(inode, sourceSection, p1, p2);
    }

    private static int getOffset(Source source2, int line, int column) {
        if (!source2.hasCharacters()) {
            return -1;
        }
        int offset = source2.getLineStartOffset(line);
        if (column > 0) {
            int c = Math.min(column, source2.getLineLength(line) + 1);
            offset += c - 1;
        }
        return offset;
    }

    private static boolean isEnclosing(SourceSection section2, SourceSection enclosingSection) {
        Position s1 = Position.startOf(section2);
        Position s2 = Position.endOf(section2);
        Position es1 = Position.startOf(enclosingSection);
        Position es2 = Position.endOf(enclosingSection);
        return es1.isLessThanOrEqual(s1) && s2.isLessThan(es2) || es1.isLessThan(s1) && s2.isLessThanOrEqual(es2);
    }

    private static boolean isTaggedWith(InstrumentableNode node, Set<Class<? extends Tag>> tags) {
        if (tags == null) {
            return true;
        }
        for (Class<? extends Tag> tag : tags) {
            if (!node.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSectionLine(InstrumentableNode node, SourceSection sourceSection) {
        if (this.position.line > 0 && this.position.column <= 0) {
            int l;
            int n = l = this.anchorBefore ? sourceSection.getStartLine() : sourceSection.getEndLine();
            if (this.position.line == l && NearestNodesCollector.isTaggedWith(node, this.tags)) {
                boolean match = false;
                if (this.exactLineSection == null) {
                    match = true;
                } else if (this.anchorBefore) {
                    Position ep1;
                    Position p1 = Position.startOf(sourceSection);
                    if (p1.isLessThan(ep1 = Position.startOf(this.exactLineSection)) || p1.equals(ep1) && Position.endOf(sourceSection).isGreaterThan(Position.endOf(this.exactLineSection))) {
                        match = true;
                    }
                } else {
                    Position ep2;
                    Position p2 = Position.endOf(sourceSection);
                    if (p2.isGreaterThan(ep2 = Position.endOf(this.exactLineSection)) || p2.equals(ep2) && Position.startOf(sourceSection).isLessThan(Position.startOf(this.exactLineSection))) {
                        match = true;
                    }
                }
                if (match) {
                    this.exactLineSection = sourceSection;
                    this.exactLineNode = node;
                }
            }
            if (this.exactLineSection != null) {
                return true;
            }
        }
        return false;
    }

    private boolean matchSectionPosition(InstrumentableNode node, SourceSection sourceSection, Position p1, Position p2) {
        Position p3;
        Position position = p3 = this.anchorBefore ? p1 : p2;
        if (this.position.equals(p3) && NearestNodesCollector.isTaggedWith(node, this.tags) && (this.exactIndexSection == null || this.anchorBefore && p2.isGreaterThan(Position.endOf(this.exactIndexSection)) || !this.anchorBefore && p1.isLessThan(Position.startOf(this.exactIndexSection)))) {
            this.exactIndexSection = sourceSection;
            this.exactIndexNode = node;
        }
        return this.exactIndexSection != null;
    }

    private void findOffsetApproximation(InstrumentableNode node, SourceSection sourceSection, Position p1, Position p2) {
        if (p1.isLessThanOrEqual(this.position) && this.position.isLessThanOrEqual(p2)) {
            if (this.containsSection == null || NearestNodesCollector.isEnclosing(sourceSection, this.containsSection)) {
                this.containsSection = sourceSection;
                this.containsNode = new LinkedNodes(node);
            } else if (this.containsSection.equals(sourceSection)) {
                this.containsNode.append(new LinkedNodes(node));
            }
        } else if (p2.isLessThan(this.position)) {
            if (this.previousSection == null || Position.endOf(this.previousSection).isLessThan(Position.endOf(sourceSection)) || Position.endOf(this.previousSection).equals(Position.endOf(sourceSection)) && Position.startOf(this.previousSection).isLessThan(Position.startOf(sourceSection))) {
                this.previousSection = sourceSection;
                this.previousNode = new LinkedNodes(node);
            } else if (this.previousSection.equals(sourceSection)) {
                this.previousNode.append(new LinkedNodes(node));
            }
        } else {
            assert (this.position.isLessThan(p1));
            if (this.nextSection == null || Position.startOf(this.nextSection).isGreaterThan(Position.startOf(sourceSection)) || Position.startOf(this.nextSection).equals(Position.startOf(sourceSection)) && Position.endOf(this.nextSection).isLessThan(Position.endOf(sourceSection))) {
                this.nextSection = sourceSection;
                this.nextNode = new LinkedNodes(node);
            } else if (this.nextSection.equals(sourceSection)) {
                this.nextNode.append(new LinkedNodes(node));
            }
        }
    }

    private InstrumentableNode getContainsNode() {
        if (this.containsNode == null) {
            return null;
        }
        if (this.anchorBefore && this.position.equals(Position.startOf(this.containsSection)) || !this.anchorBefore && this.position.equals(Position.endOf(this.containsSection))) {
            return (InstrumentableNode)((Object)this.containsNode.getOuter(this.containsSection));
        }
        return (InstrumentableNode)((Object)this.containsNode.getInner(this.containsSection));
    }

    private InstrumentableNode getPreviousNode() {
        if (this.previousNode == null) {
            return null;
        }
        return (InstrumentableNode)((Object)this.previousNode.getOuter(this.previousSection));
    }

    private InstrumentableNode getNextNode() {
        if (this.nextNode == null) {
            return null;
        }
        return (InstrumentableNode)((Object)this.nextNode.getOuter(this.nextSection));
    }

    private boolean isOtherInWithPosition(Node contains2, Node otherNode, SourceSection otherSection) {
        SourceSection nextRootSection;
        RootNode otherRoot;
        RootNode containsRoot;
        return NearestNodesCollector.isEnclosing(otherSection, this.containsSection) && (containsRoot = contains2.getRootNode()) != (otherRoot = otherNode.getRootNode()) && this.position.isIn(nextRootSection = otherRoot.getSourceSection());
    }

    NodeSection getNearest(Set<Class<? extends Tag>> allProvidedTags) {
        SourceSection nearestSection;
        Node nearestNode;
        if (this.exactLineNode != null) {
            nearestNode = (Node)((Object)this.exactLineNode);
            nearestSection = this.exactLineSection;
        } else if (this.exactIndexNode != null) {
            nearestNode = (Node)((Object)this.exactIndexNode);
            nearestSection = this.exactIndexSection;
        } else {
            InstrumentableNode contextNode = null;
            InstrumentableNode contains2 = this.getContainsNode();
            InstrumentableNode next = this.getNextNode();
            InstrumentableNode previous = this.getPreviousNode();
            if (contains2 != null && next != null && this.isOtherInWithPosition((Node)((Object)contains2), (Node)((Object)next), this.nextSection)) {
                contextNode = next;
            }
            if (contextNode == null && contains2 != null && previous != null && this.isOtherInWithPosition((Node)((Object)contains2), (Node)((Object)previous), this.previousSection)) {
                contextNode = previous;
            }
            if (contextNode == null) {
                contextNode = contains2;
            }
            if (contextNode == null) {
                contextNode = next;
            }
            if (contextNode == null) {
                contextNode = previous;
            }
            if (contextNode == null) {
                return null;
            }
            if (!this.isOffsetInRoot) {
                boolean onLineBeforeLocation;
                SourceSection sourceSection = ((Node)((Object)contextNode)).getSourceSection();
                boolean bl = onLineBeforeLocation = sourceSection != null && this.anchorBefore && sourceSection.hasLines() && this.position.line == sourceSection.getStartLine() && (!sourceSection.hasColumns() || this.position.column <= sourceSection.getStartColumn());
                if (!onLineBeforeLocation) {
                    return null;
                }
            }
            SourceSection contextSection = ((Node)((Object)contextNode)).getSourceSection();
            int offset = this.position.offset;
            if (offset < 0 && this.position.column >= 1) {
                offset = NearestNodesCollector.getOffset(contextSection.getSource(), this.position.line, this.position.column);
            }
            Set<Class<? extends Tag>> theTags = this.tags != null ? this.tags : allProvidedTags;
            Node node = offset >= 0 && contextSection.hasCharIndex() ? contextNode.findNearestNodeAt(offset, theTags) : contextNode.findNearestNodeAt(this.position.line, this.position.column, theTags);
            if (node == null) {
                return null;
            }
            nearestNode = node;
            nearestSection = node.getSourceSection();
        }
        return new NodeSection(nearestNode, nearestSection);
    }

    static boolean isCloser(NodeSection newNearest, SourceSection rootSourceSection, Node oldNearestNode, SourceSection oldNearestSourceSection, NearestSectionFilter filter2, Set<Class<? extends Tag>> allTags) {
        SourceSection oldRootSection = oldNearestNode.getRootNode().getSourceSection();
        if (oldRootSection != null && rootSourceSection != null && !oldRootSection.equals(rootSourceSection)) {
            if (NearestNodesCollector.isEnclosing(oldRootSection, rootSourceSection) && filter2.getPosition().isIn(oldRootSection)) {
                return false;
            }
            if (NearestNodesCollector.isEnclosing(rootSourceSection, oldRootSection) && filter2.getPosition().isIn(rootSourceSection)) {
                return true;
            }
        }
        NearestNodesCollector collector = new NearestNodesCollector(filter2);
        collector.loadedSection(oldNearestNode, oldNearestSourceSection, oldRootSection);
        collector.loadedSection(newNearest.node, newNearest.section, rootSourceSection);
        NodeSection nearest = collector.getNearest(allTags);
        return newNearest.section.equals(nearest.section);
    }

    static final class Position {
        private final int line;
        private final int column;
        private final int offset;
        static Comparator<? super Position> COMPARATOR = new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                if (p1.equals(p2)) {
                    return 0;
                }
                if (p1.isLessThan(p2)) {
                    return -1;
                }
                return 1;
            }
        };

        Position(int line, int column, int offset) {
            this.line = line;
            this.column = column;
            this.offset = offset;
            assert (offset >= 0 || line >= 1) : this.toString();
        }

        static Position startOf(SourceSection section2) {
            int line = section2.hasLines() ? section2.getStartLine() : -1;
            int column = section2.hasColumns() ? section2.getStartColumn() : -1;
            int offset = section2.hasCharIndex() ? section2.getCharIndex() : -1;
            return new Position(line, column, offset);
        }

        static Position endOf(SourceSection section2) {
            int column;
            int line = section2.hasLines() ? section2.getEndLine() : -1;
            int n = column = section2.hasColumns() ? section2.getEndColumn() : -1;
            int offset = section2.hasCharIndex() ? (section2.getCharLength() > 0 ? section2.getCharEndIndex() - 1 : section2.getCharIndex()) : -1;
            return new Position(line, column, offset);
        }

        boolean isIn(SourceSection section2) {
            if (this.offset >= 0 && section2.hasCharIndex()) {
                return section2.getCharIndex() <= this.offset && this.offset < section2.getCharEndIndex();
            }
            if (this.line > 0 && section2.hasLines() && section2.getStartLine() <= this.line && this.line <= section2.getEndLine()) {
                if (section2.hasColumns()) {
                    int theColumn;
                    int n = theColumn = this.column > 0 ? this.column : 1;
                    if (section2.getStartLine() == this.line && theColumn < section2.getStartColumn()) {
                        return false;
                    }
                    if (section2.getEndLine() == this.line && section2.getEndColumn() < theColumn) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + this.line;
            hash = 29 * hash + this.column;
            hash = 29 * hash + this.offset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Position) {
                Position other = (Position)obj;
                if (this.offset >= 0 && other.offset >= 0) {
                    return this.offset == other.offset;
                }
                if (this.line != other.line) {
                    return false;
                }
                if (this.column > 0 && other.column > 0) {
                    return this.column == other.column;
                }
                return true;
            }
            return false;
        }

        boolean isLessThan(Position other) {
            if (this.offset >= 0 && other.offset >= 0) {
                return this.offset < other.offset;
            }
            if (0 < this.line && this.line < other.line) {
                return true;
            }
            return this.line == other.line && 0 < this.column && this.column < other.column;
        }

        boolean isLessThanOrEqual(Position other) {
            if (this.offset >= 0 && other.offset >= 0) {
                return this.offset <= other.offset;
            }
            if (0 < this.line && this.line < other.line) {
                return true;
            }
            return this.line == other.line && (0 < this.column && this.column <= other.column || this.column <= 0 || other.column <= 0);
        }

        boolean isGreaterThan(Position other) {
            return other.isLessThan(this);
        }

        boolean isGreaterThanOrEqual(Position other) {
            return other.isGreaterThanOrEqual(this);
        }

        public String toString() {
            return "Position[(" + this.line + ", " + this.column + ") offset: " + this.offset + "]";
        }
    }

    private static final class LinkedNodes {
        final Node node;
        private LinkedNodes next;

        LinkedNodes(InstrumentableNode node) {
            this.node = (Node)((Object)node);
        }

        void append(LinkedNodes lns) {
            LinkedNodes tail = this;
            while (tail.next != null) {
                tail = tail.next;
            }
            tail.next = lns;
        }

        Node getInner(SourceSection section2) {
            Node inner = this.node;
            LinkedNodes linkedNodes = this.next;
            while (linkedNodes != null) {
                Node inner2 = linkedNodes.node;
                if (!LinkedNodes.isParentOf(inner, inner2)) {
                    if (LinkedNodes.isParentOf(inner2, inner)) {
                        inner = inner2;
                    } else if (!LinkedNodes.hasLargerParent(inner2, section2)) {
                        inner = inner2;
                    }
                }
                linkedNodes = linkedNodes.next;
            }
            return inner;
        }

        Node getOuter(SourceSection section2) {
            Node outer = this.node;
            LinkedNodes linkedNodes = this.next;
            while (linkedNodes != null) {
                Node outer2 = linkedNodes.node;
                if (LinkedNodes.isParentOf(outer, outer2)) {
                    outer = outer2;
                } else if (!LinkedNodes.isParentOf(outer2, outer) && LinkedNodes.hasLargerParent(outer2, section2)) {
                    outer = outer2;
                }
                linkedNodes = linkedNodes.next;
            }
            return outer;
        }

        public String toString() {
            if (this.next == null) {
                return this.node.toString();
            }
            StringBuilder sb = new StringBuilder("[");
            LinkedNodes ln = this;
            while (ln != null) {
                sb.append(ln.node);
                sb.append(", ");
                ln = ln.next;
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("]");
            return sb.toString();
        }

        private static boolean isParentOf(Node ch, Node p2) {
            for (Node parent = ch.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != p2) continue;
                return true;
            }
            return false;
        }

        private static boolean hasLargerParent(Node ch, SourceSection section2) {
            for (Node parent = ch.getParent(); parent != null; parent = parent.getParent()) {
                SourceSection pss;
                if ((!(parent instanceof InstrumentableNode) || !((InstrumentableNode)((Object)parent)).isInstrumentable()) && !(parent instanceof RootNode) || (pss = parent.getSourceSection()) == null || !NearestNodesCollector.isEnclosing(section2, pss)) continue;
                return true;
            }
            return false;
        }
    }

    static final class NodeSection {
        final Node node;
        final SourceSection section;

        NodeSection(Node node, SourceSection section2) {
            this.node = node;
            this.section = section2;
        }
    }

    static final class NodeListSection {
        final List<WeakReference<Node>> nodes;
        final SourceSection section;

        NodeListSection(List<WeakReference<Node>> nodes, SourceSection section2) {
            this.nodes = nodes;
            this.section = section2;
        }
    }
}

