/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.interop;

import java.math.BigInteger;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class, receiverType=Integer.class)
final class DefaultIntegerExports {
    DefaultIntegerExports() {
    }

    @ExportMessage
    static boolean isNumber(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInByte(Integer receiver) {
        int i2 = receiver;
        byte b2 = (byte)i2;
        return b2 == i2;
    }

    @ExportMessage
    static boolean fitsInShort(Integer receiver) {
        int i2 = receiver;
        short s2 = (short)i2;
        return s2 == i2;
    }

    @ExportMessage
    static boolean fitsInFloat(Integer receiver) {
        int i2 = receiver;
        float f = i2;
        return i2 != Integer.MAX_VALUE && (int)f == i2;
    }

    @ExportMessage
    static byte asByte(Integer receiver) throws UnsupportedMessageException {
        int i2 = receiver;
        byte b2 = (byte)i2;
        if (b2 == i2) {
            return b2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Integer receiver) throws UnsupportedMessageException {
        int i2 = receiver;
        short s2 = (short)i2;
        if (s2 == i2) {
            return s2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static float asFloat(Integer receiver) throws UnsupportedMessageException {
        int i2 = receiver;
        float f = i2;
        if (i2 != Integer.MAX_VALUE && (int)f == i2) {
            return f;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean fitsInInt(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInLong(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInBigInteger(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInDouble(Integer receiver) {
        return true;
    }

    @ExportMessage
    static int asInt(Integer receiver) {
        return receiver;
    }

    @ExportMessage
    static long asLong(Integer receiver) {
        return receiver.intValue();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static BigInteger asBigInteger(Integer receiver) {
        return BigInteger.valueOf(receiver.intValue());
    }

    @ExportMessage
    static double asDouble(Integer receiver) {
        return receiver.intValue();
    }

    @ExportMessage
    static boolean hasLanguage(Integer receiver) {
        return false;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(Integer receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasSourceLocation(Integer receiver) {
        return false;
    }

    @ExportMessage
    static SourceSection getSourceLocation(Integer receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(Integer receiver) {
        return false;
    }

    @ExportMessage
    static Object getMetaObject(Integer receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object toDisplayString(Integer receiver, boolean allowSideEffects) {
        return receiver.toString();
    }
}

