/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.interop;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.impl.Accessor;
import org.pkl.thirdparty.truffle.api.interop.ArityException;
import org.pkl.thirdparty.truffle.api.interop.ArrayIterator;
import org.pkl.thirdparty.truffle.api.interop.AssertUtils;
import org.pkl.thirdparty.truffle.api.interop.DefaultBooleanExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultByteExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultCharacterExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultDoubleExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultFloatExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultIntegerExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultLongExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultShortExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultStringExports;
import org.pkl.thirdparty.truffle.api.interop.DefaultTStringExports;
import org.pkl.thirdparty.truffle.api.interop.ExceptionType;
import org.pkl.thirdparty.truffle.api.interop.HashIterator;
import org.pkl.thirdparty.truffle.api.interop.InteropAccessor;
import org.pkl.thirdparty.truffle.api.interop.InteropException;
import org.pkl.thirdparty.truffle.api.interop.InvalidArrayIndexException;
import org.pkl.thirdparty.truffle.api.interop.InvalidBufferOffsetException;
import org.pkl.thirdparty.truffle.api.interop.NumberUtils;
import org.pkl.thirdparty.truffle.api.interop.StopIterationException;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnknownIdentifierException;
import org.pkl.thirdparty.truffle.api.interop.UnknownKeyException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.GenerateLibrary;
import org.pkl.thirdparty.truffle.api.library.Library;
import org.pkl.thirdparty.truffle.api.library.LibraryFactory;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;
import org.pkl.thirdparty.truffle.api.utilities.TriState;

@GenerateLibrary(assertions=Asserts.class, receiverType=TruffleObject.class)
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=DefaultBooleanExports.class), @GenerateLibrary.DefaultExport(value=DefaultIntegerExports.class), @GenerateLibrary.DefaultExport(value=DefaultByteExports.class), @GenerateLibrary.DefaultExport(value=DefaultShortExports.class), @GenerateLibrary.DefaultExport(value=DefaultLongExports.class), @GenerateLibrary.DefaultExport(value=DefaultFloatExports.class), @GenerateLibrary.DefaultExport(value=DefaultDoubleExports.class), @GenerateLibrary.DefaultExport(value=DefaultCharacterExports.class), @GenerateLibrary.DefaultExport(value=DefaultStringExports.class), @GenerateLibrary.DefaultExport(value=DefaultTStringExports.class)})
public abstract class InteropLibrary
extends Library {
    static final LibraryFactory<InteropLibrary> FACTORY = LibraryFactory.resolve(InteropLibrary.class);
    static final InteropLibrary UNCACHED = FACTORY.getUncached();

    protected InteropLibrary() {
    }

    public boolean isNull(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"asBoolean"})
    public boolean isBoolean(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isBoolean"})
    public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"execute"})
    public boolean isExecutable(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isExecutable"})
    public Object execute(Object receiver, Object ... arguments2) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getExecutableName"})
    public boolean hasExecutableName(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasExecutableName"})
    public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getDeclaringMetaObject"})
    public boolean hasDeclaringMetaObject(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasDeclaringMetaObject"})
    public Object getDeclaringMetaObject(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"instantiate"})
    public boolean isInstantiable(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isInstantiable"})
    public Object instantiate(Object receiver, Object ... arguments2) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asString", "asTruffleString"})
    public boolean isString(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isString"})
    public String asString(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public TruffleString asTruffleString(Object receiver) throws UnsupportedMessageException {
        return TruffleString.fromJavaStringUncached(this.asString(receiver), TruffleString.Encoding.UTF_16);
    }

    @GenerateLibrary.Abstract(ifExported={"fitsInByte", "fitsInShort", "fitsInInt", "fitsInLong", "fitsInBigInteger", "fitsInFloat", "fitsInDouble", "asByte", "asShort", "asInt", "asLong", "asBigInteger", "asFloat", "asDouble"})
    public boolean isNumber(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInByte(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInShort(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInInt(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInLong(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExportedAsWarning={"isNumber"})
    public boolean fitsInBigInteger(Object receiver) {
        try {
            if (this.fitsInLong(receiver)) {
                return true;
            }
            if (this.fitsInDouble(receiver)) {
                double doubleValue = this.asDouble(receiver);
                return doubleValue % 1.0 == 0.0 && !NumberUtils.isNegativeZero(doubleValue);
            }
            return false;
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInFloat(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public boolean fitsInDouble(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public byte asByte(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public short asShort(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public int asInt(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public long asLong(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExportedAsWarning={"isNumber"})
    public BigInteger asBigInteger(Object receiver) throws UnsupportedMessageException {
        double doubleValue;
        if (this.fitsInLong(receiver)) {
            long longValue = this.asLong(receiver);
            return InteropLibrary.toBigInteger(longValue);
        }
        if (this.fitsInDouble(receiver) && (doubleValue = this.asDouble(receiver)) % 1.0 == 0.0 && !NumberUtils.isNegativeZero(doubleValue)) {
            return InteropLibrary.toBigInteger(doubleValue);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger toBigInteger(long longValue) {
        return BigInteger.valueOf(longValue);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger toBigInteger(double doubleValue) {
        try {
            return new BigDecimal(doubleValue).toBigIntegerExact();
        }
        catch (ArithmeticException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public float asFloat(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isNumber"})
    public double asDouble(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getMembers", "isMemberReadable", "readMember", "isMemberModifiable", "isMemberInsertable", "writeMember", "isMemberRemovable", "removeMember", "isMemberInvocable", "invokeMember", "isMemberInternal", "hasMemberReadSideEffects", "hasMemberWriteSideEffects", "isScope"})
    public boolean hasMembers(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasMembers", "isScope"})
    public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public final Object getMembers(Object receiver) throws UnsupportedMessageException {
        return this.getMembers(receiver, false);
    }

    @GenerateLibrary.Abstract(ifExported={"readMember"})
    public boolean isMemberReadable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberReadable"})
    public Object readMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"writeMember"})
    public boolean isMemberModifiable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeMember"})
    public boolean isMemberInsertable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberModifiable", "isMemberInsertable"})
    public void writeMember(Object receiver, String member, Object value2) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"removeMember"})
    public boolean isMemberRemovable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberRemovable"})
    public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"invokeMember"})
    public boolean isMemberInvocable(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMemberInvocable"})
    public Object invokeMember(Object receiver, String member, Object ... arguments2) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
        throw UnsupportedMessageException.create();
    }

    public boolean isMemberInternal(Object receiver, String member) {
        return false;
    }

    public final boolean isMemberWritable(Object receiver, String member) {
        return this.isMemberModifiable(receiver, member) || this.isMemberInsertable(receiver, member);
    }

    public final boolean isMemberExisting(Object receiver, String member) {
        return this.isMemberReadable(receiver, member) || this.isMemberModifiable(receiver, member) || this.isMemberRemovable(receiver, member) || this.isMemberInvocable(receiver, member);
    }

    public boolean hasMemberReadSideEffects(Object receiver, String member) {
        return false;
    }

    public boolean hasMemberWriteSideEffects(Object receiver, String member) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"getHashSize", "isHashEntryReadable", "readHashValue", "readHashValueOrDefault", "isHashEntryModifiable", "isHashEntryInsertable", "writeHashEntry", "isHashEntryRemovable", "removeHashEntry", "getHashEntriesIterator", "getHashKeysIterator", "getHashValuesIterator"})
    public boolean hasHashEntries(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasHashEntries"})
    public long getHashSize(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"readHashValue"})
    public boolean isHashEntryReadable(Object receiver, Object key2) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isHashEntryReadable"})
    public Object readHashValue(Object receiver, Object key2) throws UnsupportedMessageException, UnknownKeyException {
        throw UnsupportedMessageException.create();
    }

    public Object readHashValueOrDefault(Object receiver, Object key2, Object defaultValue) throws UnsupportedMessageException {
        try {
            return this.readHashValue(receiver, key2);
        }
        catch (UnknownKeyException e2) {
            return defaultValue;
        }
    }

    @GenerateLibrary.Abstract(ifExported={"writeHashEntry"})
    public boolean isHashEntryModifiable(Object receiver, Object key2) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeHashEntry"})
    public boolean isHashEntryInsertable(Object receiver, Object key2) {
        return false;
    }

    public boolean isHashEntryWritable(Object receiver, Object key2) {
        return this.isHashEntryModifiable(receiver, key2) || this.isHashEntryInsertable(receiver, key2);
    }

    @GenerateLibrary.Abstract(ifExported={"isHashEntryModifiable", "isHashEntryInsertable"})
    public void writeHashEntry(Object receiver, Object key2, Object value2) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"removeHashEntry"})
    public boolean isHashEntryRemovable(Object receiver, Object key2) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isHashEntryRemovable"})
    public void removeHashEntry(Object receiver, Object key2) throws UnsupportedMessageException, UnknownKeyException {
        throw UnsupportedMessageException.create();
    }

    public boolean isHashEntryExisting(Object receiver, Object key2) {
        return this.isHashEntryReadable(receiver, key2) || this.isHashEntryModifiable(receiver, key2) || this.isHashEntryRemovable(receiver, key2);
    }

    @GenerateLibrary.Abstract(ifExported={"hasHashEntries"})
    public Object getHashEntriesIterator(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public Object getHashKeysIterator(Object receiver) throws UnsupportedMessageException {
        Object entriesIterator = this.getHashEntriesIterator(receiver);
        return HashIterator.keys(entriesIterator);
    }

    public Object getHashValuesIterator(Object receiver) throws UnsupportedMessageException {
        Object entriesIterator = this.getHashEntriesIterator(receiver);
        return HashIterator.values(entriesIterator);
    }

    @GenerateLibrary.Abstract(ifExported={"readArrayElement", "writeArrayElement", "removeArrayElement", "isArrayElementModifiable", "isArrayElementRemovable", "isArrayElementReadable", "getArraySize"})
    public boolean hasArrayElements(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public long getArraySize(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasArrayElements"})
    public boolean isArrayElementReadable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isArrayElementModifiable", "isArrayElementInsertable"})
    public void writeArrayElement(Object receiver, long index, Object value2) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isArrayElementRemovable"})
    public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"writeArrayElement"})
    public boolean isArrayElementModifiable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeArrayElement"})
    public boolean isArrayElementInsertable(Object receiver, long index) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"removeArrayElement"})
    public boolean isArrayElementRemovable(Object receiver, long index) {
        return false;
    }

    public final boolean isArrayElementWritable(Object receiver, long index) {
        return this.isArrayElementModifiable(receiver, index) || this.isArrayElementInsertable(receiver, index);
    }

    public final boolean isArrayElementExisting(Object receiver, long index) {
        return this.isArrayElementModifiable(receiver, index) || this.isArrayElementReadable(receiver, index) || this.isArrayElementRemovable(receiver, index);
    }

    @GenerateLibrary.Abstract(ifExported={"getBufferSize", "isBufferWritable", "readBufferByte", "readBufferShort", "readBufferInt", "readBufferLong", "readBufferFloat", "readBufferDouble", "writeBufferByte", "writeBufferShort", "writeBufferInt", "writeBufferLong", "writeBufferFloat", "writeBufferDouble"})
    public boolean hasBufferElements(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"writeBufferByte", "writeBufferShort", "writeBufferInt", "writeBufferLong", "writeBufferFloat", "writeBufferDouble"})
    public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
        if (this.hasBufferElements(receiver)) {
            return false;
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public long getBufferSize(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferByte(Object receiver, long byteOffset, byte value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasBufferElements"})
    public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isBufferWritable"})
    public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asPointer"})
    public boolean isPointer(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isPointer"})
    public long asPointer(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public void toNative(Object receiver) {
    }

    public Instant asInstant(Object receiver) throws UnsupportedMessageException {
        if (this.isDate(receiver) && this.isTime(receiver) && this.isTimeZone(receiver)) {
            LocalDate date = this.asDate(receiver);
            LocalTime time2 = this.asTime(receiver);
            ZoneId zone = this.asTimeZone(receiver);
            return InteropLibrary.toInstant(date, time2, zone);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    private static Instant toInstant(LocalDate date, LocalTime time2, ZoneId zone) {
        return ZonedDateTime.of(date, time2, zone).toInstant();
    }

    public final boolean isInstant(Object receiver) {
        return this.isDate(receiver) && this.isTime(receiver) && this.isTimeZone(receiver);
    }

    @GenerateLibrary.Abstract(ifExported={"asTimeZone", "asInstant"})
    public boolean isTimeZone(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isTimeZone", "asInstant"})
    public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asDate", "asInstant"})
    public boolean isDate(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isDate", "asInstant"})
    public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asTime", "asInstant"})
    public boolean isTime(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isTime", "asInstant"})
    public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"asDuration"})
    public boolean isDuration(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isDuration"})
    public Duration asDuration(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"throwException"})
    public boolean isException(Object receiver) {
        return InteropAccessor.EXCEPTION.isException(receiver);
    }

    @GenerateLibrary.Abstract(ifExported={"isException"})
    public RuntimeException throwException(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            throw InteropAccessor.EXCEPTION.throwException(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getExceptionExitStatus", "isExceptionIncompleteSource"})
    public ExceptionType getExceptionType(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return (ExceptionType)((Object)InteropAccessor.EXCEPTION.getExceptionType(receiver));
        }
        throw UnsupportedMessageException.create();
    }

    public boolean isExceptionIncompleteSource(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.isExceptionIncompleteSource(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    public int getExceptionExitStatus(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.getExceptionExitStatus(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getExceptionCause"})
    public boolean hasExceptionCause(Object receiver) {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.hasExceptionCause(receiver);
        }
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasExceptionCause"})
    public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.getExceptionCause(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getExceptionMessage"})
    public boolean hasExceptionMessage(Object receiver) {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.hasExceptionMessage(receiver);
        }
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasExceptionMessage"})
    public Object getExceptionMessage(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.getExceptionMessage(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getExceptionStackTrace"})
    public boolean hasExceptionStackTrace(Object receiver) {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.hasExceptionStackTrace(receiver);
        }
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasExceptionStackTrace"})
    public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.getExceptionStackTrace(receiver, null);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getIterator"})
    public boolean hasIterator(Object receiver) {
        return this.hasArrayElements(receiver);
    }

    @GenerateLibrary.Abstract(ifExported={"hasIterator"})
    public Object getIterator(Object receiver) throws UnsupportedMessageException {
        if (!this.hasIterator(receiver)) {
            throw UnsupportedMessageException.create();
        }
        return new ArrayIterator(receiver);
    }

    @GenerateLibrary.Abstract(ifExported={"hasIteratorNextElement", "getIteratorNextElement"})
    public boolean isIterator(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isIterator", "getIteratorNextElement"})
    public boolean hasIteratorNextElement(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isIterator", "hasIteratorNextElement"})
    public Object getIteratorNextElement(Object receiver) throws UnsupportedMessageException, StopIterationException {
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"getSourceLocation"})
    public boolean hasSourceLocation(Object receiver) {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.hasSourceLocation(receiver);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasSourceLocation"})
    public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
        if (InteropAccessor.EXCEPTION.isException(receiver)) {
            return InteropAccessor.EXCEPTION.getSourceLocation(receiver);
        }
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getLanguage", "isScope"})
    public boolean hasLanguage(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasLanguage"})
    public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getMetaObject"})
    public boolean hasMetaObject(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasMetaObject"})
    public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @GenerateLibrary.Abstract(ifExported={"hasLanguage", "getLanguage", "isScope"})
    public Object toDisplayString(Object receiver, boolean allowSideEffects) {
        if (allowSideEffects) {
            return Objects.toString(receiver);
        }
        return receiver.getClass().getTypeName() + "@" + Integer.toHexString(System.identityHashCode(receiver));
    }

    public final Object toDisplayString(Object receiver) {
        return this.toDisplayString(receiver, true);
    }

    @GenerateLibrary.Abstract(ifExported={"getMetaQualifiedName", "getMetaSimpleName", "isMetaInstance"})
    public boolean isMetaObject(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public Object getMetaQualifiedName(Object metaObject) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public Object getMetaSimpleName(Object metaObject) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isMetaObject"})
    public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"getMetaParents"})
    public boolean hasMetaParents(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasMetaParents"})
    public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"isIdentical", "identityHashCode"})
    protected TriState isIdenticalOrUndefined(Object receiver, Object other) {
        return TriState.UNDEFINED;
    }

    public boolean isIdentical(Object receiver, Object other, InteropLibrary otherInterop) {
        TriState result2 = this.isIdenticalOrUndefined(receiver, other);
        if (result2 == TriState.UNDEFINED) {
            result2 = otherInterop.isIdenticalOrUndefined(other, receiver);
        }
        return result2 == TriState.TRUE;
    }

    public final boolean hasIdentity(Object receiver) {
        return this.isIdentical(receiver, receiver, this);
    }

    @GenerateLibrary.Abstract(ifExported={"isIdenticalOrUndefined"})
    public int identityHashCode(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract(ifExported={"hasScopeParent"})
    public boolean isScope(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"getScopeParent"})
    public boolean hasScopeParent(Object receiver) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"hasScopeParent"})
    public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public static LibraryFactory<InteropLibrary> getFactory() {
        return FACTORY;
    }

    public static InteropLibrary getUncached() {
        return UNCACHED;
    }

    public static InteropLibrary getUncached(Object v) {
        return FACTORY.getUncached(v);
    }

    protected final boolean assertAdopted() {
        assert (this.getRootNode() != null) : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidValue(Object receiver) {
        return receiver instanceof TruffleObject || receiver instanceof Boolean || receiver instanceof Byte || receiver instanceof Short || receiver instanceof Character || receiver instanceof Integer || receiver instanceof Long || receiver instanceof Float || receiver instanceof Double || receiver instanceof String || receiver instanceof TruffleString;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidProtocolValue(Object value2) {
        return InteropLibrary.isValidValue(value2) || value2 instanceof ByteOrder || value2 instanceof Instant || value2 instanceof ZoneId || value2 instanceof LocalDate || value2 instanceof LocalTime || value2 instanceof Duration || value2 instanceof ExceptionType || value2 instanceof SourceSection || value2 instanceof Class || value2 instanceof TriState || value2 instanceof InteropLibrary || value2 instanceof Object[] || value2 instanceof BigInteger;
    }

    static class Asserts
    extends InteropLibrary {
        @Node.Child
        private InteropLibrary delegate;

        Asserts(InteropLibrary delegate2) {
            this.delegate = delegate2;
        }

        private static boolean isMultiThreaded(Object receiver) {
            Accessor.EngineSupport engine = InteropAccessor.ACCESSOR.engineSupport();
            if (engine == null) {
                return false;
            }
            return engine.isMultiThreaded(receiver);
        }

        @Override
        public boolean accepts(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            return this.delegate.accepts(receiver);
        }

        @Override
        public boolean isNull(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isNull(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.NULL));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        private boolean notOtherType(Object receiver, Type type2) {
            assert (type2 == Type.NULL || !this.delegate.isNull(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.BOOLEAN || !this.delegate.isBoolean(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.STRING || !this.delegate.isString(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.NUMBER || !this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.DATE_TIME_ZONE || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver) && !this.delegate.isTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.DURATION || !this.delegate.isDuration(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.META_OBJECT || !this.delegate.isMetaObject(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (type2 == Type.ITERATOR || !this.delegate.isIterator(receiver)) : AssertUtils.violationInvariant(receiver);
            return true;
        }

        @Override
        public boolean isBoolean(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isBoolean(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isBoolean(receiver);
            if (result2) {
                try {
                    this.delegate.asBoolean(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!result2 || this.notOtherType(receiver, Type.BOOLEAN));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asBoolean(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasBoolean = this.delegate.isBoolean(receiver);
            try {
                boolean result2 = this.delegate.asBoolean(receiver);
                assert (wasBoolean) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.BOOLEAN));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasBoolean) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isExecutable(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isExecutable(receiver);
            return result2;
        }

        @Override
        public Object execute(Object receiver, Object ... arguments2) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.execute(receiver, arguments2);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, arguments2));
            assert (AssertUtils.validArguments(receiver, arguments2));
            boolean wasExecutable = this.delegate.isExecutable(receiver);
            try {
                Object result2 = this.delegate.execute(receiver, arguments2);
                assert (wasExecutable) : AssertUtils.violationInvariant(receiver, arguments2);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof ArityException || e2 instanceof UnsupportedTypeException) : AssertUtils.violationInvariant(receiver, arguments2);
                assert (!(e2 instanceof UnsupportedMessageException) || !wasExecutable) : AssertUtils.violationInvariant(receiver, arguments2);
                throw e2;
            }
        }

        @Override
        public boolean isInstantiable(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isInstantiable(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object instantiate(Object receiver, Object ... arguments2) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.instantiate(receiver, arguments2);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, arguments2));
            assert (AssertUtils.validArguments(receiver, arguments2));
            boolean wasInstantiable = this.delegate.isInstantiable(receiver);
            try {
                Object result2 = this.delegate.instantiate(receiver, arguments2);
                assert (wasInstantiable) : AssertUtils.violationInvariant(receiver, arguments2);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof ArityException || e2 instanceof UnsupportedTypeException) : AssertUtils.violationInvariant(receiver, arguments2);
                assert (!(e2 instanceof UnsupportedMessageException) || !wasInstantiable) : AssertUtils.violationInvariant(receiver, arguments2);
                throw e2;
            }
        }

        @Override
        public boolean isString(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isString(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isString(receiver);
            if (result2) {
                try {
                    this.delegate.asString(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!result2 || this.notOtherType(receiver, Type.STRING));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public String asString(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asString(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasString = this.delegate.isString(receiver);
            try {
                String result2 = this.delegate.asString(receiver);
                assert (wasString) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasString) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public TruffleString asTruffleString(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asTruffleString(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasString = this.delegate.isString(receiver);
            try {
                TruffleString result2 = this.delegate.asTruffleString(receiver);
                assert (wasString) : AssertUtils.violationInvariant(receiver);
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasString) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isNumber(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isNumber(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean fitsInByte(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInByte(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInByte(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInShort(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asByte(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInShort(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInShort(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInShort(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asShort(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInInt(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInInt(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInInt(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!fits || this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asInt(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInLong(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInLong(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInLong(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asLong(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInBigInteger(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInBigInteger(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInBigInteger(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asBigInteger(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInFloat(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInFloat(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInFloat(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asFloat(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public boolean fitsInDouble(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.fitsInDouble(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean fits = this.delegate.fitsInDouble(receiver);
            assert (!fits || this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
            if (fits) {
                try {
                    this.delegate.asDouble(receiver);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (!fits || this.notOtherType(receiver, Type.NUMBER));
            assert (AssertUtils.validProtocolReturn(receiver, fits));
            return fits;
        }

        @Override
        public byte asByte(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                byte result2 = this.delegate.asByte(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInByte(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result2 == this.delegate.asShort(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result2 == this.delegate.asInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result2 == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((float)result2 == this.delegate.asFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result2 == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public short asShort(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                short result2 = this.delegate.asShort(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInShort(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (result2 == this.delegate.asInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result2 == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((float)result2 == this.delegate.asFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result2 == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public int asInt(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                int result2 = this.delegate.asInt(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInInt(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((long)result2 == this.delegate.asLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert ((double)result2 == this.delegate.asDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public long asLong(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result2 = this.delegate.asLong(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInLong(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public BigInteger asBigInteger(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                BigInteger result2 = this.delegate.asBigInteger(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInBigInteger(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public float asFloat(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                float result2 = this.delegate.asFloat(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInFloat(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, Float.valueOf(result2)));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public double asDouble(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                double result2 = this.delegate.asDouble(receiver);
                assert (this.delegate.isNumber(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.fitsInDouble(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasMembers(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasMembers(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object readMember(Object receiver, String identifier) throws UnsupportedMessageException, UnknownIdentifierException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readMember(receiver, identifier);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean wasReadable = this.delegate.isMemberReadable(receiver, identifier);
            try {
                Object result2 = this.delegate.readMember(receiver, identifier);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasReadable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownIdentifierException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public void writeMember(Object receiver, String identifier, Object value2) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.writeMember(receiver, identifier, value2);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            assert (AssertUtils.validInteropArgument(receiver, value2));
            boolean wasWritable = this.delegate.isMemberModifiable(receiver, identifier) || this.delegate.isMemberInsertable(receiver, identifier);
            try {
                this.delegate.writeMember(receiver, identifier, value2);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasWritable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownIdentifierException || e2 instanceof UnsupportedTypeException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public void removeMember(Object receiver, String identifier) throws UnsupportedMessageException, UnknownIdentifierException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.removeMember(receiver, identifier);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean wasRemovable = this.delegate.isMemberRemovable(receiver, identifier);
            try {
                this.delegate.removeMember(receiver, identifier);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasRemovable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownIdentifierException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public Object invokeMember(Object receiver, String identifier, Object ... arguments2) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.invokeMember(receiver, identifier, arguments2);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            assert (AssertUtils.validProtocolArgument(receiver, arguments2));
            assert (AssertUtils.validArguments(receiver, arguments2));
            boolean wasInvocable = this.delegate.isMemberInvocable(receiver, identifier);
            try {
                Object result2 = this.delegate.invokeMember(receiver, identifier, arguments2);
                assert (this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (wasInvocable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof ArityException || e2 instanceof UnknownIdentifierException || e2 instanceof UnsupportedTypeException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public Object getMembers(Object receiver, boolean internal) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                Object result2 = this.delegate.getMembers(receiver, internal);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                assert (AssertUtils.validProtocolArgument(receiver, internal));
                assert (Asserts.isMultiThreaded(receiver) || Asserts.assertMemberKeys(receiver, result2, internal));
                assert (!this.delegate.hasScopeParent(receiver) || Asserts.assertScopeMembers(receiver, result2, Asserts.getUncached().getMembers(this.delegate.getScopeParent(receiver), internal)));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        private static boolean assertMemberKeys(Object receiver, Object result2, boolean internal) {
            long arraySize;
            assert (result2 != null) : AssertUtils.violationPost(receiver, result2);
            InteropLibrary uncached = InteropLibrary.getFactory().getUncached(result2);
            assert (uncached.hasArrayElements(result2)) : AssertUtils.violationPost(receiver, result2);
            try {
                arraySize = uncached.getArraySize(result2);
            }
            catch (UnsupportedMessageException e2) {
                assert (false) : AssertUtils.violationPost(receiver, e2);
                return true;
            }
            for (long i2 = 0L; i2 < arraySize; ++i2) {
                Object element;
                assert (uncached.isArrayElementReadable(result2, i2)) : AssertUtils.violationPost(receiver, result2);
                try {
                    element = uncached.readArrayElement(result2, i2);
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e3) {
                    assert (false) : AssertUtils.violationPost(receiver, result2);
                    return true;
                }
                assert (InteropLibrary.getFactory().getUncached().isString(element)) : AssertUtils.violationPost(receiver, element);
                try {
                    InteropLibrary.getFactory().getUncached().asString(element);
                    continue;
                }
                catch (UnsupportedMessageException e4) {
                    assert (false) : AssertUtils.violationInvariant(result2, i2);
                    continue;
                }
            }
            return true;
        }

        private static boolean assertScopeMembers(Object receiver, Object allMembers2, Object parentMembers) {
            long parentSize;
            long allSize;
            assert (parentMembers != null) : AssertUtils.violationPost(receiver, parentMembers);
            InteropLibrary allUncached = InteropLibrary.getUncached(allMembers2);
            InteropLibrary parentUncached = InteropLibrary.getUncached(parentMembers);
            assert (allUncached.hasArrayElements(allMembers2)) : AssertUtils.violationPost(receiver, allMembers2);
            assert (parentUncached.hasArrayElements(parentMembers)) : AssertUtils.violationPost(receiver, parentMembers);
            try {
                allSize = allUncached.getArraySize(allMembers2);
                parentSize = parentUncached.getArraySize(parentMembers);
            }
            catch (UnsupportedMessageException e2) {
                assert (false) : AssertUtils.violationPost(receiver, e2);
                return true;
            }
            assert (AssertUtils.validScopeMemberLengths(allSize, parentSize, allMembers2, parentMembers));
            long currentSize = allSize - parentSize;
            for (long i2 = 0L; i2 < parentSize; ++i2) {
                String parentElementName;
                String allElementName;
                Object parentElement;
                Object allElement;
                assert (allUncached.isArrayElementReadable(allMembers2, i2 + currentSize)) : AssertUtils.violationPost(receiver, allMembers2);
                assert (parentUncached.isArrayElementReadable(parentMembers, i2)) : AssertUtils.violationPost(receiver, parentMembers);
                try {
                    allElement = allUncached.readArrayElement(allMembers2, i2 + currentSize);
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e3) {
                    assert (false) : AssertUtils.violationPost(receiver, allMembers2);
                    return true;
                }
                try {
                    parentElement = parentUncached.readArrayElement(parentMembers, i2);
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e4) {
                    assert (false) : AssertUtils.violationPost(receiver, parentMembers);
                    return true;
                }
                assert (InteropLibrary.getUncached().isString(allElement)) : AssertUtils.violationPost(receiver, allElement);
                assert (InteropLibrary.getUncached().isString(parentElement)) : AssertUtils.violationPost(receiver, parentElement);
                try {
                    allElementName = InteropLibrary.getUncached().asString(allElement);
                }
                catch (UnsupportedMessageException e5) {
                    assert (false) : AssertUtils.violationInvariant(allElement);
                    return true;
                }
                try {
                    parentElementName = InteropLibrary.getUncached().asString(parentElement);
                }
                catch (UnsupportedMessageException e6) {
                    assert (false) : AssertUtils.violationInvariant(parentElement);
                    return true;
                }
                assert (AssertUtils.validScopeMemberNames(allElementName, parentElementName, allMembers2, parentMembers, i2 + currentSize, i2));
            }
            return true;
        }

        @Override
        public boolean hasMemberReadSideEffects(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.hasMemberReadSideEffects(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (!result2 || this.delegate.isMemberReadable(receiver, identifier) || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasMemberWriteSideEffects(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.hasMemberWriteSideEffects(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (!result2 || this.delegate.isMemberWritable(receiver, identifier) || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberReadable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberReadable(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberModifiable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberModifiable(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberInsertable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberInsertable(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver) && !this.delegate.isMemberExisting(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberRemovable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberRemovable(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberInvocable(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberInvocable(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver) && !this.delegate.isMemberInsertable(receiver, identifier)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isMemberInternal(Object receiver, String identifier) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, identifier));
            boolean result2 = this.delegate.isMemberInternal(receiver, identifier);
            assert (!result2 || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver, identifier);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasHashEntries(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasHashEntries(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public long getHashSize(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result2 = this.delegate.getHashSize(receiver);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                assert (!this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isHashEntryReadable(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryReadable(receiver, key2);
            assert (!result2 || this.delegate.hasHashEntries(receiver) && !this.delegate.isHashEntryInsertable(receiver, key2)) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object readHashValue(Object receiver, Object key2) throws UnsupportedMessageException, UnknownKeyException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readHashValue(receiver, key2);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean wasReadable = this.delegate.isHashEntryReadable(receiver, key2);
            try {
                Object result2 = this.delegate.readHashValue(receiver, key2);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver, key2);
                assert (wasReadable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, key2);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownKeyException) : AssertUtils.violationPost(receiver, e2);
                assert (!(e2 instanceof UnsupportedMessageException) || !wasReadable) : AssertUtils.violationInvariant(receiver, key2);
                throw e2;
            }
        }

        @Override
        public Object readHashValueOrDefault(Object receiver, Object key2, Object defaultValue) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readHashValueOrDefault(receiver, key2, defaultValue);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            assert (AssertUtils.validInteropArgument(receiver, defaultValue));
            try {
                Object result2 = this.delegate.readHashValueOrDefault(receiver, key2, defaultValue);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver, key2);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public boolean isHashEntryModifiable(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryModifiable(receiver, key2);
            assert (!result2 || this.delegate.hasHashEntries(receiver) && !this.delegate.isHashEntryInsertable(receiver, key2)) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isHashEntryInsertable(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryInsertable(receiver, key2);
            assert (!result2 || this.delegate.hasHashEntries(receiver) && !this.delegate.isHashEntryExisting(receiver, key2)) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isHashEntryWritable(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryWritable(receiver, key2);
            assert (result2 == (this.delegate.isHashEntryModifiable(receiver, key2) || this.delegate.isHashEntryInsertable(receiver, key2))) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public void writeHashEntry(Object receiver, Object key2, Object value2) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.writeHashEntry(receiver, key2, value2);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            assert (AssertUtils.validInteropArgument(receiver, value2));
            boolean wasWritable = this.delegate.isHashEntryModifiable(receiver, key2) || this.delegate.isHashEntryInsertable(receiver, key2);
            try {
                this.delegate.writeHashEntry(receiver, key2, value2);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver, key2);
                assert (wasWritable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, key2);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownKeyException || e2 instanceof UnsupportedTypeException) : AssertUtils.violationPost(receiver, e2);
                assert (!(e2 instanceof UnsupportedMessageException) || !wasWritable) : AssertUtils.violationInvariant(receiver, key2);
                throw e2;
            }
        }

        @Override
        public boolean isHashEntryRemovable(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryRemovable(receiver, key2);
            assert (!result2 || this.delegate.hasHashEntries(receiver) && !this.delegate.isHashEntryInsertable(receiver, key2)) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public void removeHashEntry(Object receiver, Object key2) throws UnsupportedMessageException, UnknownKeyException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.removeHashEntry(receiver, key2);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean wasRemovable = this.delegate.isHashEntryRemovable(receiver, key2);
            try {
                this.delegate.removeHashEntry(receiver, key2);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver, key2);
                assert (wasRemovable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, key2);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnknownKeyException) : AssertUtils.violationPost(receiver, e2);
                assert (!(e2 instanceof UnsupportedMessageException) || !wasRemovable) : AssertUtils.violationInvariant(receiver, key2);
                throw e2;
            }
        }

        @Override
        public boolean isHashEntryExisting(Object receiver, Object key2) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, key2));
            boolean result2 = this.delegate.isHashEntryExisting(receiver, key2);
            assert (result2 == (this.delegate.isHashEntryReadable(receiver, key2) || this.delegate.isHashEntryModifiable(receiver, key2) || this.delegate.isHashEntryRemovable(receiver, key2))) : AssertUtils.violationInvariant(receiver, key2);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getHashEntriesIterator(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getHashEntriesIterator(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            try {
                Object result2 = this.delegate.getHashEntriesIterator(receiver);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertIterator(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                assert (!this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public Object getHashKeysIterator(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getHashKeysIterator(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            try {
                Object result2 = this.delegate.getHashKeysIterator(receiver);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertIterator(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                assert (!this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public Object getHashValuesIterator(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getHashValuesIterator(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            try {
                Object result2 = this.delegate.getHashValuesIterator(receiver);
                assert (this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertIterator(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                assert (!this.delegate.hasHashEntries(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasArrayElements(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            return this.delegate.hasArrayElements(receiver);
        }

        @Override
        public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.readArrayElement(receiver, index);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean wasReadable = this.delegate.isArrayElementReadable(receiver, index);
            try {
                Object result2 = this.delegate.readArrayElement(receiver, index);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasReadable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public void writeArrayElement(Object receiver, long index, Object value2) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.writeArrayElement(receiver, index, value2);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            assert (AssertUtils.validInteropArgument(receiver, value2));
            boolean wasWritable = this.delegate.isArrayElementModifiable(receiver, index) || this.delegate.isArrayElementInsertable(receiver, index);
            try {
                this.delegate.writeArrayElement(receiver, index, value2);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasWritable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof UnsupportedTypeException || e2 instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
            if (CompilerDirectives.inCompiledCode()) {
                this.delegate.removeArrayElement(receiver, index);
                return;
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean wasRemovable = this.delegate.isArrayElementRemovable(receiver, index);
            try {
                this.delegate.removeArrayElement(receiver, index);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver, index);
                assert (wasRemovable || Asserts.isMultiThreaded(receiver)) : AssertUtils.violationInvariant(receiver, index);
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof InvalidArrayIndexException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public long getArraySize(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result2 = this.delegate.getArraySize(receiver);
                assert (this.delegate.hasArrayElements(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public boolean isArrayElementReadable(Object receiver, long index) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean result2 = this.delegate.isArrayElementReadable(receiver, index);
            assert (!result2 || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, index)) : AssertUtils.violationInvariant(receiver, index);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isArrayElementModifiable(Object receiver, long index) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean result2 = this.delegate.isArrayElementModifiable(receiver, index);
            assert (!result2 || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, index)) : AssertUtils.violationInvariant(receiver, index);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isArrayElementInsertable(Object receiver, long index) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean result2 = this.delegate.isArrayElementInsertable(receiver, index);
            assert (!result2 || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementExisting(receiver, index)) : AssertUtils.violationInvariant(receiver, index);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isArrayElementRemovable(Object receiver, long index) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, index));
            boolean result2 = this.delegate.isArrayElementRemovable(receiver, index);
            assert (!result2 || this.delegate.hasArrayElements(receiver) && !this.delegate.isArrayElementInsertable(receiver, index)) : AssertUtils.violationInvariant(receiver, index);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasBufferElements(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasBufferElements(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                boolean result2 = this.delegate.isBufferWritable(receiver);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public long getBufferSize(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            try {
                long result2 = this.delegate.getBufferSize(receiver);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                byte result2 = this.delegate.readBufferByte(receiver, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferByte(Object receiver, long byteOffset, byte value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, value2));
            try {
                this.delegate.writeBufferByte(receiver, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                short result2 = this.delegate.readBufferShort(receiver, order, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, value2));
            try {
                this.delegate.writeBufferShort(receiver, order, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                int result2 = this.delegate.readBufferInt(receiver, order, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, value2));
            try {
                this.delegate.writeBufferInt(receiver, order, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                long result2 = this.delegate.readBufferLong(receiver, order, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, value2));
            try {
                this.delegate.writeBufferLong(receiver, order, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                float result2 = this.delegate.readBufferFloat(receiver, order, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, Float.valueOf(result2)));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, Float.valueOf(value2)));
            try {
                this.delegate.writeBufferFloat(receiver, order, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            try {
                double result2 = this.delegate.readBufferDouble(receiver, order, byteOffset);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasBufferElements(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value2) throws UnsupportedMessageException, InvalidBufferOffsetException {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validProtocolArgument(receiver, order));
            assert (AssertUtils.validProtocolArgument(receiver, byteOffset));
            assert (AssertUtils.validProtocolArgument(receiver, value2));
            try {
                this.delegate.writeBufferDouble(receiver, order, byteOffset, value2);
                assert (this.delegate.hasBufferElements(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
                assert (this.delegate.isBufferWritable(receiver)) : AssertUtils.violationInvariant(receiver, byteOffset);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.isBufferWritable(receiver)) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof InvalidBufferOffsetException) : AssertUtils.violationPost(receiver, e3);
                throw e3;
            }
        }

        @Override
        public boolean isPointer(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isPointer(receiver);
            return result2;
        }

        @Override
        public void toNative(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean wasPointer = this.delegate.isPointer(receiver);
            this.delegate.toNative(receiver);
            assert (!wasPointer || this.delegate.isPointer(receiver)) : AssertUtils.violationInvariant(receiver);
        }

        @Override
        public long asPointer(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asPointer(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasPointer = this.delegate.isPointer(receiver);
            try {
                long result2 = this.delegate.asPointer(receiver);
                assert (wasPointer) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasPointer) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asDate(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasDate = this.delegate.isDate(receiver);
            try {
                LocalDate result2 = this.delegate.asDate(receiver);
                assert (hasDate) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasDate) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || !this.delegate.isTime(receiver) || this.hasFixedTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asTime(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasTime = this.delegate.isTime(receiver);
            try {
                LocalTime result2 = this.delegate.asTime(receiver);
                assert (hasTime) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasTime) : AssertUtils.violationInvariant(receiver);
                assert (!this.delegate.isTimeZone(receiver) || !this.delegate.isDate(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asTimeZone(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasTimeZone = this.delegate.isTimeZone(receiver);
            try {
                ZoneId result2 = this.delegate.asTimeZone(receiver);
                assert (hasTimeZone) : AssertUtils.violationInvariant(receiver);
                assert ((this.delegate.isDate(receiver) || result2.getRules().isFixedOffset()) && this.delegate.isTime(receiver) || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasTimeZone) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        private boolean hasFixedTimeZone(Object receiver) {
            try {
                return this.delegate.asTimeZone(receiver).getRules().isFixedOffset();
            }
            catch (InteropException e2) {
                throw CompilerDirectives.shouldNotReachHere(AssertUtils.violationInvariant(receiver));
            }
        }

        @Override
        public Duration asDuration(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asDuration(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasDuration = this.delegate.isDuration(receiver);
            try {
                Duration result2 = this.delegate.asDuration(receiver);
                assert (wasDuration) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DURATION));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasDuration) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public Instant asInstant(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.asInstant(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hasDateAndTime = this.delegate.isDate(receiver) && this.delegate.isTime(receiver) && this.delegate.isTimeZone(receiver);
            try {
                Instant result2 = this.delegate.asInstant(receiver);
                assert (hasDateAndTime) : AssertUtils.violationInvariant(receiver);
                assert (ZonedDateTime.of(this.delegate.asDate(receiver), this.delegate.asTime(receiver), this.delegate.asTimeZone(receiver)).toInstant().equals(result2)) : AssertUtils.violationInvariant(receiver);
                assert (this.notOtherType(receiver, Type.DATE_TIME_ZONE));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hasDateAndTime) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isDate(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isDate(receiver);
            assert (!this.delegate.isTimeZone(receiver) || this.delegate.isTime(receiver) && result2 || (!this.delegate.isTime(receiver) || this.hasFixedTimeZone(receiver)) && !result2) : AssertUtils.violationInvariant(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isTime(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isTime(receiver);
            assert (!this.delegate.isTimeZone(receiver) || (this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) && result2 || !this.delegate.isDate(receiver) && !result2) : AssertUtils.violationInvariant(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isTimeZone(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isTimeZone(receiver);
            assert (!result2 || (this.delegate.isDate(receiver) || this.hasFixedTimeZone(receiver)) && this.delegate.isTime(receiver) || !this.delegate.isDate(receiver) && !this.delegate.isTime(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.DATE_TIME_ZONE));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isDuration(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isDuration(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.DURATION));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isException(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isException(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public ExceptionType getExceptionType(Object receiver) throws UnsupportedMessageException {
            assert (AssertUtils.preCondition(receiver));
            ExceptionType result2 = this.delegate.getExceptionType(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, (Object)result2));
            return result2;
        }

        @Override
        public boolean isExceptionIncompleteSource(Object receiver) throws UnsupportedMessageException {
            boolean wasParseError;
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isExceptionIncompleteSource(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            try {
                wasParseError = this.delegate.getExceptionType(receiver) == ExceptionType.PARSE_ERROR;
            }
            catch (UnsupportedMessageException e2) {
                wasParseError = false;
            }
            try {
                boolean result2 = this.delegate.isExceptionIncompleteSource(receiver);
                assert (!result2 || wasParseError) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasParseError) : AssertUtils.violationInvariant(receiver);
                throw e3;
            }
        }

        @Override
        public int getExceptionExitStatus(Object receiver) throws UnsupportedMessageException {
            boolean wasExit;
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getExceptionExitStatus(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            try {
                wasExit = this.delegate.getExceptionType(receiver) == ExceptionType.EXIT;
            }
            catch (UnsupportedMessageException e2) {
                wasExit = false;
            }
            try {
                int result2 = this.delegate.getExceptionExitStatus(receiver);
                assert (wasExit) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e3) {
                assert (e3 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasExit) : AssertUtils.violationInvariant(receiver);
                throw e3;
            }
        }

        @Override
        public RuntimeException throwException(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.throwException(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasException = this.delegate.isException(receiver);
            boolean wasAbstractTruffleException = false;
            boolean unsupported = false;
            try {
                try {
                    throw this.delegate.throwException(receiver);
                }
                catch (InteropException e2) {
                    assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                    assert (!wasException) : AssertUtils.violationInvariant(receiver);
                    unsupported = true;
                    throw e2;
                }
                catch (Throwable e3) {
                    wasAbstractTruffleException = InteropAccessor.EXCEPTION.isException(e3);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (!unsupported) {
                    assert (wasException) : AssertUtils.violationInvariant(receiver);
                    assert (wasAbstractTruffleException) : AssertUtils.violationInvariant(receiver);
                }
                throw throwable;
            }
        }

        @Override
        public boolean hasExceptionCause(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasExceptionCause(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getExceptionCause(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasExceptionCause = this.delegate.hasExceptionCause(receiver);
            try {
                Object result2 = this.delegate.getExceptionCause(receiver);
                assert (wasHasExceptionCause) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertException(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasExceptionCause) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        private static boolean assertException(Object receiver, Object exception) {
            InteropLibrary uncached = InteropLibrary.getUncached(exception);
            assert (uncached.isException(exception)) : AssertUtils.violationPost(receiver, exception);
            return true;
        }

        @Override
        public boolean hasExceptionMessage(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasExceptionMessage(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getExceptionMessage(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getExceptionMessage(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasExceptionMessage = this.delegate.hasExceptionMessage(receiver);
            try {
                Object result2 = this.delegate.getExceptionMessage(receiver);
                assert (wasHasExceptionMessage) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.assertString(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasExceptionMessage) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasExceptionStackTrace(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasExceptionStackTrace(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getExceptionStackTrace(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasExceptionStackTrace = this.delegate.hasExceptionStackTrace(receiver);
            try {
                Object result2 = this.delegate.getExceptionStackTrace(receiver);
                assert (wasHasExceptionStackTrace) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.verifyStackTrace(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasExceptionStackTrace) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        private static boolean verifyStackTrace(Object receiver, Object stackTrace) {
            assert (stackTrace != null) : AssertUtils.violationPost(receiver, stackTrace);
            InteropLibrary stackTraceLib = InteropLibrary.getFactory().getUncached(stackTrace);
            assert (stackTraceLib.hasArrayElements(stackTrace)) : AssertUtils.violationPost(receiver, stackTrace);
            return true;
        }

        @Override
        public boolean hasExecutableName(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasExecutableName(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getExecutableName(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasExecutableName = this.delegate.hasExecutableName(receiver);
            try {
                Object result2 = this.delegate.getExecutableName(receiver);
                assert (wasHasExecutableName) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.assertString(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasExecutableName) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasDeclaringMetaObject(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasDeclaringMetaObject(receiver);
            return result2;
        }

        @Override
        public Object getDeclaringMetaObject(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getDeclaringMetaObject(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasDeclaringMetaObject = this.delegate.hasDeclaringMetaObject(receiver);
            try {
                Object result2 = this.delegate.getDeclaringMetaObject(receiver);
                assert (wasHasDeclaringMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.verifyDeclaringMetaObject(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasDeclaringMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        private static boolean verifyDeclaringMetaObject(Object receiver, Object meta2) {
            block6: {
                assert (meta2 != null) : AssertUtils.violationPost(receiver, meta2);
                InteropLibrary metaLib = InteropLibrary.getFactory().getUncached(meta2);
                assert (metaLib.isMetaObject(meta2)) : AssertUtils.violationPost(receiver, meta2);
                try {
                    assert (metaLib.getMetaSimpleName(meta2) != null) : AssertUtils.violationPost(receiver, meta2);
                    assert (metaLib.getMetaQualifiedName(meta2) != null) : AssertUtils.violationPost(receiver, meta2);
                }
                catch (UnsupportedMessageException e2) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)AssertUtils.violationPost(receiver, meta2));
                }
            }
            return true;
        }

        @Override
        public Object toDisplayString(Object receiver, boolean allowSideEffects) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validNonInteropArgument(receiver, allowSideEffects));
            Object result2 = this.delegate.toDisplayString(receiver, allowSideEffects);
            assert (AssertUtils.assertString(receiver, result2));
            assert (AssertUtils.validInteropReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasIterator(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasIterator(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getIterator(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getIterator(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasIterator = this.delegate.hasIterator(receiver);
            try {
                Object result2 = this.delegate.getIterator(receiver);
                assert (wasHasIterator) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.assertIterator(receiver, result2));
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasIterator) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        private static boolean assertIterator(Object receiver, Object iterator2) {
            assert (iterator2 != null) : AssertUtils.violationPost(receiver, iterator2);
            InteropLibrary uncached = InteropLibrary.getUncached(iterator2);
            assert (uncached.isIterator(iterator2)) : AssertUtils.violationPost(receiver, iterator2);
            return true;
        }

        @Override
        public boolean isIterator(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isIterator(receiver);
            assert (!result2 || this.notOtherType(receiver, Type.ITERATOR));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasIteratorNextElement(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.hasIteratorNextElement(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasIterator = this.delegate.isIterator(receiver);
            try {
                boolean result2 = this.delegate.hasIteratorNextElement(receiver);
                assert (wasIterator) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasIterator) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public Object getIteratorNextElement(Object receiver) throws UnsupportedMessageException, StopIterationException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getIteratorNextElement(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasIterator = this.delegate.isIterator(receiver);
            try {
                Object result2 = this.delegate.getIteratorNextElement(receiver);
                assert (wasIterator) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException || e2 instanceof StopIterationException) : AssertUtils.violationPost(receiver, e2);
                throw e2;
            }
        }

        @Override
        public boolean hasSourceLocation(Object receiver) {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.hasSourceLocation(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasSourceLocation(receiver);
            if (result2) {
                try {
                    assert (this.delegate.getSourceLocation(receiver) != null) : AssertUtils.violationPost(receiver, result2);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {}
            } else assert (this.assertHasNoSourceSection(receiver));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        private boolean assertHasNoSourceSection(Object receiver) {
            try {
                this.delegate.getSourceLocation(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getSourceLocation(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasSourceLocation = this.delegate.hasSourceLocation(receiver);
            try {
                SourceSection result2 = this.delegate.getSourceLocation(receiver);
                assert (wasHasSourceLocation) : AssertUtils.violationInvariant(receiver);
                assert (result2 != null) : AssertUtils.violationPost(receiver, result2);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasSourceLocation) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasLanguage(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasLanguage(receiver);
            if (result2) {
                try {
                    assert (this.delegate.getLanguage(receiver) != null) : AssertUtils.violationPost(receiver, result2);
                }
                catch (InteropException e2) {
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (Exception exception) {}
            } else assert (this.assertHasNoLanguage(receiver));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        private boolean assertHasNoLanguage(Object receiver) {
            try {
                this.delegate.getLanguage(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getLanguage(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasLanguage = this.delegate.hasLanguage(receiver);
            try {
                Class<? extends TruffleLanguage<?>> result2 = this.delegate.getLanguage(receiver);
                assert (wasHasLanguage) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasLanguage) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasMetaObject(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.hasMetaObject(receiver);
            if (result2 ? !$assertionsDisabled && !this.assertHasMetaObject(receiver, result2) : !$assertionsDisabled && !this.assertHasNoMetaObject(receiver)) {
                throw new AssertionError();
            }
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        private boolean assertHasMetaObject(Object receiver, boolean result2) {
            try {
                Object meta2 = this.delegate.getMetaObject(receiver);
                assert (Asserts.verifyMetaObject(receiver, meta2));
            }
            catch (InteropException e2) {
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private static boolean verifyMetaObject(Object receiver, Object meta2) throws UnsupportedMessageException {
            assert (meta2 != null) : AssertUtils.violationPost(receiver, meta2);
            InteropLibrary metaLib = InteropLibrary.getFactory().getUncached(meta2);
            assert (metaLib.isMetaObject(meta2)) : AssertUtils.violationPost(receiver, meta2);
            assert (metaLib.getMetaSimpleName(meta2) != null) : AssertUtils.violationPost(receiver, meta2);
            assert (metaLib.getMetaQualifiedName(meta2) != null) : AssertUtils.violationPost(receiver, meta2);
            return true;
        }

        private boolean assertHasNoMetaObject(Object receiver) {
            try {
                this.delegate.getMetaObject(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaObject(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasHasMetaObject = this.delegate.hasMetaObject(receiver);
            try {
                Object result2 = this.delegate.getMetaObject(receiver);
                assert (wasHasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (Asserts.verifyMetaObject(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasHasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isMetaObject(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isMetaObject(receiver);
            if (result2) {
                assert (this.assertMetaObject(receiver));
            } else {
                assert (this.assertNoMetaObject(receiver));
                assert (!result2 || this.notOtherType(receiver, Type.META_OBJECT));
            }
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        private boolean assertNoMetaObject(Object receiver) {
            try {
                this.delegate.isMetaInstance(receiver, receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                this.delegate.getMetaSimpleName(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                this.delegate.getMetaQualifiedName(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                this.delegate.getMetaParents(receiver);
                assert (false) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return true;
        }

        private boolean assertMetaObject(Object receiver) {
            block10: {
                block9: {
                    block8: {
                        try {
                            this.delegate.isMetaInstance(receiver, receiver);
                        }
                        catch (UnsupportedMessageException e2) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                        }
                    }
                    try {
                        assert (AssertUtils.assertString(receiver, this.delegate.getMetaSimpleName(receiver))) : AssertUtils.violationInvariant(receiver);
                    }
                    catch (UnsupportedMessageException e3) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                    }
                }
                try {
                    assert (AssertUtils.assertString(receiver, this.delegate.getMetaQualifiedName(receiver))) : AssertUtils.violationInvariant(receiver);
                }
                catch (UnsupportedMessageException e4) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)AssertUtils.violationInvariant(receiver));
                }
            }
            return true;
        }

        @Override
        public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaQualifiedName(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                Object result2 = this.delegate.getMetaQualifiedName(receiver);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.assertString(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaSimpleName(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                Object result2 = this.delegate.getMetaSimpleName(receiver);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.assertString(receiver, result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.isMetaInstance(receiver, instance);
            }
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, instance));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            try {
                boolean result2 = this.delegate.isMetaInstance(receiver, instance);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validProtocolReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!wasMetaObject) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        public boolean hasMetaParents(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            boolean result2 = this.delegate.hasMetaParents(receiver);
            if (result2) {
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
            } else if (!wasMetaObject) assert (this.assertNoMetaObject(receiver));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getMetaParents(receiver);
            }
            boolean wasMetaObject = this.delegate.isMetaObject(receiver);
            boolean hadMetaParents = this.delegate.hasMetaParents(receiver);
            try {
                Object result2 = this.delegate.getMetaParents(receiver);
                assert (wasMetaObject) : AssertUtils.violationInvariant(receiver);
                assert (hadMetaParents) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hadMetaParents) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        @Override
        protected TriState isIdenticalOrUndefined(Object receiver, Object other) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, other));
            TriState result2 = this.delegate.isIdenticalOrUndefined(receiver, other);
            assert (Asserts.verifyIsSameOrUndefined(this.delegate, result2, receiver, other));
            assert (AssertUtils.validProtocolReturn(receiver, (Object)result2));
            return result2;
        }

        static boolean verifyIsSameOrUndefined(InteropLibrary library, TriState result2, Object receiver, Object other) {
            if (result2 != TriState.UNDEFINED) {
                int hashCode2 = 0;
                try {
                    hashCode2 = library.identityHashCode(receiver);
                }
                catch (Exception t) {
                    throw CompilerDirectives.shouldNotReachHere(t);
                }
            }
            return true;
        }

        @Override
        public int identityHashCode(Object receiver) throws UnsupportedMessageException {
            int result2;
            assert (AssertUtils.preCondition(receiver));
            try {
                result2 = this.delegate.identityHashCode(receiver);
                assert (this.delegate.hasIdentity(receiver)) : AssertUtils.violationInvariant(receiver);
            }
            catch (UnsupportedMessageException e2) {
                assert (!this.delegate.hasIdentity(receiver)) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean isIdentical(Object receiver, Object other, InteropLibrary otherInterop) {
            assert (AssertUtils.preCondition(receiver));
            assert (AssertUtils.validInteropArgument(receiver, other));
            assert (AssertUtils.validProtocolArgument(receiver, otherInterop));
            boolean result2 = this.delegate.isIdentical(receiver, other, otherInterop);
            assert (this.verifyIsSame(result2, receiver, other, otherInterop));
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        boolean verifyIsSame(boolean result2, Object receiver, Object other, InteropLibrary otherInterop) {
            try {
                InteropLibrary otherDelegate = otherInterop;
                if (otherInterop instanceof Asserts) {
                    otherDelegate = ((Asserts)otherInterop).delegate;
                }
                assert (result2 == otherDelegate.isIdentical(other, receiver, this.delegate)) : AssertUtils.violationInvariant(receiver);
                if (result2) assert (this.delegate.identityHashCode(receiver) == otherDelegate.identityHashCode(other)) : AssertUtils.violationInvariant(receiver);
                TriState state = this.delegate.isIdenticalOrUndefined(receiver, other);
                if (state != TriState.UNDEFINED) assert (this.delegate.isIdentical(receiver, receiver, this.delegate)) : AssertUtils.violationInvariant(receiver);
                Asserts.verifyIsSameOrUndefined(this.delegate, state, receiver, other);
                Asserts.verifyIsSameOrUndefined(otherDelegate, otherDelegate.isIdenticalOrUndefined(other, receiver), other, receiver);
            }
            catch (UnsupportedMessageException e2) {
                throw CompilerDirectives.shouldNotReachHere(e2);
            }
            return true;
        }

        @Override
        public boolean isScope(Object receiver) {
            assert (AssertUtils.preCondition(receiver));
            boolean result2 = this.delegate.isScope(receiver);
            assert (!result2 || this.delegate.hasMembers(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (!result2 || this.delegate.hasLanguage(receiver)) : AssertUtils.violationInvariant(receiver);
            assert (AssertUtils.validProtocolReturn(receiver, result2));
            return result2;
        }

        @Override
        public boolean hasScopeParent(Object receiver) {
            boolean result2;
            block11: {
                if (CompilerDirectives.inCompiledCode()) {
                    return this.delegate.hasScopeParent(receiver);
                }
                assert (AssertUtils.preCondition(receiver));
                result2 = this.delegate.hasScopeParent(receiver);
                if (result2) {
                    assert (this.delegate.isScope(receiver)) : AssertUtils.violationInvariant(receiver);
                    try {
                        assert (AssertUtils.validScope(this.delegate.getScopeParent(receiver)));
                        break block11;
                    }
                    catch (UnsupportedMessageException e2) {
                        assert (false) : AssertUtils.violationInvariant(receiver);
                        break block11;
                    }
                }
                try {
                    this.delegate.getScopeParent(receiver);
                    assert (false) : AssertUtils.violationInvariant(receiver);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return result2;
        }

        @Override
        public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
            if (CompilerDirectives.inCompiledCode()) {
                return this.delegate.getScopeParent(receiver);
            }
            assert (AssertUtils.preCondition(receiver));
            boolean hadScopeParent = this.delegate.hasScopeParent(receiver);
            try {
                Object result2 = this.delegate.getScopeParent(receiver);
                assert (hadScopeParent) : AssertUtils.violationInvariant(receiver);
                assert (this.delegate.isScope(receiver)) : AssertUtils.violationInvariant(receiver);
                assert (AssertUtils.validScope(result2));
                assert (AssertUtils.validInteropReturn(receiver, result2));
                return result2;
            }
            catch (InteropException e2) {
                assert (e2 instanceof UnsupportedMessageException) : AssertUtils.violationInvariant(receiver);
                assert (!hadScopeParent) : AssertUtils.violationInvariant(receiver);
                throw e2;
            }
        }

        public static enum Type {
            NULL,
            BOOLEAN,
            DATE_TIME_ZONE,
            DURATION,
            STRING,
            NUMBER,
            POINTER,
            META_OBJECT,
            ITERATOR;

        }
    }
}

