/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.library;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.api.library.Library;
import org.pkl.thirdparty.truffle.api.library.LibraryFactory;
import org.pkl.thirdparty.truffle.api.library.Message;
import org.pkl.thirdparty.truffle.api.library.ReflectionLibrary;

@ExportLibrary(value=ReflectionLibrary.class, receiverType=Object.class)
final class ReflectionLibraryDefault {
    static final int LIMIT = 8;

    ReflectionLibraryDefault() {
    }

    @ExportMessage
    static class Send {
        Send() {
        }

        @Specialization(guards={"message == cachedMessage", "cachedLibrary.accepts(receiver)"}, limit="LIMIT")
        static Object doSendCached(Object receiver, Message message, Object[] args2, @Cached(value="message") Message cachedMessage, @Cached(value="createLibrary(message, receiver)") Library cachedLibrary) throws Exception {
            return cachedMessage.getFactory().genericDispatch(cachedLibrary, receiver, cachedMessage, args2, 0);
        }

        static Library createLibrary(Message message, Object receiver) {
            return message.getFactory().create(receiver);
        }

        @Specialization(replaces={"doSendCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doSendGeneric(Object receiver, Message message, Object[] args2) throws Exception {
            LibraryFactory<?> lib = message.getFactory();
            return lib.genericDispatch((Library)lib.getUncached(receiver), receiver, message, args2, 0);
        }
    }
}

