/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.NeverDefault;
import org.pkl.thirdparty.truffle.api.profiles.ConditionProfile;

public final class LoopConditionProfile
extends ConditionProfile {
    private static final LoopConditionProfile DISABLED;
    @CompilerDirectives.CompilationFinal
    private long trueCount;
    @CompilerDirectives.CompilationFinal
    private int falseCount;

    LoopConditionProfile() {
    }

    @Override
    public boolean profile(boolean condition) {
        long trueCountLocal = this.trueCount;
        int falseCountLocal = this.falseCount;
        if (trueCountLocal == 0L && condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        if (CompilerDirectives.inInterpreter()) {
            if (condition) {
                if (trueCountLocal < Long.MAX_VALUE) {
                    this.trueCount = trueCountLocal + 1L;
                }
            } else if (falseCountLocal < Integer.MAX_VALUE) {
                this.falseCount = falseCountLocal + 1;
            }
            return condition;
        }
        if (this != DISABLED) {
            return CompilerDirectives.injectBranchProbability(LoopConditionProfile.calculateProbability(trueCountLocal, falseCountLocal), condition);
        }
        return condition;
    }

    public void profileCounted(long length2) {
        long trueCountLocal;
        if (CompilerDirectives.inInterpreter() && (trueCountLocal = this.trueCount + length2) >= 0L) {
            this.trueCount = trueCountLocal;
            int falseCountLocal = this.falseCount;
            if (falseCountLocal < Integer.MAX_VALUE) {
                this.falseCount = falseCountLocal + 1;
            }
        }
    }

    public boolean inject(boolean condition) {
        if (CompilerDirectives.inCompiledCode() && this != DISABLED) {
            return CompilerDirectives.injectBranchProbability(LoopConditionProfile.calculateProbability(this.trueCount, this.falseCount), condition);
        }
        return condition;
    }

    private static double calculateProbability(long trueCountLocal, int falseCountLocal) {
        if (falseCountLocal == 0 && trueCountLocal == 0L) {
            return 0.0;
        }
        return (double)trueCountLocal / (double)(trueCountLocal + (long)falseCountLocal);
    }

    @Override
    public void disable() {
        if (this.trueCount == 0L) {
            this.trueCount = 1L;
        }
        if (this.falseCount == 0) {
            this.falseCount = 1;
        }
    }

    @Override
    public void reset() {
        if (this != DISABLED) {
            this.trueCount = 0L;
            this.falseCount = 0;
        }
    }

    long getTrueCount() {
        return this.trueCount;
    }

    int getFalseCount() {
        return this.falseCount;
    }

    @Override
    public String toString() {
        if (this == DISABLED) {
            return this.toStringDisabled();
        }
        return this.toString(LoopConditionProfile.class, this.falseCount == 0, false, String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", LoopConditionProfile.calculateProbability(this.trueCount, this.falseCount), this.trueCount, this.falseCount));
    }

    @Deprecated
    @NeverDefault
    public static LoopConditionProfile createCountingProfile() {
        if (LoopConditionProfile.isProfilingEnabled()) {
            return new LoopConditionProfile();
        }
        return DISABLED;
    }

    @NeverDefault
    public static LoopConditionProfile create() {
        return LoopConditionProfile.createCountingProfile();
    }

    public static LoopConditionProfile getUncached() {
        return DISABLED;
    }

    static {
        LoopConditionProfile profile = new LoopConditionProfile();
        profile.trueCount = Long.MAX_VALUE;
        profile.falseCount = Integer.MAX_VALUE;
        DISABLED = profile;
    }
}

