/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.source;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceImpl;

final class InternedSources {
    private final ConcurrentHashMap<SourceImpl.Key, WeakSourceRef> table = new ConcurrentHashMap();
    private final ReferenceQueue<SourceImpl> deadReferences = new ReferenceQueue();

    InternedSources() {
    }

    void add(SourceImpl source2) {
        if (!source2.isCached()) {
            return;
        }
        this.table.put(source2.key, new WeakSourceRef(source2, this.deadReferences));
    }

    Source intern(SourceImpl.Key key2) {
        SourceImpl source2;
        this.cleanupStaleEntries();
        if (!key2.cached) {
            return key2.toSourceNotInterned();
        }
        WeakSourceRef sourceRef = this.table.get(key2);
        SourceImpl sourceImpl = source2 = sourceRef != null ? (SourceImpl)sourceRef.get() : null;
        if (source2 == null) {
            WeakSourceRef oldSourceRef;
            while ((oldSourceRef = this.table.putIfAbsent(key2, sourceRef = new WeakSourceRef(source2 = key2.toSourceInterned(), this.deadReferences))) != null) {
                SourceImpl otherSource = (SourceImpl)oldSourceRef.get();
                if (otherSource == null) {
                    boolean replaced = this.table.replace(key2, oldSourceRef, sourceRef);
                    if (!replaced) continue;
                    return source2;
                }
                assert (otherSource != source2);
                return otherSource;
            }
            assert (source2 != null);
        }
        return source2;
    }

    void resetNativeImageState() {
        this.table.clear();
    }

    private void cleanupStaleEntries() {
        WeakSourceRef sourceRef = null;
        while ((sourceRef = (WeakSourceRef)this.deadReferences.poll()) != null) {
            this.table.remove(sourceRef.key, sourceRef);
        }
    }

    private static class WeakSourceRef
    extends WeakReference<SourceImpl> {
        final SourceImpl.Key key;

        WeakSourceRef(SourceImpl referent, ReferenceQueue<SourceImpl> q2) {
            super(referent, q2);
            this.key = referent.toKey();
        }
    }
}

