/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.source;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.function.Function;
import org.pkl.thirdparty.truffle.api.TruffleFile;
import org.pkl.thirdparty.truffle.api.impl.Accessor;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceImpl;

final class SourceAccessor
extends Accessor {
    static final SourceAccessor ACCESSOR = new SourceAccessor();
    static final Accessor.LanguageSupport LANGUAGE = ACCESSOR.languageSupport();

    private SourceAccessor() {
    }

    public static void load() {
    }

    static String detectMimeType(TruffleFile file2, Set<String> validMimeTypes) {
        return ACCESSOR.languageSupport().detectMimeType(file2, validMimeTypes);
    }

    static Charset detectEncoding(TruffleFile file2, String mimeType) {
        return ACCESSOR.languageSupport().detectEncoding(file2, mimeType);
    }

    static TruffleFile getTruffleFile(URI uri, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(fileSystemContext, uri);
    }

    static TruffleFile getTruffleFile(String path2, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(path2, fileSystemContext);
    }

    static boolean isSocketIOAllowed(Object fileSystemContext) {
        return ACCESSOR.languageSupport().isSocketIOAllowed(fileSystemContext);
    }

    static void onSourceCreated(Source source2) {
        ACCESSOR.engineSupport().onSourceCreated(source2);
    }

    static String getReinitializedPath(TruffleFile truffleFile) {
        return ACCESSOR.engineSupport().getReinitializedPath(truffleFile);
    }

    static URI getReinitializedURI(TruffleFile truffleFile) {
        return ACCESSOR.engineSupport().getReinitializedURI(truffleFile);
    }

    static final class SourceSupportImpl
    extends Accessor.SourceSupport {
        SourceSupportImpl() {
        }

        @Override
        public Source copySource(Source source2) {
            Source copy2 = source2.copy();
            copy2.cachedPolyglotSource = source2.cachedPolyglotSource;
            return copy2;
        }

        @Override
        public Object getSourceIdentifier(Source source2) {
            return source2.getSourceId();
        }

        @Override
        public org.pkl.thirdparty.graalvm.polyglot.Source getOrCreatePolyglotSource(Source source2, Function<Source, org.pkl.thirdparty.graalvm.polyglot.Source> createSource) {
            WeakReference<org.pkl.thirdparty.graalvm.polyglot.Source> ref = source2.cachedPolyglotSource;
            org.pkl.thirdparty.graalvm.polyglot.Source polyglotSource = ref == null ? null : (org.pkl.thirdparty.graalvm.polyglot.Source)ref.get();
            if (polyglotSource == null) {
                polyglotSource = createSource.apply(source2);
                source2.cachedPolyglotSource = new WeakReference<org.pkl.thirdparty.graalvm.polyglot.Source>(polyglotSource);
            }
            assert (polyglotSource != null);
            return polyglotSource;
        }

        @Override
        public String findMimeType(URL url2, Object fileSystemContext) throws IOException {
            return Source.findMimeType(url2, url2.openConnection(), null, fileSystemContext);
        }

        @Override
        public Source.SourceBuilder newBuilder(String language, File origin2) {
            return Source.newBuilder(language, origin2);
        }

        @Override
        public void setFileSystemContext(Source.SourceBuilder builder, Object fileSystemContext) {
            builder.fileSystemContext(fileSystemContext);
        }

        @Override
        public void setEmbedderSource(Source.SourceBuilder builder, boolean enabled) {
            builder.embedderSource(enabled);
        }

        @Override
        public void setURL(Source.SourceBuilder builder, URL url2) {
            builder.url(url2);
        }

        @Override
        public void setPath(Source.SourceBuilder builder, String path2) {
            builder.path(path2);
        }

        @Override
        public void invalidateAfterPreinitialiation(Source source2) {
            ((SourceImpl)source2).key.invalidateAfterPreinitialiation();
        }

        @Override
        public void mergeLoadedSources(Source[] sources) {
            for (Source s2 : sources) {
                if (!(s2 instanceof SourceImpl)) continue;
                Source.SOURCES.add((SourceImpl)s2);
            }
        }
    }
}

