/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.strings;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleSafepoint;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.strings.AbstractTruffleString;
import org.pkl.thirdparty.truffle.api.strings.TSCodeRange;
import org.pkl.thirdparty.truffle.api.strings.TStringGuards;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;

final class TStringConstants {
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final int MAX_ARRAY_SIZE_S1 = 0x3FFFFFFB;
    static final int MAX_ARRAY_SIZE_S2 = 0x1FFFFFFD;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final byte[] EMPTY_BYTES;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private static final byte[][] SINGLE_BYTE_ARRAYS;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final byte[] INFINITY_BYTES;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final byte[] NaN_BYTES;
    private static final TruffleString INFINITY;
    private static final TruffleString NaN;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private static final TruffleString[][] SINGLE_BYTE;
    static final int LAZY_CONCAT_MIN_LENGTH = 40;

    TStringConstants() {
    }

    private static int nonAsciiCodeRange(TruffleString.Encoding encoding) {
        if (TStringGuards.isAsciiBytesOrLatin1(encoding)) {
            return TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding);
        }
        if (TStringGuards.isUTF8(encoding)) {
            return TSCodeRange.getBrokenMultiByte();
        }
        return TSCodeRange.get8Bit();
    }

    static TruffleString getInfinity(int encoding) {
        if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
            return TStringConstants.createAscii(INFINITY_BYTES, TruffleString.Encoding.get(encoding));
        }
        return INFINITY;
    }

    static TruffleString getNaN(int encoding) {
        if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
            return TStringConstants.createAscii(NaN_BYTES, TruffleString.Encoding.get(encoding));
        }
        return NaN;
    }

    static TruffleString getSingleByteAscii(TruffleString.Encoding encoding, int value2) {
        if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
            return TStringConstants.createAscii(SINGLE_BYTE_ARRAYS[value2], encoding);
        }
        if (TStringGuards.isUnsupportedEncoding(encoding)) {
            return SINGLE_BYTE[TruffleString.Encoding.US_ASCII.id][value2];
        }
        return SINGLE_BYTE[encoding.id][value2];
    }

    static TruffleString getSingleByte(TruffleString.Encoding encoding, int value2) {
        if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS && value2 <= 127) {
            return TStringConstants.createAscii(SINGLE_BYTE_ARRAYS[value2], encoding);
        }
        return SINGLE_BYTE[encoding.id][value2];
    }

    private static TruffleString createAscii(byte[] array, TruffleString.Encoding encoding) {
        return TruffleString.createFromByteArray(array, array.length, 0, encoding, array.length, TSCodeRange.getAsciiCodeRange(encoding), true);
    }

    static void truffleSafePointPoll(Node location, int loopCount) {
        if ((loopCount & 0xFFFFF) == 0) {
            TruffleSafepoint.poll(location);
            LoopNode.reportLoopCount(location, 0x100000);
        }
    }

    static {
        int j;
        int i2;
        EMPTY_BYTES = new byte[0];
        SINGLE_BYTE_ARRAYS = new byte[256][1];
        INFINITY_BYTES = new byte[]{73, 110, 102, 105, 110, 105, 116, 121};
        NaN_BYTES = new byte[]{78, 97, 78};
        INFINITY = TruffleString.createConstant(INFINITY_BYTES, INFINITY_BYTES.length, 0, TruffleString.Encoding.US_ASCII, INFINITY_BYTES.length, TSCodeRange.get7Bit());
        NaN = TruffleString.createConstant(NaN_BYTES, NaN_BYTES.length, 0, TruffleString.Encoding.US_ASCII, NaN_BYTES.length, TSCodeRange.get7Bit());
        SINGLE_BYTE = new TruffleString[6][];
        for (i2 = 0; i2 < 6; ++i2) {
            TStringConstants.SINGLE_BYTE[i2] = new TruffleString[256];
        }
        for (i2 = 0; i2 < 128; ++i2) {
            TStringConstants.SINGLE_BYTE_ARRAYS[i2][0] = (byte)i2;
            TStringConstants.SINGLE_BYTE[0][i2] = TruffleString.createConstant(SINGLE_BYTE_ARRAYS[i2], 1, 0, TruffleString.Encoding.US_ASCII, 1, TSCodeRange.get7Bit());
            for (j = 1; j < 6; ++j) {
                TStringConstants.SINGLE_BYTE[j][i2] = SINGLE_BYTE[0][i2];
            }
        }
        for (i2 = 128; i2 < 256; ++i2) {
            TStringConstants.SINGLE_BYTE_ARRAYS[i2][0] = (byte)i2;
            for (j = 0; j < 6; ++j) {
                TStringConstants.SINGLE_BYTE[j][i2] = TruffleString.createConstant(SINGLE_BYTE_ARRAYS[i2], 1, 0, TruffleString.Encoding.get(j), 1, TStringConstants.nonAsciiCodeRange(TruffleString.Encoding.get(j)));
            }
        }
    }
}

