/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.strings;

import java.util.Arrays;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.NeverDefault;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedBranchProfile;
import org.pkl.thirdparty.truffle.api.profiles.InlinedConditionProfile;
import org.pkl.thirdparty.truffle.api.strings.AbstractInternalNode;
import org.pkl.thirdparty.truffle.api.strings.AbstractPublicNode;
import org.pkl.thirdparty.truffle.api.strings.AbstractTruffleString;
import org.pkl.thirdparty.truffle.api.strings.Encodings;
import org.pkl.thirdparty.truffle.api.strings.InternalErrors;
import org.pkl.thirdparty.truffle.api.strings.JCodings;
import org.pkl.thirdparty.truffle.api.strings.NumberConversion;
import org.pkl.thirdparty.truffle.api.strings.Stride;
import org.pkl.thirdparty.truffle.api.strings.StringAttributes;
import org.pkl.thirdparty.truffle.api.strings.TSCodeRange;
import org.pkl.thirdparty.truffle.api.strings.TStringGuards;
import org.pkl.thirdparty.truffle.api.strings.TStringInternalNodes;
import org.pkl.thirdparty.truffle.api.strings.TStringOps;
import org.pkl.thirdparty.truffle.api.strings.TStringUnsafe;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;
import org.pkl.thirdparty.truffle.api.strings.TruffleStringBuilderFactory;

public final class TruffleStringBuilder {
    private final TruffleString.Encoding encoding;
    private byte[] buf;
    int stride;
    private int length;
    private int codePointLength;
    private int codeRange;

    private TruffleStringBuilder(TruffleString.Encoding encoding) {
        this(encoding, 16);
    }

    private TruffleStringBuilder(TruffleString.Encoding encoding, int initialSize) {
        this.encoding = encoding;
        this.buf = new byte[initialSize];
        this.codeRange = TStringGuards.is7BitCompatible(encoding) ? TSCodeRange.get7Bit() : (int)TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id);
    }

    private int bufferLength() {
        return this.buf.length >> this.stride;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int byteLength() {
        return this.length << this.encoding.naturalStride;
    }

    TruffleString.Encoding getEncoding() {
        return this.encoding;
    }

    int getStride() {
        return this.stride;
    }

    int getCodeRange() {
        return this.codeRange;
    }

    private void updateCodeRange(int newCodeRange) {
        this.codeRange = TSCodeRange.commonCodeRange(this.codeRange, newCodeRange);
    }

    private void appendLength(int addLength) {
        this.appendLength(addLength, addLength);
    }

    private void appendLength(int addLength, int addCodePointLength) {
        this.length += addLength;
        this.codePointLength += addCodePointLength;
    }

    public static TruffleStringBuilder create(TruffleString.Encoding encoding) {
        return new TruffleStringBuilder(encoding);
    }

    public static TruffleStringBuilder create(TruffleString.Encoding encoding, int initialCapacity) {
        return new TruffleStringBuilder(encoding, initialCapacity);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendByteUncached(byte value2) {
        AppendByteNode.getUncached().execute(this, value2);
    }

    static int utf16Stride(TruffleStringBuilder sb, int value2) {
        return value2 <= 255 ? sb.stride : 1;
    }

    static int utf16CodeRange(int value2) {
        if (value2 <= 127) {
            return TSCodeRange.get7Bit();
        }
        if (value2 <= 255) {
            return TSCodeRange.get8Bit();
        }
        if (Encodings.isUTF16Surrogate(value2)) {
            return TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte());
        }
        if (value2 <= 65535) {
            return TSCodeRange.get16Bit();
        }
        return TSCodeRange.getValidMultiByte();
    }

    @CompilerDirectives.TruffleBoundary
    public void appendCharUTF16Uncached(char value2) {
        AppendCharUTF16Node.getUncached().execute(this, value2);
    }

    static int utf32Stride(TruffleStringBuilder sb, int value2) {
        return Math.max(sb.stride, value2 <= 255 ? 0 : (value2 <= 65535 && !Encodings.isUTF16Surrogate(value2) ? 1 : 2));
    }

    static int utf32CodeRange(int value2) {
        if (value2 <= 127) {
            return TSCodeRange.get7Bit();
        }
        if (value2 <= 255) {
            return TSCodeRange.get8Bit();
        }
        if (Encodings.isUTF16Surrogate(value2)) {
            return TSCodeRange.getBrokenFixedWidth();
        }
        if (value2 <= 65535) {
            return TSCodeRange.get16Bit();
        }
        return TSCodeRange.getValidFixedWidth();
    }

    @CompilerDirectives.TruffleBoundary
    public void appendCodePointUncached(int codepoint) {
        AppendCodePointNode.getUncached().execute(this, codepoint);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendCodePointUncached(int codepoint, int repeat2) {
        AppendCodePointNode.getUncached().execute(this, codepoint, repeat2);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendCodePointUncached(int codepoint, int repeat2, boolean allowUTF16Surrogates) {
        AppendCodePointNode.getUncached().execute(this, codepoint, repeat2, allowUTF16Surrogates);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendIntNumberUncached(int value2) {
        AppendIntNumberNode.getUncached().execute(this, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendLongNumberUncached(long value2) {
        AppendLongNumberNode.getUncached().execute(this, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendStringUncached(TruffleString a2) {
        AppendStringNode.getUncached().execute(this, a2);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendSubstringByteIndexUncached(TruffleString a2, int fromByteIndex, int byteLength) {
        AppendSubstringByteIndexNode.getUncached().execute(this, a2, fromByteIndex, byteLength);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendJavaStringUTF16Uncached(String a2) {
        AppendJavaStringUTF16Node.getUncached().execute(this, a2);
    }

    @CompilerDirectives.TruffleBoundary
    public void appendJavaStringUTF16Uncached(String a2, int fromCharIndex, int charLength) {
        AppendJavaStringUTF16Node.getUncached().execute(this, a2, fromCharIndex, charLength);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString toStringUncached() {
        return ToStringNode.getUncached().execute(this);
    }

    void ensureCapacityS0(Node node, int appendLength, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
        assert (this.stride == 0);
        long newLength = (long)this.length + (long)appendLength;
        if (bufferGrowProfile.profile(node, newLength > (long)this.bufferLength())) {
            long newBufferLength = ((long)this.bufferLength() << 1) + 2L;
            assert (newLength >= 0L);
            int maxLength = 0x7FFFFFF7;
            if (newLength > 0x7FFFFFF7L) {
                errorProfile.enter(node);
                throw InternalErrors.outOfMemory();
            }
            newBufferLength = Math.min(newBufferLength, 0x7FFFFFF7L);
            newBufferLength = Math.max(newBufferLength, newLength);
            this.buf = Arrays.copyOf(this.buf, (int)newBufferLength);
        }
    }

    void ensureCapacity(Node location, int appendLength, int curStride, int newStride, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
        assert (curStride == this.stride);
        assert (newStride >= this.stride);
        long newLength = (long)this.length + (long)appendLength;
        if (bufferGrowProfile.profile(location, curStride != newStride || newLength > (long)this.bufferLength())) {
            long newBufferLength;
            long l = newBufferLength = newLength > (long)this.bufferLength() ? ((long)this.bufferLength() << 1) + 2L : (long)this.bufferLength();
            assert (newLength >= 0L);
            int maxLength = 0x7FFFFFF7 >> newStride;
            if (newLength > (long)maxLength) {
                errorProfile.enter(location);
                throw InternalErrors.outOfMemory();
            }
            newBufferLength = Math.min(newBufferLength, (long)maxLength);
            newBufferLength = Math.max(newBufferLength, newLength);
            this.buf = TStringOps.arraycopyOfWithStride(location, this.buf, 0, this.length, curStride, (int)newBufferLength, newStride);
            this.stride = newStride;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return ToStringNode.getUncached().execute(this).toJavaStringUncached();
    }

    public static abstract class AppendByteNode
    extends AbstractPublicNode {
        AppendByteNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, byte var2);

        @Specialization
        final void append(TruffleStringBuilder sb, byte value2, @Cached InlinedConditionProfile bufferGrowProfile, @Cached InlinedBranchProfile errorProfile) {
            if (TStringGuards.isUTF16Or32(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendByte is not supported for UTF-16 and UTF-32, use appendChar and appendInt instead");
            }
            sb.ensureCapacityS0(this, 1, bufferGrowProfile, errorProfile);
            sb.buf[sb.length++] = value2;
            if (value2 < 0) {
                sb.codeRange = TSCodeRange.asciiLatinBytesNonAsciiCodeRange(sb.encoding);
            }
            ++sb.codePointLength;
        }

        @NeverDefault
        public static AppendByteNode create() {
            return TruffleStringBuilderFactory.AppendByteNodeGen.create();
        }

        public static AppendByteNode getUncached() {
            return TruffleStringBuilderFactory.AppendByteNodeGen.getUncached();
        }
    }

    public static abstract class AppendCharUTF16Node
    extends AbstractPublicNode {
        AppendCharUTF16Node() {
        }

        public abstract void execute(TruffleStringBuilder var1, char var2);

        @Specialization(guards={"cachedCurCompaction.getStride() == sb.stride", "cachedNewCompaction.getStride() == utf16Stride(sb, value)"}, limit="9")
        static void doCached(TruffleStringBuilder sb, char value2, @Bind(value="this") Node node, @Cached(value="fromStride(sb.stride)") TruffleString.CompactionLevel cachedCurCompaction, @Cached(value="fromStride(utf16Stride(sb, value))") TruffleString.CompactionLevel cachedNewCompaction, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            AppendCharUTF16Node.doAppend(node, sb, value2, cachedCurCompaction.getStride(), cachedNewCompaction.getStride(), bufferGrowProfile, errorProfile);
        }

        @Specialization(replaces={"doCached"})
        void doUncached(TruffleStringBuilder sb, char value2, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            AppendCharUTF16Node.doAppend(this, sb, value2, sb.stride, TruffleStringBuilder.utf16Stride(sb, value2), bufferGrowProfile, errorProfile);
        }

        private static void doAppend(Node node, TruffleStringBuilder sb, char value2, int cachedCurStride, int cachedNewStride, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
            if (!TStringGuards.isUTF16(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendChar is meant for UTF-16 strings only");
            }
            sb.ensureCapacity(node, 1, cachedCurStride, cachedNewStride, bufferGrowProfile, errorProfile);
            sb.updateCodeRange(TruffleStringBuilder.utf16CodeRange(value2));
            TStringOps.writeToByteArray(sb.buf, cachedNewStride, sb.length, value2);
            sb.appendLength(1);
        }

        @NeverDefault
        public static AppendCharUTF16Node create() {
            return TruffleStringBuilderFactory.AppendCharUTF16NodeGen.create();
        }

        public static AppendCharUTF16Node getUncached() {
            return TruffleStringBuilderFactory.AppendCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class AppendCodePointNode
    extends AbstractPublicNode {
        AppendCodePointNode() {
        }

        public final void execute(TruffleStringBuilder sb, int codepoint) {
            this.execute(sb, codepoint, 1);
        }

        public final void execute(TruffleStringBuilder sb, int codepoint, int repeat2) {
            this.execute(sb, codepoint, repeat2, false);
        }

        public abstract void execute(TruffleStringBuilder var1, int var2, int var3, boolean var4);

        @Specialization
        final void append(TruffleStringBuilder sb, int c, int repeat2, boolean allowUTF16Surrogates, @Cached AppendCodePointIntlNode appendCodePointIntlNode) {
            assert (!allowUTF16Surrogates || TStringGuards.isUTF16Or32(sb.encoding)) : "allowUTF16Surrogates is only supported on UTF-16 and UTF-32";
            if (c < 0 || c > 0x10FFFF) {
                throw InternalErrors.invalidCodePoint(c);
            }
            if (repeat2 < 1) {
                throw InternalErrors.illegalArgument("number of repetitions must be at least 1");
            }
            appendCodePointIntlNode.execute(this, sb, c, sb.encoding, repeat2, allowUTF16Surrogates);
            sb.codePointLength += repeat2;
        }

        @NeverDefault
        public static AppendCodePointNode create() {
            return TruffleStringBuilderFactory.AppendCodePointNodeGen.create();
        }

        public static AppendCodePointNode getUncached() {
            return TruffleStringBuilderFactory.AppendCodePointNodeGen.getUncached();
        }
    }

    public static abstract class AppendIntNumberNode
    extends AbstractPublicNode {
        AppendIntNumberNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, int var2);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        void doAppend(TruffleStringBuilder sb, int value2, @Bind(value="fromStride(sb.stride)") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            if (!TStringGuards.is7BitCompatible(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendIntNumber is supported on ASCII-compatible encodings only");
            }
            int len = NumberConversion.stringLengthInt(value2);
            int cachedStride = cachedCompaction.getStride();
            sb.ensureCapacity(this, len, cachedStride, cachedStride, bufferGrowProfile, errorProfile);
            NumberConversion.writeIntToBytes(this, value2, sb.buf, cachedStride, sb.length, len);
            sb.appendLength(len);
        }

        @NeverDefault
        public static AppendIntNumberNode create() {
            return TruffleStringBuilderFactory.AppendIntNumberNodeGen.create();
        }

        public static AppendIntNumberNode getUncached() {
            return TruffleStringBuilderFactory.AppendIntNumberNodeGen.getUncached();
        }
    }

    public static abstract class AppendLongNumberNode
    extends AbstractPublicNode {
        AppendLongNumberNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, long var2);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        void doAppend(TruffleStringBuilder sb, long value2, @Bind(value="fromStride(sb.stride)") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedConditionProfile bufferGrowProfile, @Cached InlinedBranchProfile errorProfile) {
            if (!TStringGuards.is7BitCompatible(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendIntNumber is supported on ASCII-compatible encodings only");
            }
            int cachedStride = cachedCompaction.getStride();
            int len = NumberConversion.stringLengthLong(value2);
            sb.ensureCapacity(this, len, cachedStride, cachedStride, bufferGrowProfile, errorProfile);
            NumberConversion.writeLongToBytes(this, value2, sb.buf, cachedStride, sb.length, len);
            sb.appendLength(len);
        }

        @NeverDefault
        public static AppendLongNumberNode create() {
            return TruffleStringBuilderFactory.AppendLongNumberNodeGen.create();
        }

        public static AppendLongNumberNode getUncached() {
            return TruffleStringBuilderFactory.AppendLongNumberNodeGen.getUncached();
        }
    }

    public static abstract class AppendStringNode
    extends AbstractPublicNode {
        AppendStringNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, AbstractTruffleString var2);

        @Specialization
        void append(TruffleStringBuilder sb, AbstractTruffleString a2, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached AppendArrayIntlNode appendArrayIntlNode) {
            if (a2.length() == 0) {
                return;
            }
            a2.checkEncoding(sb.encoding);
            Object arrayA = toIndexableNode.execute(this, a2, a2.data());
            int codeRangeA = getPreciseCodeRangeNode.execute(this, a2, sb.encoding);
            sb.updateCodeRange(codeRangeA);
            int newStride = Math.max(sb.stride, Stride.fromCodeRangeAllowImprecise(codeRangeA, sb.encoding));
            appendArrayIntlNode.execute(this, sb, arrayA, a2.offset(), a2.length(), a2.stride(), newStride);
            sb.appendLength(a2.length(), getCodePointLengthNode.execute(this, a2, sb.encoding));
        }

        @NeverDefault
        public static AppendStringNode create() {
            return TruffleStringBuilderFactory.AppendStringNodeGen.create();
        }

        public static AppendStringNode getUncached() {
            return TruffleStringBuilderFactory.AppendStringNodeGen.getUncached();
        }
    }

    public static abstract class AppendSubstringByteIndexNode
    extends AbstractPublicNode {
        AppendSubstringByteIndexNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, AbstractTruffleString var2, int var3, int var4);

        @Specialization
        final void append(TruffleStringBuilder sb, AbstractTruffleString a2, int fromByteIndex, int byteLength, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached AppendArrayIntlNode appendArrayIntlNode, @Cached TStringInternalNodes.CalcStringAttributesNode calcAttributesNode, @Cached InlinedConditionProfile calcAttrsProfile) {
            int codePointLength;
            int codeRange;
            if (byteLength == 0) {
                return;
            }
            a2.checkEncoding(sb.encoding);
            int fromIndex = TruffleString.rawIndex(fromByteIndex, sb.encoding);
            int length2 = TruffleString.rawIndex(byteLength, sb.encoding);
            a2.boundsCheckRegionRaw(fromIndex, length2);
            Object arrayA = toIndexableNode.execute(this, a2, a2.data());
            int codeRangeA = getPreciseCodeRangeNode.execute(this, a2, sb.encoding);
            if (fromIndex == 0 && length2 == a2.length()) {
                codeRange = codeRangeA;
                codePointLength = getCodePointLengthNode.execute(this, a2, sb.encoding);
            } else if (TStringGuards.isFixedWidth(codeRangeA) && !TSCodeRange.isMoreGeneralThan(codeRangeA, sb.codeRange)) {
                codeRange = codeRangeA;
                codePointLength = length2;
            } else if (calcAttrsProfile.profile(this, !TStringGuards.isBroken(sb.codeRange))) {
                long attrs = calcAttributesNode.execute(this, a2, arrayA, a2.offset(), length2, a2.stride(), sb.encoding, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = TSCodeRange.getUnknownCodeRangeForEncoding(sb.encoding.id);
                codePointLength = 0;
            }
            sb.updateCodeRange(codeRange);
            appendArrayIntlNode.execute(this, sb, arrayA, a2.offset() + (fromIndex << a2.stride()), length2, a2.stride(), Stride.fromCodeRangeAllowImprecise(sb.codeRange, sb.encoding));
            sb.appendLength(length2, codePointLength);
        }

        @NeverDefault
        public static AppendSubstringByteIndexNode create() {
            return TruffleStringBuilderFactory.AppendSubstringByteIndexNodeGen.create();
        }

        public static AppendSubstringByteIndexNode getUncached() {
            return TruffleStringBuilderFactory.AppendSubstringByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class AppendJavaStringUTF16Node
    extends AbstractPublicNode {
        AppendJavaStringUTF16Node() {
        }

        public final void execute(TruffleStringBuilder sb, String a2) {
            this.execute(sb, a2, 0, a2.length());
        }

        public abstract void execute(TruffleStringBuilder var1, String var2, int var3, int var4);

        @Specialization
        final void append(TruffleStringBuilder sb, String javaString, int fromIndex, int lengthStr, @Cached AppendArrayIntlNode appendArrayIntlNode, @Cached InlinedConditionProfile stride0Profile) {
            int appendCodePointLength;
            if (!TStringGuards.isUTF16(sb)) {
                throw InternalErrors.unsupportedOperation("appendJavaString is supported on UTF-16 only, use appendString for other encodings");
            }
            if (lengthStr == 0) {
                return;
            }
            AbstractTruffleString.boundsCheckRegionI(fromIndex, lengthStr, javaString.length());
            byte[] arrayStr = TStringUnsafe.getJavaStringArray(javaString);
            int strideStr = TStringUnsafe.getJavaStringStride(javaString);
            int offsetStr = fromIndex << strideStr;
            if (stride0Profile.profile(this, strideStr == 0)) {
                if (TStringGuards.is7Bit(sb.codeRange)) {
                    sb.updateCodeRange(TStringOps.calcStringAttributesLatin1(this, arrayStr, offsetStr, lengthStr));
                }
                appendCodePointLength = lengthStr;
            } else if (!TStringGuards.isBrokenMultiByte(sb.codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(this, arrayStr, offsetStr, lengthStr, false);
                sb.updateCodeRange(StringAttributes.getCodeRange(attrs));
                appendCodePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                appendCodePointLength = 0;
            }
            appendArrayIntlNode.execute(this, sb, arrayStr, offsetStr, lengthStr, strideStr, Stride.fromCodeRangeUTF16AllowImprecise(sb.codeRange));
            sb.appendLength(lengthStr, appendCodePointLength);
        }

        @NeverDefault
        public static AppendJavaStringUTF16Node create() {
            return TruffleStringBuilderFactory.AppendJavaStringUTF16NodeGen.create();
        }

        public static AppendJavaStringUTF16Node getUncached() {
            return TruffleStringBuilderFactory.AppendJavaStringUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ToStringNode
    extends AbstractPublicNode {
        ToStringNode() {
        }

        public final TruffleString execute(TruffleStringBuilder sb) {
            return this.execute(sb, false);
        }

        public abstract TruffleString execute(TruffleStringBuilder var1, boolean var2);

        @Specialization
        final TruffleString createString(TruffleStringBuilder sb, boolean lazy, @Cached InlinedConditionProfile calcAttributesProfile, @Cached TStringInternalNodes.CalcStringAttributesNode calcAttributesNode) {
            int codePointLength;
            int codeRange;
            if (sb.length == 0) {
                return sb.encoding.getEmpty();
            }
            if (calcAttributesProfile.profile(this, !TSCodeRange.isPrecise(sb.codeRange) || TSCodeRange.isBrokenMultiByte(sb.codeRange))) {
                long attrs = calcAttributesNode.execute(this, null, sb.buf, 0, sb.length, sb.stride, sb.encoding, 0, sb.codeRange);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = sb.codeRange;
                codePointLength = sb.codePointLength;
            }
            int byteLength = sb.length << sb.stride;
            byte[] bytes = lazy || sb.buf.length == byteLength ? sb.buf : Arrays.copyOf(sb.buf, byteLength);
            return TruffleString.createFromByteArray(bytes, sb.length, sb.stride, sb.encoding, codePointLength, codeRange);
        }

        @NeverDefault
        public static ToStringNode create() {
            return TruffleStringBuilderFactory.ToStringNodeGen.create();
        }

        public static ToStringNode getUncached() {
            return TruffleStringBuilderFactory.ToStringNodeGen.getUncached();
        }
    }

    static abstract class AppendArrayIntlNode
    extends AbstractInternalNode {
        AppendArrayIntlNode() {
        }

        abstract void execute(Node var1, TruffleStringBuilder var2, Object var3, int var4, int var5, int var6, int var7);

        @Specialization(guards={"sb.stride == cachedStrideSB", "strideA == cachedStrideA", "strideNew == cachedStrideNew"}, limit="9")
        static void doCached(Node node, TruffleStringBuilder sb, Object array, int offsetA, int lengthA, int strideA, int strideNew, @Cached(value="sb.stride") int cachedStrideSB, @Cached(value="strideA") int cachedStrideA, @Cached(value="strideNew") int cachedStrideNew, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            AppendArrayIntlNode.doAppend(node, sb, array, offsetA, lengthA, cachedStrideSB, cachedStrideA, cachedStrideNew, bufferGrowProfile, errorProfile);
        }

        @Specialization(replaces={"doCached"})
        static void doUncached(Node node, TruffleStringBuilder sb, Object array, int offsetA, int lengthA, int strideA, int strideNew, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            AppendArrayIntlNode.doAppend(node, sb, array, offsetA, lengthA, sb.stride, strideA, strideNew, bufferGrowProfile, errorProfile);
        }

        private static void doAppend(Node location, TruffleStringBuilder sb, Object array, int offsetA, int lengthA, int cachedStrideSB, int cachedStrideA, int cachedStrideNew, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
            sb.ensureCapacity(location, lengthA, cachedStrideSB, cachedStrideNew, bufferGrowProfile, errorProfile);
            assert (sb.stride == cachedStrideNew);
            TStringOps.arraycopyWithStride(location, array, offsetA, cachedStrideA, 0, sb.buf, 0, cachedStrideNew, sb.length, lengthA);
        }
    }

    @ImportStatic(value={TruffleStringBuilder.class})
    static abstract class AppendCodePointIntlNode
    extends AbstractInternalNode {
        AppendCodePointIntlNode() {
        }

        abstract void execute(Node var1, TruffleStringBuilder var2, int var3, TruffleString.Encoding var4, int var5, boolean var6);

        @Specialization(guards={"isAsciiBytesOrLatin1(enc)"})
        static void bytes(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            if (c > 255) {
                throw InternalErrors.invalidCodePoint(c);
            }
            sb.ensureCapacityS0(node, n, bufferGrowProfile, errorProfile);
            if (c > 127) {
                sb.updateCodeRange(TSCodeRange.asciiLatinBytesNonAsciiCodeRange(sb.encoding));
            }
            Arrays.fill(sb.buf, sb.length, sb.length + n, (byte)c);
            sb.length += n;
        }

        @Specialization(guards={"isUTF8(enc)"})
        static void utf8(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            if (Encodings.isUTF16Surrogate(c)) {
                throw InternalErrors.invalidCodePoint(c);
            }
            int length2 = Encodings.utf8EncodedSize(c);
            sb.ensureCapacityS0(node, length2 * n, bufferGrowProfile, errorProfile);
            for (int i2 = 0; i2 < n; ++i2) {
                Encodings.utf8Encode(c, sb.buf, sb.length, length2);
                sb.length += length2;
            }
            if (c > 127) {
                sb.updateCodeRange(TSCodeRange.getValidMultiByte());
            }
        }

        @Specialization(guards={"isUTF16(enc)", "cachedCurStride == sb.stride", "cachedNewStride == utf16Stride(sb, c)"}, limit="9")
        static void utf16Cached(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile, @Cached(value="sb.stride") int cachedCurStride, @Cached(value="utf16Stride(sb, c)") int cachedNewStride, @Cached.Shared(value="bmp") @Cached InlinedConditionProfile bmpProfile) {
            AppendCodePointIntlNode.doUTF16(node, sb, c, n, allowUTF16Surrogates, bufferGrowProfile, errorProfile, cachedCurStride, cachedNewStride, bmpProfile);
        }

        @Specialization(guards={"isUTF16(enc)"}, replaces={"utf16Cached"})
        static void utf16Uncached(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile, @Cached.Shared(value="bmp") @Cached InlinedConditionProfile bmpProfile) {
            AppendCodePointIntlNode.doUTF16(node, sb, c, n, allowUTF16Surrogates, bufferGrowProfile, errorProfile, sb.stride, TruffleStringBuilder.utf16Stride(sb, c), bmpProfile);
        }

        private static void doUTF16(Node node, TruffleStringBuilder sb, int c, int n, boolean allowUTF16Surrogates, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile, int cachedCurStride, int cachedNewStride, InlinedConditionProfile bmpProfile) {
            if (!allowUTF16Surrogates && Encodings.isUTF16Surrogate(c)) {
                throw InternalErrors.invalidCodePoint(c);
            }
            sb.ensureCapacity(node, c <= 65535 ? n : n << 1, cachedCurStride, cachedNewStride, bufferGrowProfile, errorProfile);
            sb.updateCodeRange(TruffleStringBuilder.utf16CodeRange(c));
            if (bmpProfile.profile(node, c <= 65535)) {
                AppendCodePointIntlNode.arrayFill(sb, c, n, cachedNewStride);
            } else {
                for (int i2 = 0; i2 < n; ++i2) {
                    Encodings.utf16EncodeSurrogatePair(c, sb.buf, sb.length);
                    sb.length += 2;
                }
            }
        }

        @Specialization(guards={"isUTF32(enc)", "cachedCurStride == sb.stride", "cachedNewStride == utf32Stride(sb, c)"}, limit="9")
        static void utf32Cached(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile, @Cached(value="sb.stride") int cachedCurStride, @Cached(value="utf32Stride(sb, c)") int cachedNewStride) {
            AppendCodePointIntlNode.doUTF32(node, sb, c, n, allowUTF16Surrogates, bufferGrowProfile, errorProfile, cachedCurStride, cachedNewStride);
        }

        @Specialization(guards={"isUTF32(enc)"}, replaces={"utf32Cached"})
        static void utf32Uncached(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            AppendCodePointIntlNode.doUTF32(node, sb, c, n, allowUTF16Surrogates, bufferGrowProfile, errorProfile, sb.stride, TruffleStringBuilder.utf32Stride(sb, c));
        }

        static void doUTF32(Node node, TruffleStringBuilder sb, int c, int n, boolean allowUTF16Surrogates, InlinedConditionProfile bufferGrowProfile, InlinedBranchProfile errorProfile, int cachedCurStride, int cachedNewStride) {
            if (!allowUTF16Surrogates && Encodings.isUTF16Surrogate(c)) {
                throw InternalErrors.invalidCodePoint(c);
            }
            sb.ensureCapacity(node, n, cachedCurStride, cachedNewStride, bufferGrowProfile, errorProfile);
            sb.updateCodeRange(TruffleStringBuilder.utf32CodeRange(c));
            AppendCodePointIntlNode.arrayFill(sb, c, n, cachedNewStride);
        }

        @Specialization(guards={"isUnsupportedEncoding(enc)"})
        static void unsupported(Node node, TruffleStringBuilder sb, int c, TruffleString.Encoding enc, int n, boolean allowUTF16Surrogates, @Cached.Shared(value="bufferGrow") @Cached InlinedConditionProfile bufferGrowProfile, @Cached.Shared(value="error") @Cached InlinedBranchProfile errorProfile) {
            JCodings.Encoding jCodingsEnc = JCodings.getInstance().get(enc);
            int length2 = JCodings.getInstance().getCodePointLength(jCodingsEnc, c);
            if (!enc.is7BitCompatible() || c > 127) {
                sb.updateCodeRange(TSCodeRange.getValid(JCodings.getInstance().isSingleByte(jCodingsEnc)));
            }
            if (length2 < 1) {
                throw InternalErrors.invalidCodePoint(c);
            }
            sb.ensureCapacityS0(node, length2 * n, bufferGrowProfile, errorProfile);
            for (int i2 = 0; i2 < n; ++i2) {
                int ret = JCodings.getInstance().writeCodePoint(jCodingsEnc, c, sb.buf, sb.length);
                if (ret != length2 || JCodings.getInstance().getCodePointLength(jCodingsEnc, sb.buf, sb.length, sb.length + length2) != ret || JCodings.getInstance().readCodePoint(jCodingsEnc, sb.buf, sb.length, sb.length + length2, TruffleString.ErrorHandling.RETURN_NEGATIVE) != c) {
                    throw InternalErrors.invalidCodePoint(c);
                }
                sb.length += length2;
            }
        }

        private static void arrayFill(TruffleStringBuilder sb, int c, int n, int stride) {
            byte[] buf = sb.buf;
            int from = sb.length;
            int to = from + n;
            for (int i2 = from; i2 < to; ++i2) {
                TStringOps.writeToByteArray(buf, stride, i2, c);
            }
            sb.length = to;
        }
    }
}

