/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.host;

import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.interop.InteropException;
import org.pkl.thirdparty.truffle.api.nodes.EncapsulatingNodeReference;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.host.HostAccessor;
import org.pkl.thirdparty.truffle.host.HostContext;

abstract class GuestToHostRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    private final String boundaryName;

    protected GuestToHostRootNode(Class<?> targetType, String methodName) {
        super(null);
        this.boundaryName = targetType.getName() + "." + methodName;
    }

    @Override
    protected boolean isInstrumentable() {
        return false;
    }

    @Override
    public boolean isCloningAllowed() {
        return false;
    }

    @Override
    public final String getName() {
        return this.boundaryName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments2 = frame.getArguments();
        try {
            return this.executeImpl(arguments2[1], arguments2);
        }
        catch (InteropException e2) {
            throw GuestToHostRootNode.silenceException(RuntimeException.class, e2);
        }
        catch (Throwable e3) {
            throw ((HostContext)arguments2[0]).hostToGuestException(e3);
        }
    }

    static <E extends Throwable> RuntimeException silenceException(Class<E> type2, Throwable ex) throws E {
        throw ex;
    }

    protected abstract Object executeImpl(Object var1, Object[] var2) throws InteropException;

    static Object guestToHostCall(Node node, CallTarget target, Object ... arguments2) {
        Node encapsulatingNode = node.isAdoptable() ? node : EncapsulatingNodeReference.getCurrent().get();
        return HostAccessor.RUNTIME.callInlined(encapsulatingNode, target, arguments2);
    }
}

