/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.host;

import java.util.Collection;
import java.util.Objects;
import org.pkl.thirdparty.graalvm.collections.EconomicSet;
import org.pkl.thirdparty.graalvm.collections.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.NeverDefault;
import org.pkl.thirdparty.truffle.api.interop.ArityException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnknownIdentifierException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.CachedLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.host.HostAdapterFactory;
import org.pkl.thirdparty.truffle.host.HostClassDesc;
import org.pkl.thirdparty.truffle.host.HostObject;

@ExportLibrary(value=InteropLibrary.class)
final class HostAdapterSuperMembers
implements TruffleObject {
    final HostObject adapter;

    HostAdapterSuperMembers(HostObject adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public Object getAdapter() {
        return this.adapter;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object readMember(String name, @Cached.Shared(value="cache") @Cached NameCache cache2, @CachedLibrary(value="this.adapter") InteropLibrary interop) throws UnsupportedMessageException, UnknownIdentifierException {
        String superMethodName = cache2.getSuperMethodName(name);
        return interop.readMember(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    Object invokeMember(String name, Object[] args2, @Cached.Shared(value="cache") @Cached NameCache cache2, @CachedLibrary(value="this.adapter") InteropLibrary interop) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
        String superMethodName = cache2.getSuperMethodName(name);
        return interop.invokeMember(this.getAdapter(), superMethodName, args2);
    }

    @ExportMessage
    boolean isMemberReadable(String name, @Cached.Shared(value="cache") @Cached NameCache cache2, @CachedLibrary(value="this.adapter") InteropLibrary interop) {
        String superMethodName = cache2.getSuperMethodName(name);
        return interop.isMemberReadable(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    boolean isMemberInvocable(String name, @Cached.Shared(value="cache") @Cached NameCache cache2, @CachedLibrary(value="this.adapter") InteropLibrary interop) {
        String superMethodName = cache2.getSuperMethodName(name);
        return interop.isMemberInvocable(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new HostObject.KeysArray(includeInternal ? this.collectSuperMembers() : new String[]{});
    }

    @CompilerDirectives.TruffleBoundary
    private String[] collectSuperMembers() {
        HostClassDesc classDesc = HostClassDesc.forClass(this.adapter.context, this.adapter.getLookupClass());
        EconomicSet<String> names2 = EconomicSet.create();
        Collection<String> methodNames = classDesc.getMethodNames(false, true);
        for (String name : methodNames) {
            if (!name.startsWith("super$")) continue;
            names2.add(name.substring("super$".length()));
        }
        return names2.toArray(new String[names2.size()]);
    }

    static final class NameCache {
        @CompilerDirectives.CompilationFinal
        private Pair<String, String> cachedNameToSuper;
        private static final NameCache UNCACHED = new NameCache(true);

        NameCache() {
        }

        NameCache(boolean uncached) {
            if (uncached) {
                this.cachedNameToSuper = Pair.empty();
            }
        }

        String getSuperMethodName(String name) {
            String cachedName;
            if (this.cachedNameToSuper == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedNameToSuper = Pair.create(name, HostAdapterFactory.getSuperMethodName(name));
            }
            if ((cachedName = this.cachedNameToSuper.getLeft()) != null) {
                if (cachedName.equals(name)) {
                    return this.cachedNameToSuper.getRight();
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedNameToSuper = Pair.empty();
                return HostAdapterFactory.getSuperMethodName(name);
            }
            return HostAdapterFactory.getSuperMethodName(name);
        }

        @NeverDefault
        static NameCache create() {
            return new NameCache();
        }

        static NameCache getUncached() {
            return UNCACHED;
        }
    }
}

