/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.host;

import org.pkl.thirdparty.truffle.api.exception.AbstractTruffleException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.host.HostAccessor;
import org.pkl.thirdparty.truffle.host.HostContext;
import org.pkl.thirdparty.truffle.host.HostObject;

@ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
final class HostException
extends AbstractTruffleException {
    private final Throwable original;
    final HostObject delegate;

    private HostException(Throwable original, HostContext context2, Node location) {
        super(location);
        this.original = original;
        this.delegate = HostObject.forException(original, context2, this);
    }

    Throwable getOriginal() {
        return this.original;
    }

    @Override
    public String getMessage() {
        return this.getOriginal().getMessage();
    }

    static HostException wrap(Throwable original, HostContext context2) {
        return HostException.wrap(original, context2, null);
    }

    static HostException wrap(Throwable original, HostContext context2, Node location) {
        HostException hostException = new HostException(original, context2, location);
        HostAccessor.EXCEPTION.setLazyStackTrace(hostException, HostAccessor.LANGUAGE.getOrCreateLazyStackTrace(original));
        return hostException;
    }

    HostException withContext(HostContext context2) {
        HostException hostException = new HostException(this.original, context2, this.getLocation());
        HostAccessor.EXCEPTION.setLazyStackTrace(this, HostAccessor.EXCEPTION.getLazyStackTrace(hostException));
        return hostException;
    }
}

