/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.host;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.interop.ArityException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.utilities.TriState;
import org.pkl.thirdparty.truffle.host.HostContext;
import org.pkl.thirdparty.truffle.host.HostExecuteNode;
import org.pkl.thirdparty.truffle.host.HostLanguage;
import org.pkl.thirdparty.truffle.host.HostMethodDesc;

@ExportLibrary(value=InteropLibrary.class)
final class HostFunction
implements TruffleObject {
    final Object obj;
    final HostMethodDesc method;
    final HostContext context;

    HostFunction(HostMethodDesc method, Object obj, HostContext context2) {
        this.method = method;
        this.obj = obj;
        this.context = context2;
    }

    public static boolean isInstance(HostLanguage language, TruffleObject obj) {
        return HostFunction.isInstance(language, (Object)obj);
    }

    public static boolean isInstance(HostLanguage language, Object obj) {
        return HostLanguage.unwrapIfScoped(language, obj) instanceof HostFunction;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args2, @Bind(value="$node") Node node, @Cached HostExecuteNode execute) throws UnsupportedTypeException, ArityException {
        return execute.execute(node, this.method, this.obj, args2, this.context);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return HostLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String toDisplayString(boolean allowSideEffects) {
        if (this.obj == null) {
            return "null";
        }
        String declaringClassName = this.method.getDeclaringClassName();
        if (declaringClassName == null) {
            declaringClassName = this.obj.getClass().getName();
        }
        return declaringClassName + "." + this.method.getName();
    }

    @ExportMessage
    static int identityHashCode(HostFunction receiver) {
        return System.identityHashCode(receiver.method);
    }

    public boolean equals(Object o) {
        if (o instanceof HostFunction) {
            HostFunction other = (HostFunction)o;
            return this.method == other.method && this.obj == other.obj && this.context == other.context;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(HostFunction receiver, HostFunction other) {
            return receiver.method == other.method && receiver.obj == other.obj ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(HostFunction receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

