/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.host;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.pkl.thirdparty.graalvm.polyglot.HostAccess;
import org.pkl.thirdparty.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.pkl.thirdparty.graalvm.polyglot.proxy.Proxy;
import org.pkl.thirdparty.truffle.api.CompilerAsserts;
import org.pkl.thirdparty.truffle.api.TruffleFile;
import org.pkl.thirdparty.truffle.api.TruffleOptions;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.host.GuestToHostCodeCache;
import org.pkl.thirdparty.truffle.host.HostAccessor;
import org.pkl.thirdparty.truffle.host.HostAdapterFactory;
import org.pkl.thirdparty.truffle.host.HostContext;
import org.pkl.thirdparty.truffle.host.HostEngineException;
import org.pkl.thirdparty.truffle.host.HostException;
import org.pkl.thirdparty.truffle.host.HostFunction;
import org.pkl.thirdparty.truffle.host.HostLanguage;
import org.pkl.thirdparty.truffle.host.HostMethodDesc;
import org.pkl.thirdparty.truffle.host.HostMethodScope;
import org.pkl.thirdparty.truffle.host.HostObject;
import org.pkl.thirdparty.truffle.host.HostProxy;
import org.pkl.thirdparty.truffle.host.HostToTypeNode;
import org.pkl.thirdparty.truffle.host.HostToTypeNodeGen;

public class HostLanguageService
extends AbstractPolyglotImpl.AbstractHostLanguageService {
    final HostLanguage language;
    private final AbstractPolyglotImpl.APIAccess api;

    HostLanguageService(AbstractPolyglotImpl polyglot, HostLanguage language) {
        super(polyglot);
        this.api = polyglot.getAPIAccess();
        this.language = language;
    }

    @Override
    public void release() {
    }

    @Override
    public void initializeHostContext(Object internalContext, Object receiver, HostAccess hostAccess, ClassLoader cl, Predicate<String> clFilter, boolean hostCLAllowed, boolean hostLookupAllowed) {
        HostContext context2 = (HostContext)receiver;
        ClassLoader useCl = cl;
        if (useCl == null) {
            useCl = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
        }
        this.language.initializeHostAccess(hostAccess, useCl);
        context2.initialize(internalContext, useCl, clFilter, hostCLAllowed, hostLookupAllowed, hostAccess != null ? this.api.getMutableTargetMappings(hostAccess) : new HostAccess.MutableTargetMapping[]{});
    }

    @Override
    public void addToHostClassPath(Object receiver, Object truffleFile) {
        HostContext context2 = (HostContext)receiver;
        context2.addToHostClasspath((TruffleFile)truffleFile);
    }

    @Override
    public Object findDynamicClass(Object receiver, String classValue) {
        HostContext context2 = (HostContext)receiver;
        Class<?> found = context2.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forClass(found, context2);
    }

    @Override
    public void throwHostLanguageException(String message) {
        throw new HostLanguage.HostLanguageException(message);
    }

    @Override
    public Object findStaticClass(Object receiver, String classValue) {
        HostContext context2 = (HostContext)receiver;
        Class<?> found = context2.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forStaticClass(found, context2);
    }

    @Override
    public <T> T toHostType(Object hostNode, Object targetNode, Object hostContext, Object value2, Class<T> targetType, Type genericType) {
        HostContext context2 = (HostContext)hostContext;
        HostToTypeNode node = (HostToTypeNode)hostNode;
        if (node == null) {
            node = HostToTypeNodeGen.getUncached();
        }
        return (T)node.execute((Node)targetNode, context2, value2, targetType, genericType, true);
    }

    @Override
    public Object asHostStaticClass(Object context2, Class<?> value2) {
        return HostObject.forStaticClass(value2, (HostContext)context2);
    }

    @Override
    public Object toGuestValue(Object hostContext, Object hostValue, boolean asValue) {
        HostContext context2 = (HostContext)hostContext;
        assert (this.validHostValue(hostValue, context2)) : "polyglot unboxing should be a no-op at this point.";
        if (HostContext.isGuestPrimitive(hostValue)) {
            return hostValue;
        }
        if (hostValue instanceof Proxy) {
            return HostProxy.toProxyGuestObject(context2, (Proxy)hostValue);
        }
        if (!asValue && hostValue instanceof HostMethodScope.ScopedObject) {
            return ((HostMethodScope.ScopedObject)hostValue).unwrapForGuest();
        }
        if (hostValue instanceof TruffleObject) {
            return hostValue;
        }
        if (hostValue instanceof Class) {
            return HostObject.forClass((Class)hostValue, context2);
        }
        if (hostValue == null) {
            return HostObject.NULL;
        }
        return HostObject.forObject(hostValue, context2);
    }

    private boolean validHostValue(Object hostValue, HostContext context2) {
        Object unboxed = this.language.access.toGuestValue(context2.internalContext, hostValue);
        return unboxed == hostValue;
    }

    @Override
    public boolean isHostValue(Object value2) {
        Object obj = HostLanguage.unwrapIfScoped(this.language, value2);
        return obj instanceof HostObject || obj instanceof HostFunction || obj instanceof HostException || obj instanceof HostProxy;
    }

    @Override
    public Object unboxHostObject(Object hostValue) {
        return HostObject.valueOf(this.language, hostValue);
    }

    @Override
    public Object unboxProxyObject(Object hostValue) {
        return HostProxy.toProxyHostObject(this.language, hostValue);
    }

    @Override
    public Throwable unboxHostException(Throwable hostValue) {
        if (hostValue instanceof HostException) {
            return ((HostException)hostValue).getOriginal();
        }
        return null;
    }

    @Override
    public Object toHostObject(Object hostContext, Object value2) {
        HostContext context2 = (HostContext)hostContext;
        return HostObject.forObject(value2, context2);
    }

    @Override
    public Object asHostDynamicClass(Object context2, Class<?> value2) {
        return null;
    }

    @Override
    public boolean isHostException(Object exception) {
        return exception instanceof HostException;
    }

    @Override
    public boolean isHostFunction(Object value2) {
        return HostFunction.isInstance(this.language, value2);
    }

    @Override
    public boolean isHostObject(Object value2) {
        return HostObject.isInstance(this.language, value2);
    }

    @Override
    public boolean isHostProxy(Object value2) {
        return HostProxy.isProxyGuestObject(this.language, value2);
    }

    @Override
    public boolean isHostSymbol(Object obj) {
        Object o = HostLanguage.unwrapIfScoped(this.language, obj);
        if (o instanceof HostObject) {
            return ((HostObject)o).isStaticClass();
        }
        return false;
    }

    @Override
    public Object createHostAdapter(Object context2, Object[] hostTypes, Object classOverrides) {
        CompilerAsserts.neverPartOfCompilation();
        HostContext hostContext = (HostContext)context2;
        Class[] javaTypes = new Class[hostTypes.length];
        for (int i2 = 0; i2 < hostTypes.length; ++i2) {
            HostObject hostType;
            Object type2 = hostTypes[i2];
            if (!(type2 instanceof HostObject) || !(hostType = (HostObject)type2).isDefaultClass()) {
                throw HostEngineException.illegalArgument(hostContext.getHostClassCache().polyglotHostAccess, "Types must be host symbols or host classes.");
            }
            javaTypes[i2] = hostType.asClass();
        }
        HostAdapterFactory.AdapterResult adapter = HostAdapterFactory.getAdapterClassFor(hostContext, javaTypes, classOverrides);
        if (!adapter.isSuccess()) {
            throw adapter.throwException();
        }
        return HostObject.forStaticClass(adapter.getAdapterClass(), hostContext);
    }

    @Override
    public RuntimeException toHostException(Object context2, Throwable exception) {
        HostContext hostContext = (HostContext)context2;
        return HostException.wrap(exception, hostContext);
    }

    @Override
    public Object migrateValue(Object targetContext, Object value2, Object valueContext) {
        assert (targetContext != valueContext);
        if (value2 instanceof TruffleObject) {
            assert (value2 instanceof TruffleObject);
            if (HostObject.isInstance(this.language, value2)) {
                return HostObject.withContext(this.language, value2, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (value2 instanceof HostProxy) {
                return HostProxy.withContext(value2, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (valueContext == null) {
                assert (value2 instanceof TruffleObject);
                return value2;
            }
            return null;
        }
        assert (InteropLibrary.isValidValue(value2));
        return value2;
    }

    @Override
    public Error toHostResourceError(Throwable hostException) {
        Throwable t = this.unboxHostException(hostException);
        if (t instanceof StackOverflowError || t instanceof OutOfMemoryError) {
            return (Error)t;
        }
        return null;
    }

    @Override
    public int findNextGuestToHostStackTraceElement(StackTraceElement firstElement, StackTraceElement[] hostStack, int nextElementIndex) {
        StackTraceElement element = firstElement;
        int index = nextElementIndex;
        while (HostLanguageService.isGuestToHostReflectiveCall(element) && index < hostStack.length) {
            element = hostStack[index++];
        }
        if (HostLanguageService.isGuestToHostCallFromHostInterop(element)) {
            return index - nextElementIndex;
        }
        return -1;
    }

    @Override
    public void pin(Object receiver) {
        HostMethodScope.pin(receiver);
    }

    @Override
    public void hostExit(int exitCode) {
        System.exit(exitCode);
    }

    @Override
    public boolean allowsPublicAccess() {
        return this.api.allowsPublicAccess(this.language.hostClassCache.hostAccess);
    }

    private static boolean isGuestToHostCallFromHostInterop(StackTraceElement element) {
        assert (HostLanguageService.assertClassNameUnchanged(HostObject.GuestToHostCalls.class, "org.pkl.thirdparty.truffle.host.HostObject$GuestToHostCalls"));
        assert (HostLanguageService.assertClassNameUnchanged(GuestToHostCodeCache.class, "org.pkl.thirdparty.truffle.host.GuestToHostCodeCache"));
        assert (HostLanguageService.assertClassNameUnchanged(HostMethodDesc.SingleMethod.class, "org.pkl.thirdparty.truffle.host.HostMethodDesc$SingleMethod"));
        switch (element.getClassName()) {
            case "org.pkl.thirdparty.truffle.host.HostMethodDesc$SingleMethod$MHBase": {
                return element.getMethodName().equals("invokeHandle");
            }
            case "org.pkl.thirdparty.truffle.host.HostMethodDesc$SingleMethod$MethodReflectImpl": {
                return element.getMethodName().equals("reflectInvoke");
            }
            case "org.pkl.thirdparty.truffle.host.HostObject$GuestToHostCalls": {
                return true;
            }
        }
        return element.getClassName().startsWith("org.pkl.thirdparty.truffle.host.GuestToHostCodeCache$") && element.getMethodName().equals("executeImpl");
    }

    private static boolean assertClassNameUnchanged(Class<?> c, String name) {
        if (c.getName().equals(name)) {
            return true;
        }
        throw new AssertionError((Object)("Class name is outdated. Expected " + name + " but got " + c.getName()));
    }

    private static boolean isGuestToHostReflectiveCall(StackTraceElement element) {
        switch (element.getClassName()) {
            case "sun.reflect.NativeMethodAccessorImpl": 
            case "sun.reflect.DelegatingMethodAccessorImpl": 
            case "jdk.internal.reflect.NativeMethodAccessorImpl": 
            case "jdk.internal.reflect.DelegatingMethodAccessorImpl": 
            case "java.lang.reflect.Method": {
                return element.getMethodName().startsWith("invoke");
            }
        }
        return false;
    }
}

