/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.pkl.thirdparty.graalvm.polyglot.SandboxPolicy;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleOptions;
import org.pkl.thirdparty.truffle.api.instrumentation.TruffleInstrument;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.ModuleUtils;

final class InstrumentCache {
    private static final String DEBUGGER_CLASS = "org.pkl.thirdparty.truffle.api.debug.impl.DebuggerInstrument";
    private static final String DEBUGGER_PROVIDER = "org.pkl.thirdparty.truffle.api.debug.impl.DebuggerInstrumentProvider";
    private static final List<InstrumentCache> nativeImageCache = TruffleOptions.AOT ? new ArrayList() : null;
    private static Map<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>> runtimeCaches = new HashMap<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>>();
    private final String className;
    private final String id;
    private final String name;
    private final String version;
    private final String website;
    private final boolean internal;
    private final Set<String> services;
    private final TruffleInstrument.Provider provider;
    private final SandboxPolicy sandboxPolicy;

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        nativeImageCache.addAll(InstrumentCache.doLoad(Arrays.asList(new EngineAccessor.StrongClassLoaderSupplier(imageClassLoader))));
    }

    private static Set<String> collectInstruments() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        HashSet<String> res = new HashSet<String>();
        for (InstrumentCache instrumentCache : nativeImageCache) {
            res.add(instrumentCache.id);
        }
        return res;
    }

    private static void resetNativeImageState() {
        nativeImageCache.clear();
        runtimeCaches.clear();
    }

    private InstrumentCache(String id2, String name, String version, String className, boolean internal, Set<String> services, TruffleInstrument.Provider provider, String website, SandboxPolicy sandboxPolicy) {
        this.id = id2;
        this.name = name;
        this.version = version;
        this.website = website;
        this.className = className;
        this.internal = internal;
        this.services = services;
        this.provider = provider;
        this.sandboxPolicy = sandboxPolicy;
    }

    boolean isInternal() {
        return this.internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<InstrumentCache> load() {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Class<InstrumentCache> clazz = InstrumentCache.class;
        synchronized (InstrumentCache.class) {
            List<EngineAccessor.AbstractClassLoaderSupplier> classLoaders = EngineAccessor.locatorOrDefaultLoaders();
            List<InstrumentCache> cache2 = runtimeCaches.get(classLoaders);
            if (cache2 == null) {
                cache2 = InstrumentCache.doLoad(classLoaders);
                runtimeCaches.put(classLoaders, cache2);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache2;
        }
    }

    static List<InstrumentCache> doLoad(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        ArrayList<InstrumentCache> list = new ArrayList<InstrumentCache>();
        HashSet classNamesUsed = new HashSet();
        for (Supplier supplier : suppliers) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null || !InstrumentCache.isValidLoader(loader)) continue;
            if (!TruffleOptions.AOT) {
                ModuleUtils.exportTo(loader, null);
            }
            for (TruffleInstrument.Provider provider : ServiceLoader.load(TruffleInstrument.Provider.class, loader)) {
                InstrumentCache.loadInstrumentImpl(provider, list, classNamesUsed);
            }
            if (classNamesUsed.contains(DEBUGGER_CLASS)) continue;
            try {
                InstrumentCache.loadInstrumentImpl((TruffleInstrument.Provider)loader.loadClass(DEBUGGER_PROVIDER).getConstructor(new Class[0]).newInstance(new Object[0]), list, classNamesUsed);
            }
            catch (Exception e2) {
                throw CompilerDirectives.shouldNotReachHere("Failed to discover debugger instrument.", e2);
            }
        }
        Collections.sort(list, new Comparator<InstrumentCache>(){

            @Override
            public int compare(InstrumentCache o1, InstrumentCache o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return list;
    }

    private static void loadInstrumentImpl(TruffleInstrument.Provider provider, List<? super InstrumentCache> list, Set<? super String> classNamesUsed) {
        TruffleInstrument.Registration reg = provider.getClass().getAnnotation(TruffleInstrument.Registration.class);
        if (reg == null) {
            PrintStream out2 = System.err;
            out2.println("Provider " + provider.getClass() + " is missing @Registration annotation.");
            return;
        }
        String className = provider.getInstrumentClassName();
        String name = reg.name();
        String id2 = reg.id();
        if (id2 == null || id2.isEmpty()) {
            int lastIndex2 = className.lastIndexOf(36);
            if (lastIndex2 == -1) {
                lastIndex2 = className.lastIndexOf(46);
            }
            id2 = className.substring(lastIndex2 + 1);
        }
        String version = reg.version();
        String website = reg.website();
        SandboxPolicy sandboxPolicy = reg.sandbox();
        boolean internal = reg.internal();
        TreeSet<String> servicesClassNames = new TreeSet<String>();
        for (String service : provider.getServicesClassNames()) {
            servicesClassNames.add(service);
        }
        if (!classNamesUsed.contains(className)) {
            classNamesUsed.add(className);
            list.add(new InstrumentCache(id2, name, version, className, internal, servicesClassNames, provider, website, sandboxPolicy));
        }
    }

    private static boolean isValidLoader(ClassLoader loader) {
        try {
            Class<?> truffleInstrumentClassAsSeenByLoader = Class.forName(TruffleInstrument.class.getName(), true, loader);
            return truffleInstrumentClassAsSeenByLoader == TruffleInstrument.class;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getVersion() {
        return this.version;
    }

    TruffleInstrument loadInstrument() {
        return this.provider.create();
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    String[] services() {
        return this.services.toArray(new String[0]);
    }

    String getWebsite() {
        return this.website;
    }

    SandboxPolicy getSandboxPolicy() {
        return this.sandboxPolicy;
    }
}

