/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.pkl.thirdparty.graalvm.polyglot.Engine;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotException;
import org.pkl.thirdparty.graalvm.polyglot.Source;
import org.pkl.thirdparty.graalvm.polyglot.SourceSection;
import org.pkl.thirdparty.graalvm.polyglot.Value;
import org.pkl.thirdparty.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleStackTrace;
import org.pkl.thirdparty.truffle.api.TruffleStackTraceElement;
import org.pkl.thirdparty.truffle.api.exception.AbstractTruffleException;
import org.pkl.thirdparty.truffle.api.interop.ExceptionType;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineException;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineOptions;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExceptionFrame;
import org.pkl.thirdparty.truffle.polyglot.PolyglotImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguage;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;

final class PolyglotExceptionImpl {
    private static final String CAUSE_CAPTION = "Caused by host exception: ";
    private static final boolean TRACE_STACK_TRACE_WALKING = false;
    private Object api;
    final PolyglotImpl polyglot;
    final PolyglotEngineImpl engine;
    final PolyglotContextImpl context;
    final Throwable exception;
    final boolean showInternalStackFrames;
    private final List<TruffleStackTraceElement> guestFrames;
    private StackTraceElement[] javaStackTrace;
    private List<PolyglotException.StackFrame> materializedFrames;
    private final SourceSection sourceLocation;
    private final boolean internal;
    private final boolean cancelled;
    private final boolean exit;
    private final boolean incompleteSource;
    private final boolean syntaxError;
    private final boolean resourceExhausted;
    private final boolean interrupted;
    private final int exitStatus;
    private final Value guestObject;
    private final String message;

    PolyglotExceptionImpl(PolyglotEngineImpl engine, PolyglotContextImpl.State polyglotContextState, boolean polyglotContextResourceExhausted, int exitCode, Throwable original) {
        this(engine.impl, engine, polyglotContextState, polyglotContextResourceExhausted, exitCode, null, original, false, false);
    }

    PolyglotExceptionImpl(PolyglotImpl polyglot, Throwable original) {
        this(polyglot, null, null, false, 0, null, original, true, false);
    }

    PolyglotExceptionImpl(PolyglotImpl polyglot, PolyglotEngineImpl engine, PolyglotContextImpl.State polyglotContextState, boolean polyglotContextResourceExhausted, int exitCode, PolyglotLanguageContext languageContext, Throwable original, boolean allowInterop, boolean entered) {
        InteropLibrary interop;
        this.polyglot = polyglot;
        this.engine = engine;
        this.context = languageContext != null ? languageContext.context : null;
        this.exception = original;
        this.guestFrames = TruffleStackTrace.getStackTrace(original);
        this.showInternalStackFrames = engine == null ? false : engine.engineOptionValues.get(PolyglotEngineOptions.ShowInternalStackFrames);
        Error resourceLimitError = PolyglotExceptionImpl.getResourceLimitError(engine, this.exception);
        String exceptionMessage = null;
        if (allowInterop && (interop = InteropLibrary.getUncached()).isException(this.exception)) {
            try {
                boolean cancelInducedTruffleException;
                ExceptionType exceptionType = interop.getExceptionType(this.exception);
                this.internal = false;
                this.cancelled = cancelInducedTruffleException = polyglotContextState != null && (polyglotContextState.isCancelling() || polyglotContextState == PolyglotContextImpl.State.CLOSED_CANCELLED);
                this.resourceExhausted = resourceLimitError != null || cancelInducedTruffleException && polyglotContextResourceExhausted;
                this.syntaxError = exceptionType == ExceptionType.PARSE_ERROR;
                this.exit = exceptionType == ExceptionType.EXIT;
                this.exitStatus = this.exit ? interop.getExceptionExitStatus(this.exception) : 0;
                this.incompleteSource = this.syntaxError ? interop.isExceptionIncompleteSource(this.exception) : false;
                boolean bl = this.interrupted = exceptionType == ExceptionType.INTERRUPT && !this.cancelled;
                if (interop.hasExceptionMessage(this.exception)) {
                    exceptionMessage = interop.asString(interop.getExceptionMessage(this.exception));
                }
                this.sourceLocation = interop.hasSourceLocation(this.exception) ? this.newSourceSection(interop.getSourceLocation(this.exception)) : null;
                if (entered && languageContext != null && languageContext.isCreated() && !PolyglotExceptionImpl.isHostException(engine, this.exception)) {
                    this.guestObject = languageContext.asValue(this.exception);
                }
                this.guestObject = null;
            }
            catch (UnsupportedMessageException ume) {
                throw CompilerDirectives.shouldNotReachHere(ume);
            }
        } else {
            boolean exitInducedTruffleOrInterruptException;
            boolean interruptException = this.exception instanceof PolyglotEngineImpl.InterruptExecution || this.exception != null && this.exception.getCause() instanceof InterruptedException || PolyglotExceptionImpl.isHostException(engine, this.exception) && this.asHostException() instanceof InterruptedException;
            boolean truffleException = this.exception instanceof AbstractTruffleException;
            boolean cancelInducedTruffleOrInterruptException = !(polyglotContextState == null || !polyglotContextState.isCancelling() && polyglotContextState != PolyglotContextImpl.State.CLOSED_CANCELLED || !interruptException && !truffleException);
            this.cancelled = cancelInducedTruffleOrInterruptException || this.exception instanceof PolyglotEngineImpl.CancelExecution;
            this.resourceExhausted = resourceLimitError != null || cancelInducedTruffleOrInterruptException && polyglotContextResourceExhausted;
            this.interrupted = interruptException && !this.cancelled;
            this.syntaxError = false;
            this.incompleteSource = false;
            org.pkl.thirdparty.truffle.api.source.SourceSection location = null;
            boolean bl = exitInducedTruffleOrInterruptException = !(polyglotContextState == null || !polyglotContextState.isExiting() && polyglotContextState != PolyglotContextImpl.State.CLOSED_EXITED || !interruptException && !truffleException);
            if (exitInducedTruffleOrInterruptException || this.exception instanceof PolyglotContextImpl.ExitException) {
                this.exit = true;
                this.exitStatus = this.exception instanceof PolyglotContextImpl.ExitException ? ((PolyglotContextImpl.ExitException)this.exception).getExitCode() : exitCode;
                this.guestObject = null;
                location = this.exception instanceof PolyglotContextImpl.ExitException ? ((PolyglotContextImpl.ExitException)this.exception).getSourceLocation() : null;
            } else {
                this.exit = false;
                this.exitStatus = 0;
                this.guestObject = null;
            }
            boolean bl2 = this.internal = !this.interrupted && !this.cancelled && !this.resourceExhausted && !this.exit && !truffleException;
            if (this.exception instanceof PolyglotEngineImpl.CancelExecution) {
                location = ((PolyglotEngineImpl.CancelExecution)this.exception).getSourceLocation();
            }
            SourceSection sourceSection = this.sourceLocation = location != null ? this.newSourceSection(location) : null;
        }
        if (exceptionMessage == null) {
            String string = this.isHostException() ? this.asHostException().getMessage() : (exceptionMessage = this.internal ? this.exception.toString() : this.exception.getMessage());
        }
        if (exceptionMessage != null) {
            this.message = exceptionMessage;
        } else if (resourceLimitError != null) {
            Object resourceExhaustedMessage = "Resource exhausted";
            if (resourceLimitError instanceof StackOverflowError) {
                resourceExhaustedMessage = (String)resourceExhaustedMessage + ": Stack overflow";
            }
            if (resourceLimitError instanceof OutOfMemoryError) {
                resourceExhaustedMessage = (String)resourceExhaustedMessage + ": Out of memory";
            }
            this.message = resourceExhaustedMessage;
        } else {
            this.message = null;
        }
    }

    private static Error getResourceLimitError(PolyglotEngineImpl engine, Throwable e2) {
        if (e2 instanceof PolyglotEngineImpl.CancelExecution) {
            return ((PolyglotEngineImpl.CancelExecution)e2).isResourceLimit() ? (Error)e2 : null;
        }
        if (PolyglotExceptionImpl.isHostException(engine, e2)) {
            Error toCheck = engine.host.toHostResourceError(e2);
            assert (toCheck == null || toCheck instanceof StackOverflowError || toCheck instanceof OutOfMemoryError);
            return toCheck;
        }
        if (e2 instanceof StackOverflowError || e2 instanceof OutOfMemoryError) {
            return (Error)e2;
        }
        return null;
    }

    private SourceSection newSourceSection(org.pkl.thirdparty.truffle.api.source.SourceSection section2) {
        org.pkl.thirdparty.truffle.api.source.Source truffleSource = section2.getSource();
        Source source2 = this.polyglot.getAPIAccess().newSource(this.polyglot.getSourceDispatch(), truffleSource);
        return this.polyglot.getAPIAccess().newSourceSection(source2, this.polyglot.getSourceSectionDispatch(), section2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolyglotExceptionImpl) {
            return this.exception == ((PolyglotExceptionImpl)obj).exception;
        }
        return false;
    }

    public int hashCode() {
        return this.exception.hashCode();
    }

    public SourceSection getSourceLocation() {
        return this.sourceLocation;
    }

    public void onCreate(PolyglotException instance) {
        this.api = instance;
    }

    public boolean isResourceExhausted() {
        return this.resourceExhausted;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public boolean isHostException() {
        return PolyglotExceptionImpl.isHostException(this.engine, this.exception);
    }

    public Throwable asHostException() {
        if (!this.isHostException()) {
            throw PolyglotEngineException.unsupported(String.format("Unsupported operation %s.%s. You can ensure that the operation is supported using %s.%s.", PolyglotException.class.getSimpleName(), "asHostException()", PolyglotException.class.getSimpleName(), "isHostException()"));
        }
        return this.engine.host.unboxHostException(this.exception);
    }

    public void printStackTrace(PrintWriter s2) {
        this.printStackTrace(new WrappedPrintWriter(s2));
    }

    public void printStackTrace(PrintStream s2) {
        this.printStackTrace(new WrappedPrintStream(s2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter s2) {
        Object object = s2.lock();
        synchronized (object) {
            if (this.isInternalError() && (this.guestFrames == null || this.guestFrames.isEmpty())) {
                s2.print(this.api.getClass().getName() + ": ");
                s2.printStackTrace(this.exception);
                s2.println("Internal GraalVM error, please report at https://github.com/oracle/graal/issues/.");
                return;
            }
            if (this.isInternalError() || this.getMessage() == null || this.getMessage().isEmpty()) {
                s2.println(this.api);
            } else {
                s2.println(this.getMessage());
            }
            this.materialize();
            int languageIdLength = 0;
            for (PolyglotException.StackFrame traceElement : this.getPolyglotStackTrace()) {
                if (traceElement.isHostFrame()) continue;
                languageIdLength = Math.max(languageIdLength, this.polyglot.getAPIAccess().getDispatch(traceElement).getLanguage().getId().length());
            }
            for (PolyglotException.StackFrame traceElement : this.getPolyglotStackTrace()) {
                s2.println("\tat " + this.polyglot.getAPIAccess().getDispatch(traceElement).toStringImpl(languageIdLength));
            }
            if (this.isHostException()) {
                s2.println(CAUSE_CAPTION + this.asHostException());
            }
            if (this.isInternalError()) {
                s2.println("Original Internal Error: ");
                s2.printStackTrace(this.exception);
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getJavaStackTrace() {
        if (this.javaStackTrace == null) {
            this.materialize();
            this.javaStackTrace = new StackTraceElement[this.materializedFrames.size()];
            for (int i2 = 0; i2 < this.javaStackTrace.length; ++i2) {
                this.javaStackTrace[i2] = this.materializedFrames.get(i2).toHostFrame();
            }
        }
        return this.javaStackTrace;
    }

    private void materialize() {
        if (this.materializedFrames == null) {
            ArrayList<PolyglotException.StackFrame> frames = new ArrayList<PolyglotException.StackFrame>();
            for (PolyglotException.StackFrame frame : this.getPolyglotStackTrace()) {
                frames.add(frame);
            }
            this.materializedFrames = Collections.unmodifiableList(frames);
        }
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getJavaStackTrace().clone();
    }

    public boolean isInternalError() {
        return this.internal;
    }

    public Iterable<PolyglotException.StackFrame> getPolyglotStackTrace() {
        if (this.materializedFrames != null) {
            return this.materializedFrames;
        }
        return new Iterable<PolyglotException.StackFrame>(){

            @Override
            public Iterator<PolyglotException.StackFrame> iterator() {
                return PolyglotExceptionImpl.createStackFrameIterator(PolyglotExceptionImpl.this);
            }
        };
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isExit() {
        return this.exit;
    }

    public boolean isIncompleteSource() {
        return this.incompleteSource;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public boolean isSyntaxError() {
        return this.syntaxError;
    }

    public Value getGuestObject() {
        return this.guestObject;
    }

    static String printStackToString(PolyglotLanguageContext context2, Node node) {
        StackTraceException stack = new StackTraceException(node);
        TruffleStackTrace.fillIn(stack);
        PolyglotException e2 = PolyglotImpl.guestToHostException(context2, stack, true);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        e2.printStackTrace(new PrintStream(out2));
        return new String(out2.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getFileSystemContext(PolyglotLanguage language) {
        if (this.context == null) {
            return null;
        }
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            PolyglotLanguageContext languageContext = this.context.getContext(language);
            if (!languageContext.isCreated()) {
                return null;
            }
            return languageContext.getInternalFileSystemContext();
        }
    }

    static Iterator<PolyglotException.StackFrame> createStackFrameIterator(final PolyglotExceptionImpl impl) {
        final AbstractPolyglotImpl.APIAccess apiAccess = impl.polyglot.getAPIAccess();
        StackTraceElement[] hostStack = null;
        if (PolyglotExceptionImpl.isHostException(impl.engine, impl.exception)) {
            Throwable original = impl.engine.host.unboxHostException(impl.exception);
            hostStack = original.getStackTrace();
        } else if (EngineAccessor.EXCEPTION.isException(impl.exception)) {
            Throwable lazyStack = EngineAccessor.EXCEPTION.getLazyStackTrace(impl.exception);
            if (lazyStack != null) {
                hostStack = EngineAccessor.LANGUAGE.getInternalStackTraceElements(lazyStack);
            }
        } else {
            hostStack = impl.exception.getStackTrace();
        }
        if (hostStack == null) {
            hostStack = new StackTraceElement[]{};
        }
        Iterator guestFrames = impl.guestFrames == null ? Collections.emptyIterator() : impl.guestFrames.iterator();
        boolean inHostLanguage = impl.isHostException() || impl.isInternalError();
        return new MergedHostGuestIterator<PolyglotException.StackFrame, TruffleStackTraceElement>(impl.engine, hostStack, guestFrames, inHostLanguage, true, new Function<StackTraceElement, PolyglotException.StackFrame>(){

            @Override
            public PolyglotException.StackFrame apply(StackTraceElement element) {
                return apiAccess.newPolyglotStackTraceElement(PolyglotExceptionFrame.createHost(impl, element), impl.api);
            }
        }, new Function<TruffleStackTraceElement, PolyglotException.StackFrame>(){
            private boolean firstGuestFrame = true;

            @Override
            public PolyglotException.StackFrame apply(TruffleStackTraceElement guestFrame) {
                boolean first2 = this.firstGuestFrame;
                this.firstGuestFrame = false;
                PolyglotExceptionFrame guest = PolyglotExceptionFrame.createGuest(impl, guestFrame, first2);
                if (guest != null) {
                    return apiAccess.newPolyglotStackTraceElement(guest, impl.api);
                }
                return null;
            }
        });
    }

    private static boolean isHostException(PolyglotEngineImpl engine, Throwable cause) {
        return engine != null && engine.host != null && engine.host.isHostException(cause);
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return this.printWriter;
        }

        @Override
        void print(Object o) {
            this.printWriter.print(o);
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }

        @Override
        void printStackTrace(Throwable t) {
            t.printStackTrace(this.printWriter);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        abstract Object lock();

        abstract void print(Object var1);

        abstract void println(Object var1);

        abstract void printStackTrace(Throwable var1);
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return this.printStream;
        }

        @Override
        void print(Object o) {
            this.printStream.print(o);
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }

        @Override
        void printStackTrace(Throwable t) {
            t.printStackTrace(this.printStream);
        }
    }

    static class StackTraceException
    extends AbstractTruffleException {
        StackTraceException(Node location) {
            super(location);
        }
    }

    static class MergedHostGuestIterator<T, G>
    implements Iterator<T> {
        private static final String POLYGLOT_PACKAGE = Engine.class.getName().substring(0, Engine.class.getName().lastIndexOf(46) + 1);
        private static final String HOST_INTEROP_PACKAGE = "org.pkl.thirdparty.truffle.polyglot.";
        private static final String[] JAVA_INTEROP_HOST_TO_GUEST = new String[]{"org.pkl.thirdparty.truffle.polyglot.PolyglotMap", "org.pkl.thirdparty.truffle.polyglot.PolyglotList", "org.pkl.thirdparty.truffle.polyglot.PolyglotFunction", "org.pkl.thirdparty.truffle.polyglot.PolyglotMapAndFunction", "org.pkl.thirdparty.truffle.polyglot.PolyglotFunctionProxyHandler", "org.pkl.thirdparty.truffle.polyglot.PolyglotObjectProxyHandler"};
        private final PolyglotEngineImpl engine;
        private final Iterator<G> guestFrames;
        private final StackTraceElement[] hostStack;
        private final ListIterator<StackTraceElement> hostFrames;
        private final Function<StackTraceElement, T> hostFrameConvertor;
        private final Function<G, T> guestFrameConvertor;
        private final boolean includeHostFrames;
        private boolean inHostLanguage;
        private T fetchedNext;

        MergedHostGuestIterator(PolyglotEngineImpl engine, StackTraceElement[] hostStack, Iterator<G> guestFrames, boolean inHostLanguage, boolean includeHostFrames, Function<StackTraceElement, T> hostFrameConvertor, Function<G, T> guestFrameConvertor) {
            this.engine = engine;
            this.hostStack = hostStack;
            this.includeHostFrames = includeHostFrames;
            this.hostFrames = Arrays.asList(hostStack).listIterator();
            this.guestFrames = guestFrames;
            this.inHostLanguage = inHostLanguage;
            this.hostFrameConvertor = hostFrameConvertor;
            this.guestFrameConvertor = guestFrameConvertor;
        }

        @Override
        public boolean hasNext() {
            return this.fetchNext() != null;
        }

        @Override
        public T next() {
            T next = this.fetchNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.fetchedNext = null;
            return next;
        }

        T fetchNext() {
            if (this.fetchedNext != null) {
                return this.fetchedNext;
            }
            while (this.hostFrames.hasNext()) {
                T frame;
                StackTraceElement element = this.hostFrames.next();
                this.traceStackTraceElement(element);
                if (this.inHostLanguage) {
                    int guestToHost = MergedHostGuestIterator.findGuestToHostFrame(this.engine, element, this.hostStack, this.hostFrames.nextIndex());
                    if (guestToHost >= 0) {
                        assert (!MergedHostGuestIterator.isHostToGuest(element));
                        this.inHostLanguage = false;
                        for (int i2 = 0; i2 < guestToHost; ++i2) {
                            element = this.hostFrames.next();
                            this.traceStackTraceElement(element);
                        }
                    }
                } else if (MergedHostGuestIterator.isHostToGuest(element)) {
                    this.inHostLanguage = true;
                    while (this.hostFrames.hasNext()) {
                        StackTraceElement next = this.hostFrames.next();
                        this.traceStackTraceElement(next);
                        if (MergedHostGuestIterator.isHostToGuest(next)) {
                            element = next;
                            continue;
                        }
                        this.hostFrames.previous();
                        break;
                    }
                }
                if (MergedHostGuestIterator.isGuestCall(element)) {
                    G guestFrame;
                    T frame2;
                    this.inHostLanguage = false;
                    if (!this.guestFrames.hasNext() || (frame2 = this.guestFrameConvertor.apply(guestFrame = this.guestFrames.next())) == null) continue;
                    this.fetchedNext = frame2;
                    return this.fetchedNext;
                }
                if (!this.inHostLanguage || !this.includeHostFrames || (frame = this.hostFrameConvertor.apply(element)) == null) continue;
                this.fetchedNext = frame;
                return this.fetchedNext;
            }
            while (this.guestFrames.hasNext()) {
                G guestFrame = this.guestFrames.next();
                T frame = this.guestFrameConvertor.apply(guestFrame);
                if (frame == null) continue;
                this.fetchedNext = frame;
                return this.fetchedNext;
            }
            return null;
        }

        static boolean isLazyStackTraceElement(StackTraceElement element) {
            return element == null;
        }

        static boolean isGuestCall(StackTraceElement element) {
            return MergedHostGuestIterator.isLazyStackTraceElement(element) || EngineAccessor.RUNTIME.isGuestCallStackFrame(element);
        }

        static boolean isHostToGuest(StackTraceElement element) {
            if (MergedHostGuestIterator.isLazyStackTraceElement(element)) {
                return false;
            }
            if (element.getClassName().startsWith(POLYGLOT_PACKAGE) && element.getClassName().indexOf(46, POLYGLOT_PACKAGE.length()) < 0) {
                return true;
            }
            if (element.getClassName().startsWith(HOST_INTEROP_PACKAGE)) {
                for (String hostToGuestClassName : JAVA_INTEROP_HOST_TO_GUEST) {
                    if (!element.getClassName().equals(hostToGuestClassName)) continue;
                    return true;
                }
            }
            return false;
        }

        static int findGuestToHostFrame(PolyglotEngineImpl engine, StackTraceElement firstElement, StackTraceElement[] hostStack, int nextElementIndex) {
            if (MergedHostGuestIterator.isLazyStackTraceElement(firstElement)) {
                return -1;
            }
            if (engine == null || engine.host == null) {
                return -1;
            }
            return engine.host.findNextGuestToHostStackTraceElement(firstElement, hostStack, nextElementIndex);
        }

        private void traceStackTraceElement(StackTraceElement element) {
        }
    }
}

