/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.GenerateInline;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.interop.ArityException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.CachedLibrary;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedBranchProfile;
import org.pkl.thirdparty.truffle.api.profiles.InlinedConditionProfile;
import org.pkl.thirdparty.truffle.polyglot.PolyglotInteropErrors;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotToHostNode;

@GenerateInline(value=false)
abstract class PolyglotExecuteNode
extends Node {
    private static final Object[] EMPTY = new Object[0];

    PolyglotExecuteNode() {
    }

    public final Object execute(PolyglotLanguageContext languageContext, Object function, Object functionArgsObject) {
        return this.execute(languageContext, function, functionArgsObject, Object.class, (Type)((Object)Object.class), Object.class, null);
    }

    public final Object execute(PolyglotLanguageContext languageContext, Object function, Object functionArgsObject, Class<?> resultClass, Type resultType, Class<?> paramClass, Type paramType) {
        Object[] argsArray = paramType != null && paramClass.isArray() ? (functionArgsObject == null ? EMPTY : (paramClass.getComponentType().isPrimitive() && !(functionArgsObject instanceof Object[]) ? PolyglotExecuteNode.copyToObjectArray(paramClass.cast(functionArgsObject)) : (Object[])functionArgsObject)) : (paramType == null && functionArgsObject == null ? EMPTY : (paramType == null && functionArgsObject instanceof Object[] ? (Object[])functionArgsObject : new Object[]{functionArgsObject}));
        return this.executeImpl(languageContext, function, argsArray, resultClass, resultType);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] copyToObjectArray(Object functionArgs) {
        assert (functionArgs.getClass().isArray());
        int length2 = Array.getLength(functionArgs);
        Object[] copy2 = new Object[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            copy2[i2] = Array.get(functionArgs, 0);
        }
        return copy2;
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3, Class<?> var4, Type var5);

    @Specialization(limit="5")
    static Object doCached(PolyglotLanguageContext languageContext, Object function, Object[] argsArray, Class<?> resultClass, Type resultType, @Bind(value="this") Node node, @CachedLibrary(value="function") InteropLibrary interop, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuests, @Cached PolyglotToHostNode toHost, @Cached InlinedConditionProfile executableCondition, @Cached InlinedConditionProfile instantiableCondition, @Cached InlinedBranchProfile unsupportedError, @Cached InlinedBranchProfile arityError, @Cached InlinedBranchProfile unsupportedArgumentError) {
        Object result2;
        block8: {
            Object[] functionArgs = toGuests.execute(node, languageContext, argsArray);
            boolean executable = executableCondition.profile(node, interop.isExecutable(function));
            try {
                if (executable) {
                    result2 = interop.execute(function, functionArgs);
                    break block8;
                }
                if (instantiableCondition.profile(node, interop.isInstantiable(function))) {
                    result2 = interop.instantiate(function, functionArgs);
                    break block8;
                }
                throw PolyglotInteropErrors.executeUnsupported(languageContext, function);
            }
            catch (UnsupportedTypeException e2) {
                unsupportedArgumentError.enter(node);
                if (executable) {
                    throw PolyglotInteropErrors.invalidExecuteArgumentType(languageContext, function, functionArgs);
                }
                throw PolyglotInteropErrors.invalidInstantiateArgumentType(languageContext, function, functionArgs);
            }
            catch (ArityException e3) {
                arityError.enter(node);
                if (executable) {
                    throw PolyglotInteropErrors.invalidExecuteArity(languageContext, function, functionArgs, e3.getExpectedMinArity(), e3.getExpectedMaxArity(), e3.getActualArity());
                }
                throw PolyglotInteropErrors.invalidInstantiateArity(languageContext, function, functionArgs, e3.getExpectedMinArity(), e3.getExpectedMaxArity(), e3.getActualArity());
            }
            catch (UnsupportedMessageException e4) {
                unsupportedError.enter(node);
                throw PolyglotInteropErrors.executeUnsupported(languageContext, function);
            }
        }
        return toHost.execute(node, languageContext, result2, resultClass, resultType);
    }
}

