/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.pkl.thirdparty.graalvm.collections.Pair;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguage;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLocals;
import org.pkl.thirdparty.truffle.polyglot.PolyglotSharingLayer;
import org.pkl.thirdparty.truffle.polyglot.PolyglotValueDispatch;
import org.pkl.thirdparty.truffle.polyglot.WeakAssumedValue;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    @CompilerDirectives.CompilationFinal
    PolyglotSharingLayer sharing;
    private final Map<Class<?>, PolyglotValueDispatch> valueCache;
    private final Map<Class<?>, CallTarget> callTargetCache;
    final Map<Object, Object> hostToGuestCodeCache = new ConcurrentHashMap<Object, Object>();
    final Map<Class<?>, Object> staticObjectClassLoaders = new ConcurrentHashMap();
    final ConcurrentHashMap<Pair<Class<?>, Class<?>>, Object> generatorCache = new ConcurrentHashMap();
    final WeakAssumedValue<PolyglotLanguageContext> singleLanguageContext = new WeakAssumedValue("single language context");
    List<PolyglotLocals.LanguageContextLocal<?>> contextLocals;
    List<PolyglotLocals.LanguageContextThreadLocal<?>> contextThreadLocals;
    PolyglotLocals.LocalLocation[] contextLocalLocations;
    PolyglotLocals.LocalLocation[] contextThreadLocalLocations;
    @CompilerDirectives.CompilationFinal
    private volatile Object guestToHostCodeCache;
    private static final AtomicReferenceFieldUpdater<PolyglotLanguageInstance, Object> GUEST_TO_HOST_CODE_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PolyglotLanguageInstance.class, Object.class, "guestToHostCodeCache");

    PolyglotLanguageInstance(PolyglotLanguage language, PolyglotSharingLayer layer) {
        this.language = language;
        this.sharing = layer;
        this.valueCache = new ConcurrentHashMap();
        this.callTargetCache = new ConcurrentHashMap();
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, language.isHost() ? null : this);
        }
        catch (Exception e2) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e2);
        }
        PolyglotValueDispatch.createDefaultValues(this.getImpl(), this, this.valueCache);
    }

    CallTarget lookupCallTarget(Class<? extends RootNode> rootNodeClass) {
        return this.callTargetCache.get(rootNodeClass);
    }

    CallTarget installCallTarget(RootNode rootNode) {
        return this.callTargetCache.computeIfAbsent(rootNode.getClass(), r -> rootNode.getCallTarget());
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotValueDispatch lookupValueCache(PolyglotContextImpl context2, Object guestValue) {
        PolyglotValueDispatch cache2 = this.valueCache.get(guestValue.getClass());
        if (cache2 == null) {
            Object prev = this.language.engine.enterIfNeeded(context2, true);
            try {
                cache2 = this.lookupValueCacheImpl(guestValue);
            }
            finally {
                this.language.engine.leaveIfNeeded(prev, context2);
            }
        }
        assert (Objects.equals(cache2.languageInstance.sharing, this.sharing)) : PolyglotSharingLayer.invalidSharingError(null, cache2.languageInstance.sharing, this.sharing);
        return cache2;
    }

    private synchronized PolyglotValueDispatch lookupValueCacheImpl(final Object guestValue) {
        PolyglotValueDispatch cache2 = this.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValueDispatch>(){

            @Override
            public PolyglotValueDispatch apply(Class<?> t) {
                return PolyglotValueDispatch.createInteropValue(PolyglotLanguageInstance.this, (TruffleObject)guestValue, guestValue.getClass());
            }
        });
        return cache2;
    }

    Object getGuestToHostCodeCache() {
        return this.guestToHostCodeCache;
    }

    Object installGuestToHostCodeCache(Object newCache) {
        if (GUEST_TO_HOST_CODE_CACHE_UPDATER.compareAndSet(this, null, newCache)) {
            return newCache;
        }
        return this.guestToHostCodeCache;
    }

    public String toString() {
        return "PolyglotLanguageInstance[" + this.spi + "]";
    }
}

