/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.InvalidArrayIndexException;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.library.CachedLibrary;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedBranchProfile;
import org.pkl.thirdparty.truffle.polyglot.HostToGuestRootNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExecuteNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExecuteNodeGen;
import org.pkl.thirdparty.truffle.polyglot.PolyglotInteropErrors;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageInstance;
import org.pkl.thirdparty.truffle.polyglot.PolyglotMapEntryAndFunction;
import org.pkl.thirdparty.truffle.polyglot.PolyglotMapEntryFactory;
import org.pkl.thirdparty.truffle.polyglot.PolyglotToHostNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotWrapper;

class PolyglotMapEntry<K, V>
implements Map.Entry<K, V>,
PolyglotWrapper {
    final PolyglotLanguageContext languageContext;
    final Object guestObject;
    final Cache cache;

    PolyglotMapEntry(PolyglotLanguageContext languageContext, Object obj, Class<K> keyClass, Type keyType, Class<V> valueClass, Type valueType) {
        this.languageContext = languageContext;
        this.guestObject = obj;
        this.cache = Cache.lookup(languageContext, obj.getClass(), keyClass, keyType, valueClass, valueType);
    }

    static <K, V> PolyglotMapEntry<K, V> create(PolyglotLanguageContext languageContext, Object foreignObject, boolean implementsFunction, Class<K> keyClass, Type keyType, Class<V> valueClass, Type valueType) {
        if (implementsFunction) {
            return new PolyglotMapEntryAndFunction<K, V>(languageContext, foreignObject, keyClass, keyType, valueClass, valueType);
        }
        return new PolyglotMapEntry<K, V>(languageContext, foreignObject, keyClass, keyType, valueClass, valueType);
    }

    @Override
    public final K getKey() {
        return (K)this.cache.getKey.call(this.languageContext, this.guestObject);
    }

    @Override
    public final V getValue() {
        return (V)this.cache.getValue.call(this.languageContext, this.guestObject);
    }

    @Override
    public final V setValue(V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object getGuestObject() {
        return this.guestObject;
    }

    @Override
    public final PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public final PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public final boolean equals(Object o) {
        if (o instanceof PolyglotMapEntry) {
            return PolyglotWrapper.equals(this.languageContext, this.guestObject, ((PolyglotMapEntry)o).guestObject);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return PolyglotWrapper.hashCode(this.languageContext, this.guestObject);
    }

    public final String toString() {
        return PolyglotWrapper.toString(this);
    }

    static final class Cache {
        final PolyglotLanguageInstance languageInstance;
        final Class<?> receiverClass;
        final Class<?> keyClass;
        final Type keyType;
        final Class<?> valueClass;
        final Type valueType;
        final CallTarget getKey;
        final CallTarget getValue;
        final CallTarget apply;

        Cache(PolyglotLanguageInstance languageInstance, Class<?> receiverClass, Class<?> keyClass, Type keyType, Class<?> valueClass, Type valueType) {
            this.languageInstance = languageInstance;
            this.receiverClass = receiverClass;
            this.keyClass = keyClass;
            this.keyType = keyType;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.getKey = PolyglotMapEntryFactory.CacheFactory.GetNodeGen.create(this, "getKey", 0L, keyClass, keyType).getCallTarget();
            this.getValue = PolyglotMapEntryFactory.CacheFactory.GetNodeGen.create(this, "getValue", 1L, valueClass, valueType).getCallTarget();
            this.apply = new Apply(this).getCallTarget();
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> keyClass, Type keyType, Class<?> valueClass, Type valueType) {
            Key cacheKey = new Key(receiverClass, keyClass, keyType, valueClass, valueType);
            Cache cache2 = HostToGuestRootNode.lookupHostCodeCache(languageContext, cacheKey, Cache.class);
            if (cache2 == null) {
                cache2 = HostToGuestRootNode.installHostCodeCache(languageContext, cacheKey, new Cache(languageContext.getLanguageInstance(), receiverClass, keyClass, keyType, valueClass, valueType), Cache.class);
            }
            assert (cache2.receiverClass == receiverClass);
            assert (cache2.keyClass == keyClass);
            assert (cache2.keyType == keyType);
            assert (cache2.valueClass == valueClass);
            assert (cache2.valueType == valueType);
            return cache2;
        }

        static abstract class GetNode
        extends PolyglotMapEntryNode {
            private final String name;
            private final long index;
            private final Class<?> elementClass;
            private final Type elementType;

            GetNode(Cache cache2, String name, long index, Class<?> elementClass, Type elementType) {
                super(cache2);
                this.name = name;
                this.index = index;
                this.elementClass = elementClass;
                this.elementType = elementType;
            }

            @Override
            protected String getOperationName() {
                return this.name;
            }

            @Specialization(limit="LIMIT")
            protected Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached PolyglotToHostNode toHost, @Cached InlinedBranchProfile error) {
                if (interop.hasArrayElements(receiver)) {
                    Object result2;
                    try {
                        result2 = interop.readArrayElement(receiver, this.index);
                    }
                    catch (UnsupportedMessageException e2) {
                        error.enter(node);
                        throw this.unsupported(languageContext, receiver);
                    }
                    catch (InvalidArrayIndexException e3) {
                        error.enter(node);
                        throw this.invalidArrayIndex(languageContext, receiver, e3.getInvalidIndex());
                    }
                    return toHost.execute(node, languageContext, result2, this.elementClass, this.elementType);
                }
                error.enter(node);
                throw this.unsupported(languageContext, receiver);
            }
        }

        private static class Apply
        extends PolyglotMapEntryNode {
            @Node.Child
            private PolyglotExecuteNode apply = PolyglotExecuteNodeGen.create();

            Apply(Cache cache2) {
                super(cache2);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, Object receiver, Object[] args2) {
                return this.apply.execute(languageContext, receiver, args2[2]);
            }
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> keyClass;
            final Type keyType;
            final Class<?> valueClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> keyClass, Type keyType, Class<?> valueClass, Type valueType) {
                this.receiverClass = Objects.requireNonNull(receiverClass);
                this.keyClass = Objects.requireNonNull(keyClass);
                this.keyType = keyType;
                this.valueClass = Objects.requireNonNull(valueClass);
                this.valueType = valueType;
            }

            public int hashCode() {
                int hashCode2 = 17;
                hashCode2 = hashCode2 * 31 + this.receiverClass.hashCode();
                hashCode2 = hashCode2 * 31 + this.keyClass.hashCode();
                hashCode2 = hashCode2 * 31 + (this.keyType != null ? this.keyType.hashCode() : 0);
                hashCode2 = hashCode2 * 31 + this.valueClass.hashCode();
                hashCode2 = hashCode2 * 31 + (this.valueType != null ? this.valueType.hashCode() : 0);
                return hashCode2;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.receiverClass == other.receiverClass && this.keyClass == other.keyClass && Objects.equals(this.keyType, other.keyType) && this.valueClass == other.valueClass && Objects.equals(this.valueType, other.valueType);
            }
        }

        static abstract class PolyglotMapEntryNode
        extends HostToGuestRootNode {
            static final int LIMIT = 5;
            final Cache cache;

            PolyglotMapEntryNode(Cache cache2) {
                super(cache2.languageInstance);
                this.cache = cache2;
            }

            protected abstract String getOperationName();

            protected final Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotMapEntry<" + this.cache.receiverClass + ", " + this.getKeyType() + ", " + this.getValueType() + ">." + this.getOperationName();
            }

            protected final RuntimeException unsupported(PolyglotLanguageContext languageContext, Object receiver) {
                throw PolyglotInteropErrors.mapEntryUnsupported(languageContext, receiver, this.getKeyType(), this.getValueType(), this.getOperationName());
            }

            protected final RuntimeException invalidArrayIndex(PolyglotLanguageContext languageContext, Object receiver, long index) {
                throw PolyglotInteropErrors.invalidMapEntryArrayIndex(languageContext, receiver, this.getKeyType(), this.getValueType(), index);
            }

            protected final Type getKeyType() {
                return this.cache.keyType != null ? this.cache.keyType : this.cache.keyClass;
            }

            protected final Type getValueType() {
                return this.cache.valueType != null ? this.cache.valueType : this.cache.valueClass;
            }
        }
    }
}

