/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Objects;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerAsserts;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.NeverDefault;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.interop.ArityException;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.interop.UnknownIdentifierException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedTypeException;
import org.pkl.thirdparty.truffle.api.library.CachedLibrary;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedBranchProfile;
import org.pkl.thirdparty.truffle.api.profiles.InlinedConditionProfile;
import org.pkl.thirdparty.truffle.polyglot.HostToGuestRootNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotFunctionProxyHandler;
import org.pkl.thirdparty.truffle.polyglot.PolyglotInteropErrors;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageInstance;
import org.pkl.thirdparty.truffle.polyglot.PolyglotObjectProxyHandlerFactory;
import org.pkl.thirdparty.truffle.polyglot.PolyglotToHostNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotWrapper;

final class PolyglotObjectProxyHandler
implements InvocationHandler,
PolyglotWrapper {
    static final Object[] EMPTY = new Object[0];
    final Object obj;
    final PolyglotLanguageContext languageContext;
    final CallTarget invoke;

    PolyglotObjectProxyHandler(Object obj, PolyglotLanguageContext languageContext, Class<?> interfaceClass) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.invoke = ObjectProxyNode.lookup(languageContext, obj.getClass(), interfaceClass);
    }

    @Override
    public Object getGuestObject() {
        return this.obj;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments2) throws Throwable {
        CompilerAsserts.neverPartOfCompilation();
        Object[] resolvedArguments = arguments2 == null ? EMPTY : arguments2;
        try {
            return this.invoke.call(this.languageContext, this.obj, method, resolvedArguments);
        }
        catch (UnsupportedOperationException e2) {
            try {
                return PolyglotFunctionProxyHandler.invokeDefault(this, proxy, method, resolvedArguments);
            }
            catch (Exception innerE) {
                e2.addSuppressed(innerE);
                throw e2;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Object newProxyInstance(Class<?> clazz, Object obj, PolyglotLanguageContext languageContext) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new PolyglotObjectProxyHandler(obj, languageContext, clazz));
    }

    static abstract class ObjectProxyNode
    extends HostToGuestRootNode {
        final Class<?> receiverClass;
        final Class<?> interfaceType;

        ObjectProxyNode(PolyglotLanguageInstance languageInstance, Class<?> receiverType, Class<?> interfaceType) {
            super(languageInstance);
            this.receiverClass = receiverType;
            this.interfaceType = interfaceType;
        }

        protected Class<? extends TruffleObject> getReceiverType() {
            return this.receiverClass;
        }

        @Override
        public String getName() {
            return "InterfaceProxy<" + this.receiverClass + ">";
        }

        @Specialization
        static Object doDefault(PolyglotLanguageContext languageContext, Object receiver, Object[] args2, @Bind(value="this") Node node, @Cached ProxyInvokeNode proxyInvoke, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuests) {
            Method method = (Method)args2[2];
            Object[] arguments2 = toGuests.execute(node, languageContext, (Object[])args2[3]);
            return proxyInvoke.execute(languageContext, receiver, method, arguments2);
        }

        public int hashCode() {
            int result2 = 1;
            result2 = 31 * result2 + Objects.hashCode(this.receiverClass);
            result2 = 31 * result2 + Objects.hashCode(this.interfaceType);
            return result2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectProxyNode)) {
                return false;
            }
            ObjectProxyNode other = (ObjectProxyNode)obj;
            return this.receiverClass == other.receiverClass && this.interfaceType == other.interfaceType;
        }

        static CallTarget lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> interfaceClass) {
            ObjectProxyNode node = PolyglotObjectProxyHandlerFactory.ObjectProxyNodeGen.create(languageContext.getLanguageInstance(), receiverClass, interfaceClass);
            CallTarget target = ObjectProxyNode.lookupHostCodeCache(languageContext, node, CallTarget.class);
            if (target == null) {
                target = ObjectProxyNode.installHostCodeCache(languageContext, node, node.getCallTarget(), CallTarget.class);
            }
            return target;
        }
    }

    static abstract class ProxyInvokeNode
    extends Node {
        protected static final int LIMIT = Integer.MAX_VALUE;
        @CompilerDirectives.CompilationFinal
        private boolean invokeFailed;

        ProxyInvokeNode() {
        }

        public abstract Object execute(PolyglotLanguageContext var1, Object var2, Method var3, Object[] var4);

        @Specialization(guards={"cachedMethod == method"}, limit="LIMIT")
        protected Object doCachedMethod(PolyglotLanguageContext languageContext, Object receiver, Method method, Object[] arguments2, @Bind(value="this") Node node, @Cached(value="method") Method cachedMethod, @Cached(value="method.getName()") String name, @Cached(value="getMethodReturnType(method)") Class<?> returnClass, @Cached(value="getMethodGenericReturnType(method)") Type returnType, @CachedLibrary(value="receiver") InteropLibrary receivers, @CachedLibrary(limit="LIMIT") InteropLibrary members2, @Cached InlinedConditionProfile branchProfile, @Cached PolyglotToHostNode toHost, @Cached InlinedBranchProfile error) {
            Object result2 = this.invokeOrExecute(node, languageContext, receiver, arguments2, name, receivers, members2, branchProfile, error);
            return toHost.execute(node, languageContext, result2, returnClass, returnType);
        }

        @NeverDefault
        static Class<?> getMethodReturnType(Method method) {
            if (method == null || method.getReturnType() == Void.TYPE) {
                return Object.class;
            }
            return method.getReturnType();
        }

        @NeverDefault
        static Type getMethodGenericReturnType(Method method) {
            if (method == null || method.getReturnType() == Void.TYPE) {
                return Object.class;
            }
            return method.getGenericReturnType();
        }

        private Object invokeOrExecute(Node node, PolyglotLanguageContext polyglotContext, Object receiver, Object[] arguments2, String member, InteropLibrary receivers, InteropLibrary members2, InlinedConditionProfile invokeProfile, InlinedBranchProfile error) {
            try {
                boolean localInvokeFailed = this.invokeFailed;
                if (!localInvokeFailed) {
                    try {
                        return receivers.invokeMember(receiver, member, arguments2);
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException e2) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        localInvokeFailed = true;
                        this.invokeFailed = true;
                    }
                }
                if (localInvokeFailed) {
                    if (invokeProfile.profile(node, receivers.isMemberInvocable(receiver, member))) {
                        return receivers.invokeMember(receiver, member, arguments2);
                    }
                    if (receivers.isMemberReadable(receiver, member)) {
                        Object readMember = receivers.readMember(receiver, member);
                        if (members2.isExecutable(readMember)) {
                            return members2.execute(readMember, arguments2);
                        }
                        if (arguments2.length == 0) {
                            return readMember;
                        }
                    }
                }
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
            catch (UnknownIdentifierException e3) {
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
            catch (UnsupportedTypeException e4) {
                error.enter(node);
                throw PolyglotInteropErrors.invalidExecuteArgumentType(polyglotContext, receiver, e4.getSuppliedValues());
            }
            catch (ArityException e5) {
                error.enter(node);
                throw PolyglotInteropErrors.invalidExecuteArity(polyglotContext, receiver, arguments2, e5.getExpectedMinArity(), e5.getExpectedMaxArity(), e5.getActualArity());
            }
            catch (UnsupportedMessageException e6) {
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
        }
    }
}

