/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pkl.thirdparty.graalvm.polyglot.Source;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineException;
import org.pkl.thirdparty.truffle.polyglot.PolyglotImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;

final class PolyglotSourceCache {
    private final Cache strongCache;
    private final Cache weakCache = new WeakCache();

    PolyglotSourceCache() {
        this.strongCache = new StrongCache();
    }

    CallTarget parseCached(PolyglotLanguageContext context2, org.pkl.thirdparty.truffle.api.source.Source source2, String[] argumentNames) {
        CallTarget target;
        if (source2.isCached()) {
            Cache strong2 = this.strongCache;
            boolean useStrong = context2.getEngine().storeEngine;
            if ((useStrong || !strong2.isEmpty()) && (target = strong2.lookup(context2, source2, argumentNames, useStrong)) != null) {
                return target;
            }
            target = this.weakCache.lookup(context2, source2, argumentNames, true);
        } else {
            target = PolyglotSourceCache.parseImpl(context2, argumentNames, source2);
        }
        return target;
    }

    void listCachedSources(PolyglotImpl polyglot, Collection<Source> source2) {
        this.strongCache.listSources(polyglot, source2);
        this.weakCache.listSources(polyglot, source2);
    }

    private static CallTarget parseImpl(PolyglotLanguageContext context2, String[] argumentNames, org.pkl.thirdparty.truffle.api.source.Source source2) {
        PolyglotSourceCache.validateSource(context2, source2);
        CallTarget parsedTarget = EngineAccessor.LANGUAGE.parse(context2.requireEnv(), source2, null, argumentNames);
        if (parsedTarget == null) {
            throw new IllegalStateException(String.format("Parsing resulted in a null CallTarget for %s.", source2));
        }
        return parsedTarget;
    }

    private static void validateSource(PolyglotLanguageContext context2, org.pkl.thirdparty.truffle.api.source.Source source2) {
        boolean expectCharacters;
        if (!source2.hasBytes() && !source2.hasCharacters()) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The source does not specify characters nor bytes.", new Object[0]));
        }
        String mimeType = source2.getMimeType();
        Set<String> mimeTypes = context2.language.cache.getMimeTypes();
        if (mimeType != null && !mimeTypes.contains(mimeType)) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s does not support MIME type %s. Supported MIME types are %s.", source2.getLanguage(), mimeType, mimeTypes));
        }
        String activeMimeType = mimeType;
        if (activeMimeType == null) {
            activeMimeType = context2.language.cache.getDefaultMimeType();
        }
        boolean bl = expectCharacters = activeMimeType != null ? context2.language.cache.isCharacterMimeType(activeMimeType) : true;
        if (mimeType != null && source2.hasCharacters() != expectCharacters) {
            if (source2.hasBytes()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is character based for language '%s' but the source contents are byte based.", mimeType, source2.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is byte based for language '%s' but the source contents are character based.", mimeType, source2.getLanguage()));
        }
        if (source2.hasCharacters() != expectCharacters) {
            HashSet<String> binaryMimeTypes = new HashSet<String>();
            HashSet<String> characterMimeTypes = new HashSet<String>();
            for (String supportedMimeType : mimeTypes) {
                if (context2.language.cache.isCharacterMimeType(supportedMimeType)) {
                    characterMimeTypes.add(supportedMimeType);
                    continue;
                }
                binaryMimeTypes.add(supportedMimeType);
            }
            if (expectCharacters) {
                if (binaryMimeTypes.isEmpty()) {
                    throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports character based sources but a binary based source was provided.", source2.getLanguage()));
                }
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a binary based source instead or specify a MIME type for the source. Available MIME types for binary based sources are %s.", source2.getLanguage(), binaryMimeTypes));
            }
            if (characterMimeTypes.isEmpty()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports binary based sources but a character based source was provided.", source2.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a character based source instead or specify a MIME type for the source. Available MIME types for character based sources are %s.", source2.getLanguage(), characterMimeTypes));
        }
    }

    private static final class WeakCache
    extends Cache {
        private final ConcurrentHashMap<WeakSourceKey, WeakCacheValue> sourceCache = new ConcurrentHashMap();
        private final ReferenceQueue<org.pkl.thirdparty.truffle.api.source.Source> deadSources = new ReferenceQueue();

        private WeakCache() {
        }

        @Override
        CallTarget lookup(PolyglotLanguageContext context2, org.pkl.thirdparty.truffle.api.source.Source source2, String[] argumentNames, boolean parse2) {
            this.cleanupStaleEntries();
            Object sourceId = EngineAccessor.SOURCE.getSourceIdentifier(source2);
            org.pkl.thirdparty.truffle.api.source.Source sourceValue = EngineAccessor.SOURCE.copySource(source2);
            WeakSourceKey ref = new WeakSourceKey(new SourceKey(sourceId, argumentNames), source2, this.deadSources);
            WeakCacheValue value2 = this.sourceCache.get(ref);
            if (value2 == null) {
                if (parse2) {
                    value2 = new WeakCacheValue(PolyglotSourceCache.parseImpl(context2, argumentNames, sourceValue), sourceValue);
                    WeakCacheValue prev = this.sourceCache.putIfAbsent(ref, value2);
                    if (prev != null) {
                        value2 = prev;
                    }
                } else {
                    return null;
                }
            }
            return value2.target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Source> sources) {
            this.cleanupStaleEntries();
            for (WeakCacheValue value2 : this.sourceCache.values()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, value2.source));
            }
        }

        private void cleanupStaleEntries() {
            WeakSourceKey sourceRef = null;
            while ((sourceRef = (WeakSourceKey)this.deadSources.poll()) != null) {
                this.sourceCache.remove(sourceRef);
            }
        }
    }

    private static abstract class Cache {
        private Cache() {
        }

        abstract boolean isEmpty();

        abstract CallTarget lookup(PolyglotLanguageContext var1, org.pkl.thirdparty.truffle.api.source.Source var2, String[] var3, boolean var4);

        abstract void listSources(PolyglotImpl var1, Collection<Source> var2);
    }

    private static final class StrongCache
    extends Cache {
        private final ConcurrentHashMap<SourceKey, CallTarget> sourceCache = new ConcurrentHashMap();

        private StrongCache() {
        }

        @Override
        CallTarget lookup(PolyglotLanguageContext context2, org.pkl.thirdparty.truffle.api.source.Source source2, String[] argumentNames, boolean parse2) {
            CallTarget prevTarget;
            SourceKey key2 = new SourceKey(source2, argumentNames);
            CallTarget target = this.sourceCache.get(key2);
            if (target == null && parse2 && (prevTarget = this.sourceCache.putIfAbsent(key2, target = PolyglotSourceCache.parseImpl(context2, argumentNames, source2))) != null) {
                target = prevTarget;
            }
            return target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Source> sources) {
            for (SourceKey key2 : this.sourceCache.keySet()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, (org.pkl.thirdparty.truffle.api.source.Source)key2.key));
            }
        }
    }

    private static final class WeakSourceKey
    extends WeakReference<org.pkl.thirdparty.truffle.api.source.Source> {
        final SourceKey key;

        WeakSourceKey(SourceKey key2, org.pkl.thirdparty.truffle.api.source.Source value2, ReferenceQueue<? super org.pkl.thirdparty.truffle.api.source.Source> q2) {
            super(value2, q2);
            this.key = key2;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakSourceKey) {
                WeakSourceKey other = (WeakSourceKey)obj;
                return this.key.equals(other.key);
            }
            return false;
        }
    }

    private static final class SourceKey {
        private final Object key;
        private final String[] arguments;

        SourceKey(Object key2, String[] arguments2) {
            this.key = key2;
            this.arguments = arguments2 != null && arguments2.length == 0 ? null : arguments2;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.key.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.arguments);
            return result2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceKey) {
                SourceKey other = (SourceKey)obj;
                return this.key.equals(other.key) && Arrays.equals(this.arguments, other.arguments);
            }
            return false;
        }
    }

    static class WeakCacheValue {
        final CallTarget target;
        final org.pkl.thirdparty.truffle.api.source.Source source;

        WeakCacheValue(CallTarget target, org.pkl.thirdparty.truffle.api.source.Source source2) {
            this.target = target;
            this.source = source2;
        }
    }
}

