/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pkl.thirdparty.graalvm.polyglot.Value;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.ThreadLocalAction;
import org.pkl.thirdparty.truffle.api.Truffle;
import org.pkl.thirdparty.truffle.api.TruffleSafepoint;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.FrameInstance;
import org.pkl.thirdparty.truffle.api.frame.FrameInstanceVisitor;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.HostToGuestRootNode;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotWrapper;

final class PolyglotStackFramesRetriever {
    PolyglotStackFramesRetriever() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void populateHeapRoots(final PolyglotContextImpl context2, final List<Object> heapRoots) {
        Future<Object> future;
        PolyglotContextImpl polyglotContextImpl = context2;
        synchronized (polyglotContextImpl) {
            future = !context2.state.isClosed() ? context2.threadLocalActions.submit(null, "engine", new ThreadLocalAction(false, false){

                @Override
                protected void perform(ThreadLocalAction.Access access) {
                    Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){

                        @Override
                        public Object visitFrame(FrameInstance frameInstance) {
                            PolyglotStackFramesRetriever.populateHeapRootsFromFrame(context2, frameInstance, heapRoots);
                            return null;
                        }
                    });
                }
            }, false) : CompletableFuture.completedFuture(null);
        }
        TruffleSafepoint.setBlockedThreadInterruptible(context2.uncachedLocation, new TruffleSafepoint.Interruptible<Future<Void>>(){

            @Override
            public void apply(Future<Void> arg) throws InterruptedException {
                if (!context2.state.isClosed()) {
                    try {
                        arg.get();
                    }
                    catch (ExecutionException e2) {
                        throw CompilerDirectives.shouldNotReachHere(e2);
                    }
                }
            }
        }, future);
    }

    private static void addRootPointerForGuestToHostStackFrameArgument(PolyglotContextImpl context2, Object obj, List<Object> heapRoots) {
        if (InteropLibrary.isValidValue(obj)) {
            heapRoots.add(obj);
        } else if (obj instanceof PolyglotWrapper) {
            heapRoots.add(((PolyglotWrapper)obj).getGuestObject());
        } else if (obj instanceof Value) {
            heapRoots.add(context2.getAPIAccess().getReceiver((Value)obj));
        }
    }

    static void populateHeapRootsFromFrame(PolyglotContextImpl context2, FrameInstance frameInstance, List<Object> heapRoots) {
        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
        RootNode rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
        if (!(rootNode instanceof HostToGuestRootNode)) {
            if (EngineAccessor.HOST.isGuestToHostRootNode(rootNode)) {
                for (Object obj : frame.getArguments()) {
                    if (obj instanceof Object[]) {
                        for (Object elem : (Object[])obj) {
                            PolyglotStackFramesRetriever.addRootPointerForGuestToHostStackFrameArgument(context2, elem, heapRoots);
                        }
                        continue;
                    }
                    PolyglotStackFramesRetriever.addRootPointerForGuestToHostStackFrameArgument(context2, obj, heapRoots);
                }
            } else {
                heapRoots.add(frame);
            }
        }
    }
}

