/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.lang.reflect.Proxy;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotValueDispatch;

interface PolyglotWrapper {
    public Object getGuestObject();

    public PolyglotContextImpl getContext();

    public PolyglotLanguageContext getLanguageContext();

    public static boolean isInstance(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Proxy) {
            return PolyglotWrapper.isHostProxy(v);
        }
        return v instanceof PolyglotWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isHostProxy(Object v) {
        if (Proxy.isProxyClass(v.getClass())) {
            return Proxy.getInvocationHandler(v) instanceof PolyglotWrapper;
        }
        return false;
    }

    public static PolyglotWrapper asInstance(Object v) {
        if (v instanceof Proxy) {
            return PolyglotWrapper.getHostProxy(v);
        }
        return (PolyglotWrapper)v;
    }

    @CompilerDirectives.TruffleBoundary
    public static PolyglotWrapper getHostProxy(Object v) {
        return (PolyglotWrapper)((Object)Proxy.getInvocationHandler(v));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equalsProxy(PolyglotWrapper wrapper, Object other) {
        if (other == null) {
            return false;
        }
        if (Proxy.isProxyClass(other.getClass())) {
            return PolyglotWrapper.equals(wrapper.getLanguageContext(), wrapper.getGuestObject(), PolyglotWrapper.getHostProxy(other).getGuestObject());
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object context2, Object receiver, Object obj) {
        PolyglotContextImpl.State localContextState;
        if (obj == null) {
            return false;
        }
        if (receiver == obj) {
            return true;
        }
        PolyglotLanguageContext languageContext = (PolyglotLanguageContext)context2;
        if (languageContext != null && (localContextState = languageContext.context.state).isInvalidOrClosed()) {
            return false;
        }
        Object prev = null;
        try {
            prev = PolyglotValueDispatch.hostEnter(languageContext);
        }
        catch (Throwable t) {
            return false;
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            InteropLibrary objLib = InteropLibrary.getUncached(obj);
            boolean bl = receiverLib.isIdentical(receiver, obj, objLib);
            return bl;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashCode(Object context2, Object receiver) {
        int n;
        PolyglotContextImpl.State localContextState;
        PolyglotLanguageContext languageContext = (PolyglotLanguageContext)context2;
        if (languageContext != null && (localContextState = languageContext.context.state).isInvalidOrClosed()) {
            return System.identityHashCode(receiver);
        }
        Object prev = null;
        try {
            prev = PolyglotValueDispatch.hostEnter(languageContext);
        }
        catch (Throwable t) {
            return System.identityHashCode(receiver);
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            if (receiverLib.hasIdentity(receiver)) {
                int n2 = receiverLib.identityHashCode(receiver);
                return n2;
            }
            n = System.identityHashCode(receiver);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(Object languageContext, Object receiver) {
        PolyglotContextImpl.State localContextState;
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = null;
        if (context2 != null && (localContextState = context2.context.state).isInvalidOrClosed()) {
            return "Error in toString(): Context is invalid or closed.";
        }
        try {
            prev = PolyglotValueDispatch.hostEnter(context2);
        }
        catch (Throwable t) {
            return String.format("Error in toString(): Could not enter context: %s.", t.getMessage());
        }
        try {
            String t = PolyglotWrapper.toStringImpl(context2, receiver);
            return t;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    public static String toString(PolyglotWrapper thisObj) {
        return PolyglotWrapper.toString(thisObj.getLanguageContext(), thisObj.getGuestObject());
    }

    public static String toStringImpl(Object languageContext, Object receiver) throws AssertionError {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        Object result2 = lib.toDisplayString(receiver);
        InteropLibrary resultLib = InteropLibrary.getFactory().getUncached(result2);
        try {
            return resultLib.asString(result2);
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere("toDisplayString must be coercible to java.lang.String, but is not.", e2);
        }
    }
}

