/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheDirectives$MustRevalidate$;
import org.playframework.cachecontrol.CacheDirectives$NoStore$;
import org.playframework.cachecontrol.CacheDirectives$Public$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.OriginResponse;
import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingActions;
import org.playframework.cachecontrol.ResponseCachingActions$DoCacheResponse$;
import org.playframework.cachecontrol.ResponseCachingActions$DoNotCacheResponse$;
import org.playframework.cachecontrol.ResponseCachingCalculator$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;

public class ResponseCachingCalculator {
    private final Cache cache;

    public ResponseCachingCalculator(Cache cache) {
        this.cache = cache;
    }

    public ResponseCachingAction isCacheable(CacheRequest request, OriginResponse response) {
        if (ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.isTraceEnabled()) {
            ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.trace("isCacheable: request: " + request + ", response = " + response);
        }
        ResponseCachingAction result = (ResponseCachingAction)this.notCacheableMethod(request, response).orElse(() -> this.$anonfun$1(request, response)).orElse(() -> this.$anonfun$2(request, response)).orElse(() -> this.$anonfun$3(request, response)).orElse(() -> this.$anonfun$4(request, response)).getOrElse(() -> this.$anonfun$5(request, response));
        ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.trace("isCacheable: result = " + result);
        return result;
    }

    public ResponseCachingAction responseIsCacheable(CacheRequest request, OriginResponse response) {
        if (ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.isTraceEnabled()) {
            ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.trace("responseIsCacheable: response = " + response);
        }
        if (this.containsExpiresHeader(response)) {
            return ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response contains expires header");
        }
        if (this.containsMaxAgeDirective(response)) {
            return ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response contains max-age response directive");
        }
        if (this.cache.isShared() && this.containsSMaxAgeDirective(response)) {
            return ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response contains s-maxage and the cache is shared");
        }
        if (this.containsCachableExtension(response)) {
            return ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response contains a cache control extension that allows it to be cached");
        }
        if (this.cache.isDefaultCacheable(response.status())) {
            return ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response status code " + response.status() + " is cacheable by default");
        }
        return (ResponseCachingAction)(this.containsPublicDirective(response) ? ResponseCachingActions$DoCacheResponse$.MODULE$.apply("Response contains public response directive") : ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Response is not cacheable by default, and there are no explicit overrides"));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> notCacheableMethod(CacheRequest request, OriginResponse response) {
        if (this.cache.isCacheableMethod(request.method())) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Request method " + request.method() + " is not cacheable"));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> ineligibleResponseCode(CacheRequest request, OriginResponse response) {
        int statusCode = response.status();
        if (this.cache.isUnderstoodStatusCode(statusCode)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Response code " + statusCode + " is not understood by the cache"));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsNoStoreDirective(CacheRequest request, OriginResponse response) {
        if (request.directives().contains((Object)CacheDirectives$NoStore$.MODULE$)) {
            return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Request Cache-Control header contains no-store cache directive"));
        }
        if (response.directives().contains((Object)CacheDirectives$NoStore$.MODULE$)) {
            return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Response Cache-Control header contains no-store cache directive"));
        }
        return None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsPrivateResponseDirectiveInSharedCache(CacheRequest request, OriginResponse response) {
        if (this.cache.isShared()) {
            return CacheDirectives$.MODULE$.private(response.directives()).flatMap((Function1 & Serializable)privateDirective -> {
                if (privateDirective.headerNames().isDefined()) {
                    ResponseCachingCalculator$.org$playframework$cachecontrol$ResponseCachingCalculator$$$logger.debug("qualified private response directive found, returning None");
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply("Cache is shared, and private directive found in response"));
            });
        }
        return None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsIncompatibleAuthorizationInSharedCache(CacheRequest request, OriginResponse response) {
        if (this.cache.isShared()) {
            if (this.containsAuthorizationHeader(request) && !this.directiveAllowsAuthorization(response)) {
                String msg = "Cache is shared, authorization header found, no cache directives allow authorization";
                return Some$.MODULE$.apply((Object)ResponseCachingActions$DoNotCacheResponse$.MODULE$.apply(msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return this.cache.isCacheableExtension(extension);
    }

    public boolean directiveAllowsAuthorization(OriginResponse response) {
        return this.containsMustRevalidateDirective(response) || this.containsPublicDirective(response) || this.containsSMaxAgeDirective(response);
    }

    public boolean containsAuthorizationHeader(CacheRequest request) {
        return request.headers().contains((Object)HeaderNames$.MODULE$.Authorization());
    }

    public boolean containsExpiresHeader(OriginResponse response) {
        return response.headers().contains((Object)HeaderNames$.MODULE$.Expires());
    }

    public boolean containsPublicDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$Public$.MODULE$);
    }

    public boolean containsMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).isDefined();
    }

    public boolean containsSMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined();
    }

    public boolean containsMustRevalidateDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$);
    }

    public boolean containsCachableExtension(OriginResponse response) {
        return CacheDirectives$.MODULE$.extensions(response.directives()).exists((Function1 & Serializable)extension -> this.isCacheableExtension((CacheDirectives.CacheDirectiveExtension)extension));
    }

    private final Option $anonfun$1(CacheRequest request$1, OriginResponse response$1) {
        return this.ineligibleResponseCode(request$1, response$1);
    }

    private final Option $anonfun$2(CacheRequest request$2, OriginResponse response$2) {
        return this.containsNoStoreDirective(request$2, response$2);
    }

    private final Option $anonfun$3(CacheRequest request$3, OriginResponse response$3) {
        return this.containsPrivateResponseDirectiveInSharedCache(request$3, response$3);
    }

    private final Option $anonfun$4(CacheRequest request$4, OriginResponse response$4) {
        return this.containsIncompatibleAuthorizationInSharedCache(request$4, response$4);
    }

    private final ResponseCachingAction $anonfun$5(CacheRequest request$5, OriginResponse response$5) {
        return this.responseIsCacheable(request$5, response$5);
    }
}

