/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.AhcWSUtils;
import play.libs.ws.BodyReadable;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSCookie;
import play.libs.ws.ahc.CookieBuilder;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.StreamConverters;

public class StreamedResponse
implements StandaloneWSResponse,
CookieBuilder {
    private final int status;
    private final java.util.Map<String, List<String>> headers;
    private final String statusText;
    private final URI uri;
    private final Publisher<HttpResponseBodyPart> publisher;
    private final StandaloneAhcWSClient client;
    private final boolean useLaxCookieEncoder;
    private List<WSCookie> cookies;

    public StreamedResponse(StandaloneAhcWSClient standaloneAhcWSClient, int n, String string, URI uRI, Map<String, Seq<String>> map, Publisher<HttpResponseBodyPart> publisher, boolean bl) {
        this.client = standaloneAhcWSClient;
        this.status = n;
        this.statusText = string;
        this.uri = uRI;
        this.headers = StreamedResponse.asJava(map);
        this.publisher = publisher;
        this.useLaxCookieEncoder = bl;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public java.util.Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Object getUnderlying() {
        return this.publisher;
    }

    public List<WSCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.buildCookies(this.headers);
        }
        return this.cookies;
    }

    public Optional<WSCookie> getCookie(String string) {
        Predicate<WSCookie> predicate = wSCookie -> wSCookie.getName().equals(string);
        return this.getCookies().stream().filter(predicate).findFirst();
    }

    public String getContentType() {
        return this.getSingleHeader(HttpHeaderNames.CONTENT_TYPE.toString()).orElse("application/octet-stream");
    }

    public <T> T getBody(BodyReadable<T> bodyReadable) {
        return (T)bodyReadable.apply((Object)this);
    }

    public String getBody() {
        return this.getBodyAsBytes().decodeString(AhcWSUtils.getCharset(this.getContentType()));
    }

    public ByteString getBodyAsBytes() {
        return this.client.blockingToByteString(this.getBodyAsSource());
    }

    public Source<ByteString, ?> getBodyAsSource() {
        return Source.fromPublisher(this.publisher).map((Function & Serializable)httpResponseBodyPart -> ByteString.fromArray((byte[])httpResponseBodyPart.getBodyPartBytes()));
    }

    @Override
    public boolean isUseLaxCookieEncoder() {
        return this.useLaxCookieEncoder;
    }

    public URI getUri() {
        return this.uri;
    }

    private static java.util.Map<String, List<String>> asJava(Map<String, Seq<String>> map) {
        return StreamConverters.asJavaSeqStream(map).collect(Collectors.toMap(tuple2 -> (String)tuple2._1(), tuple2 -> CollectionConverters.asJava((Seq)((Seq)tuple2._2()))));
    }
}

