/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.oauth;

import java.io.Serializable;
import play.api.libs.oauth.OAuth$;
import play.api.libs.oauth.RequestToken;
import play.api.libs.oauth.RequestToken$;
import play.api.libs.oauth.ServiceInfo;
import play.shaded.oauth.oauth.signpost.OAuthConsumer;
import play.shaded.oauth.oauth.signpost.basic.DefaultOAuthConsumer;
import play.shaded.oauth.oauth.signpost.basic.DefaultOAuthProvider;
import play.shaded.oauth.oauth.signpost.exception.OAuthException;
import scala.Product;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;

public class OAuth
implements Product,
Serializable {
    private final ServiceInfo info;
    private final boolean use10a;
    private final DefaultOAuthProvider provider;

    public static OAuth apply(ServiceInfo serviceInfo, boolean bl) {
        return OAuth$.MODULE$.apply(serviceInfo, bl);
    }

    public static OAuth fromProduct(Product product) {
        return OAuth$.MODULE$.fromProduct(product);
    }

    public static OAuth unapply(OAuth oAuth) {
        return OAuth$.MODULE$.unapply(oAuth);
    }

    public static boolean $lessinit$greater$default$2() {
        return OAuth$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * WARNING - void declaration
     */
    public OAuth(ServiceInfo info, boolean use10a) {
        void var3_3;
        this.info = info;
        this.use10a = use10a;
        DefaultOAuthProvider p = new DefaultOAuthProvider(info.requestTokenURL(), info.accessTokenURL(), info.authorizationURL());
        p.setOAuth10a(use10a);
        this.provider = var3_3;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)75010711);
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.info()));
        n = Statics.mix((int)n, (int)(this.use10a() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OAuth)) return false;
        OAuth oAuth = (OAuth)object;
        if (this.use10a() != oAuth.use10a()) return false;
        ServiceInfo serviceInfo = this.info();
        ServiceInfo serviceInfo2 = oAuth.info();
        if (serviceInfo == null) {
            if (serviceInfo2 != null) {
                return false;
            }
        } else if (!((Object)serviceInfo).equals(serviceInfo2)) return false;
        if (!oAuth.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof OAuth;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "OAuth";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToBoolean((boolean)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "info";
        }
        if (1 == n2) {
            return "use10a";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ServiceInfo info() {
        return this.info;
    }

    public boolean use10a() {
        return this.use10a;
    }

    public Either<OAuthException, RequestToken> retrieveRequestToken(String callbackURL) {
        Left left;
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.info().key().key(), this.info().key().secret());
        try {
            this.provider.retrieveRequestToken((OAuthConsumer)consumer, callbackURL, new String[0]);
            left = package$.MODULE$.Right().apply((Object)RequestToken$.MODULE$.apply(consumer.getToken(), consumer.getTokenSecret()));
        }
        catch (OAuthException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Either<OAuthException, RequestToken> retrieveAccessToken(RequestToken token, String verifier) {
        Left left;
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.info().key().key(), this.info().key().secret());
        consumer.setTokenWithSecret(token.token(), token.secret());
        try {
            this.provider.retrieveAccessToken((OAuthConsumer)consumer, verifier, new String[0]);
            left = package$.MODULE$.Right().apply((Object)RequestToken$.MODULE$.apply(consumer.getToken(), consumer.getTokenSecret()));
        }
        catch (OAuthException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public String redirectUrl(String token) {
        return play.shaded.oauth.oauth.signpost.OAuth.addQueryParameters((String)this.provider.getAuthorizationWebsiteUrl(), (String[])new String[]{"oauth_token", token});
    }

    public OAuth copy(ServiceInfo info, boolean use10a) {
        return new OAuth(info, use10a);
    }

    public ServiceInfo copy$default$1() {
        return this.info();
    }

    public boolean copy$default$2() {
        return this.use10a();
    }

    public ServiceInfo _1() {
        return this.info();
    }

    public boolean _2() {
        return this.use10a();
    }
}

