/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.db.evolutions.DefaultEvolutionsConfig;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig$;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

@Singleton
public class DefaultEvolutionsConfigParser
implements Provider<EvolutionsConfig> {
    private final Configuration rootConfig;

    @Inject
    public DefaultEvolutionsConfigParser(Configuration rootConfig) {
        this.rootConfig = rootConfig;
        Logger logger = Logger$.MODULE$.apply(DefaultEvolutionsConfigParser.class);
    }

    public EvolutionsConfig get() {
        return this.parse();
    }

    public EvolutionsConfig parse() {
        Configuration config = (Configuration)this.rootConfig.get("play.evolutions", ConfigLoader$.MODULE$.configurationLoader());
        Set datasources = (Set)((Configuration)config.get("db", ConfigLoader$.MODULE$.configurationLoader())).subKeys().$plus$plus((IterableOnce)this.loadDatasources$1("applyEvolutions")).$plus$plus((IterableOnce)this.loadDatasources$1("applyDownEvolutions"));
        boolean enabled = BoxesRunTime.unboxToBoolean((Object)config.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
        String schema = (String)config.get("schema", ConfigLoader$.MODULE$.stringLoader());
        String metaTable = (String)config.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
        boolean autocommit = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, DefaultEvolutionsConfigParser::$anonfun$3, "autocommit", "evolutions.autocommit", ConfigLoader$.MODULE$.booleanLoader()));
        boolean useLocks = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, DefaultEvolutionsConfigParser::$anonfun$4, "useLocks", "evolutions.use.locks", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApply = BoxesRunTime.unboxToBoolean((Object)config.get("autoApply", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)config.get("autoApplyDowns", ConfigLoader$.MODULE$.booleanLoader()));
        boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)config.get("skipApplyDownsOnly", ConfigLoader$.MODULE$.booleanLoader()));
        String path = (String)config.get("path", ConfigLoader$.MODULE$.stringLoader());
        String substPrefix = (String)config.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
        String substSuffix = (String)config.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
        Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(config);
        boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)config.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
        DefaultEvolutionsDatasourceConfig defaultConfig = DefaultEvolutionsDatasourceConfig$.MODULE$.apply(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path);
        Map datasourceConfigMap = (Map)((IterableOnceOps)datasources.map((Function1 & Serializable)_$4 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(_$4);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)config);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)config.getPrototypedMap("db", ""));
        Map datasourceConfig = (Map)datasourceConfigMap.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String datasource = (String)tuple2._1();
                Configuration dsConfig = (Configuration)tuple2._2();
                boolean enabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
                String schema = (String)dsConfig.get("schema", ConfigLoader$.MODULE$.stringLoader());
                String metaTable = (String)dsConfig.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
                boolean autocommit = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("autocommit", ConfigLoader$.MODULE$.booleanLoader()));
                boolean useLocks = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("useLocks", ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApply = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, () -> DefaultEvolutionsConfigParser.$anonfun$7(datasource), "autoApply", "applyEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, () -> DefaultEvolutionsConfigParser.$anonfun$8(datasource), "autoApplyDowns", "applyDownEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, () -> DefaultEvolutionsConfigParser.$anonfun$9(datasource), "skipApplyDownsOnly", "skipApplyDownsOnly." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                String path = (String)dsConfig.get("path", ConfigLoader$.MODULE$.stringLoader());
                String substPrefix = (String)dsConfig.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
                String substSuffix = (String)dsConfig.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
                boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
                Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(dsConfig);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)datasource);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)DefaultEvolutionsDatasourceConfig$.MODULE$.apply(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path));
            }
            throw new MatchError((Object)tuple2);
        });
        return new DefaultEvolutionsConfig(defaultConfig, (Map<String, EvolutionsDatasourceConfig>)datasourceConfig);
    }

    public Set<String> enabledKeys(Configuration configuration, String section) {
        return (Set)configuration.getOptional(section, ConfigLoader$.MODULE$.configurationLoader()).fold(DefaultEvolutionsConfigParser::enabledKeys$$anonfun$1, (Function1 & Serializable)conf -> (Set)conf.keys().filter((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToBoolean((Object)conf.getOptional(_$5, ConfigLoader$.MODULE$.booleanLoader()).getOrElse(DefaultEvolutionsConfigParser::enabledKeys$$anonfun$2$$anonfun$1$$anonfun$1))));
    }

    private final Object getDeprecated$1(Configuration config, Function0 baseKey, String path, String deprecated, ConfigLoader evidence$1) {
        if (this.rootConfig.underlying().hasPath(deprecated)) {
            this.rootConfig.reportDeprecation(baseKey.apply() + "." + path, deprecated);
            return this.rootConfig.get(deprecated, evidence$1);
        }
        return config.get(path, evidence$1);
    }

    private static final Map loadSubstitutionsMappings$1(Configuration config) {
        return ((IterableOnceOps)((Configuration)config.get("substitutions.mappings", ConfigLoader$.MODULE$.configurationLoader())).entrySet().map((Function1 & Serializable)e -> Tuple2$.MODULE$.apply(e._1(), (Object)((ConfigValue)e._2()).unwrapped().toString()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Set loadDatasources$1(String path) {
        if (this.rootConfig.underlying().hasPath(path)) {
            return ((Configuration)this.rootConfig.get(path, ConfigLoader$.MODULE$.configurationLoader())).subKeys();
        }
        return Predef$.MODULE$.Set().empty();
    }

    private static final String $anonfun$3() {
        return "play.evolutions";
    }

    private static final String $anonfun$4() {
        return "play.evolutions";
    }

    private static final String $anonfun$7(String datasource$1) {
        return "play.evolutions.db." + datasource$1;
    }

    private static final String $anonfun$8(String datasource$2) {
        return "play.evolutions.db." + datasource$2;
    }

    private static final String $anonfun$9(String datasource$3) {
        return "play.evolutions.db." + datasource$3;
    }

    private static final Set enabledKeys$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final boolean enabledKeys$$anonfun$2$$anonfun$1$$anonfun$1() {
        return false;
    }
}

