/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.play;

import java.io.Serializable;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEvent$;
import org.apache.pekko.http.impl.engine.ws.FrameEventParser$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.Protocol;
import org.apache.pekko.http.impl.engine.ws.UpgradeToWebSocketLowLevel;
import org.apache.pekko.http.play.WebSocketHandler$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ws.UpgradeToWebSocket;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Merge$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.websocket.BinaryMessage;
import play.api.http.websocket.CloseMessage;
import play.api.http.websocket.Message;
import play.api.http.websocket.PingMessage;
import play.api.http.websocket.PongMessage;
import play.api.http.websocket.TextMessage;
import play.api.libs.streams.PekkoStreams$;
import play.core.server.common.WebSocketFlowHandler;
import play.core.server.common.WebSocketFlowHandler$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WebSocketHandler$ {
    public static final WebSocketHandler$ MODULE$ = new WebSocketHandler$();

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit) {
        return this.handleWebSocket(upgrade, flow, bufferLimit, (Option<String>)None$.MODULE$);
    }

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit, Option<String> subprotocol) {
        return this.handleWebSocket(upgrade, flow, bufferLimit, subprotocol, "ping", (Duration)Duration$.MODULE$.Inf());
    }

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit, Option<String> subprotocol, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle) {
        UpgradeToWebSocket upgradeToWebSocket = upgrade;
        if (upgradeToWebSocket instanceof UpgradeToWebSocketLowLevel) {
            UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel = (UpgradeToWebSocketLowLevel)upgradeToWebSocket;
            return upgradeToWebSocketLowLevel.handleFrames(this.messageFlowToFrameFlow(flow, bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle), subprotocol);
        }
        throw new IllegalArgumentException("UpgradeToWebsocket is not an Pekko HTTP UpgradeToWebsocketLowLevel");
    }

    public Flow<FrameEvent, FrameEvent, ?> messageFlowToFrameFlow(Flow<Message, Message, ?> flow, int bufferLimit) {
        return this.messageFlowToFrameFlow(flow, bufferLimit, "ping", (Duration)Duration$.MODULE$.Inf());
    }

    public Flow<FrameEvent, FrameEvent, ?> messageFlowToFrameFlow(Flow<Message, Message, ?> flow, int bufferLimit, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle) {
        return (Flow)Flow$.MODULE$.apply().via(this.aggregateFrames(bufferLimit)).via((Graph)this.handleProtocolFailures().apply((Object)WebSocketFlowHandler$.MODULE$.webSocketProtocol(bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle).join(flow))).map((Function1 & Serializable)message -> MODULE$.messageToFrameEvent((Message)message));
    }

    private GraphStage<FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>>> aggregateFrames(int bufferLimit) {
        return new GraphStage<FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>>>(bufferLimit){
            private final Inlet<FrameEvent> org$apache$pekko$http$play$WebSocketHandler$$anon$$in;
            private final Outlet<Either<Message, WebSocketFlowHandler.RawMessage>> org$apache$pekko$http$play$WebSocketHandler$$anon$$out;
            private final FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>> shape;
            public final int bufferLimit$1;

            public Inlet<FrameEvent> org$apache$pekko$http$play$WebSocketHandler$$anon$$in() {
                return this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in;
            }

            public Outlet<Either<Message, WebSocketFlowHandler.RawMessage>> org$apache$pekko$http$play$WebSocketHandler$$anon$$out() {
                return this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out;
            }

            public FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private ByteString currentFrameData;
                    private FrameHeader currentFrameHeader;
                    private final /* synthetic */ anon.1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    private ByteString currentFrameData() {
                        return this.currentFrameData;
                    }

                    private void currentFrameData_$eq(ByteString x$1) {
                        this.currentFrameData = x$1;
                    }

                    private FrameHeader currentFrameHeader() {
                        return this.currentFrameHeader;
                    }

                    private void currentFrameHeader_$eq(FrameHeader x$1) {
                        this.currentFrameHeader = x$1;
                    }

                    public void onPush() {
                        FrameHeader header;
                        FrameEvent elem = (FrameEvent)this.grab(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                        boolean bl = false;
                        FrameData frameData = null;
                        boolean bl2 = false;
                        FrameStart frameStart = null;
                        FrameEvent frameEvent = elem;
                        if (frameEvent instanceof FrameData) {
                            bl = true;
                            frameData = (FrameData)frameEvent;
                            if (this.currentFrameHeader() == null) {
                                this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$close(Protocol.CloseCodes$.MODULE$.UnexpectedCondition(), "Server error"));
                                return;
                            }
                        }
                        if (bl) {
                            ByteString data = frameData.data();
                            if (this.currentFrameData().size() + data.size() > this.$outer.bufferLimit$1) {
                                this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$close(Protocol.CloseCodes$.MODULE$.TooBig(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$close$default$2()));
                                return;
                            }
                        }
                        if (bl) {
                            ByteString data = frameData.data();
                            boolean bl3 = frameData.lastPart();
                            if (!bl3) {
                                this.currentFrameData_$eq(this.currentFrameData().$plus$plus(data));
                                this.pull(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                                return;
                            }
                        }
                        if (bl) {
                            ByteString data = frameData.data();
                            boolean bl4 = frameData.lastPart();
                            if (bl4) {
                                WebSocketFlowHandler.RawMessage message = WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$frameToRawMessage(this.currentFrameHeader(), this.currentFrameData().$plus$plus(data));
                                this.currentFrameHeader_$eq(null);
                                this.currentFrameData_$eq(null);
                                this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), new Right((Object)message));
                                return;
                            }
                        }
                        if (frameEvent instanceof FrameStart) {
                            bl2 = true;
                            frameStart = (FrameStart)frameEvent;
                            if (this.currentFrameHeader() != null) {
                                this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$close(Protocol.CloseCodes$.MODULE$.UnexpectedCondition(), "Server error"));
                                return;
                            }
                        }
                        if (bl2 && (header = frameStart.header()).mask().isEmpty()) {
                            this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$close(Protocol.CloseCodes$.MODULE$.ProtocolError(), "Unmasked client frame"));
                            return;
                        }
                        if (bl2) {
                            FrameHeader header2 = frameStart.header();
                            ByteString data = frameStart.data();
                            if (frameStart.lastPart()) {
                                this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), new Right((Object)WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$frameToRawMessage(header2, data)));
                                return;
                            }
                        }
                        if (bl2) {
                            FrameHeader header3 = frameStart.header();
                            ByteString data = frameStart.data();
                            this.currentFrameHeader_$eq(header3);
                            this.currentFrameData_$eq(data);
                            this.pull(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }

                    public void onPull() {
                        this.pull(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.currentFrameData = null;
                        this.currentFrameHeader = null;
                        this.setHandlers($outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in(), $outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), this);
                    }
                };
            }
            {
                this.bufferLimit$1 = bufferLimit$1;
                this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in = Inlet$.MODULE$.apply("WebSocketHandler.aggregateFrames.in");
                this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out = Outlet$.MODULE$.apply("WebSocketHandler.aggregateFrames.out");
                this.shape = FlowShape$.MODULE$.of(this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in(), this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out());
            }
        };
    }

    public WebSocketFlowHandler.RawMessage org$apache$pekko$http$play$WebSocketHandler$$frameToRawMessage(FrameHeader header, ByteString data) {
        ByteString unmasked = FrameEventParser$.MODULE$.mask(data, header.mask());
        return new WebSocketFlowHandler.RawMessage(this.frameOpCodeToMessageType(header.opcode()), unmasked, header.fin(), WebSocketFlowHandler.RawMessage$.MODULE$.apply$default$4());
    }

    private Enumeration.Value frameOpCodeToMessageType(Protocol.Opcode opcode) {
        Protocol.Opcode opcode2 = opcode;
        if (Protocol.Opcode$.Binary$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Binary();
        }
        if (Protocol.Opcode$.Text$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Text();
        }
        if (Protocol.Opcode$.Close$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Close();
        }
        if (Protocol.Opcode$.Ping$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Ping();
        }
        if (Protocol.Opcode$.Pong$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Pong();
        }
        if (Protocol.Opcode$.Continuation$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Continuation();
        }
        throw new MatchError((Object)opcode2);
    }

    private FrameEvent messageToFrameEvent(Message message) {
        Option option;
        boolean bl = false;
        CloseMessage closeMessage = null;
        Message message2 = message;
        if (message2 instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message2;
            String data = textMessage.data();
            return WebSocketHandler$.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Text$.MODULE$, ByteString$.MODULE$.apply(data));
        }
        if (message2 instanceof BinaryMessage) {
            BinaryMessage binaryMessage = (BinaryMessage)message2;
            ByteString data = binaryMessage.data();
            return WebSocketHandler$.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Binary$.MODULE$, data);
        }
        if (message2 instanceof PingMessage) {
            PingMessage pingMessage = (PingMessage)message2;
            ByteString data = pingMessage.data();
            return WebSocketHandler$.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Ping$.MODULE$, data);
        }
        if (message2 instanceof PongMessage) {
            PongMessage pongMessage = (PongMessage)message2;
            ByteString data = pongMessage.data();
            return WebSocketHandler$.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Pong$.MODULE$, data);
        }
        if (message2 instanceof CloseMessage) {
            bl = true;
            closeMessage = (CloseMessage)message2;
            Option option2 = closeMessage.statusCode();
            String reason = closeMessage.reason();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                int statusCode = BoxesRunTime.unboxToInt((Object)some.value());
                return FrameEvent$.MODULE$.closeFrame(statusCode, reason, FrameEvent$.MODULE$.closeFrame$default$3());
            }
        }
        if (bl && None$.MODULE$.equals(option = closeMessage.statusCode())) {
            return WebSocketHandler$.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Close$.MODULE$, ByteString$.MODULE$.empty());
        }
        throw new MatchError((Object)message2);
    }

    private Function1<Flow<WebSocketFlowHandler.RawMessage, Message, ?>, Flow<Either<Message, WebSocketFlowHandler.RawMessage>, Message, ?>> handleProtocolFailures() {
        return PekkoStreams$.MODULE$.bypassWith(Flow$.MODULE$.apply().via((Graph)new GraphStage<FlowShape<Either<Message, WebSocketFlowHandler.RawMessage>, Either<WebSocketFlowHandler.RawMessage, Message>>>(){
            private final Inlet<Either<Message, WebSocketFlowHandler.RawMessage>> org$apache$pekko$http$play$WebSocketHandler$$anon$$in;
            private final Outlet<Either<WebSocketFlowHandler.RawMessage, Message>> org$apache$pekko$http$play$WebSocketHandler$$anon$$out;
            private final FlowShape<Either<Message, WebSocketFlowHandler.RawMessage>, Either<WebSocketFlowHandler.RawMessage, Message>> shape;

            public Inlet<Either<Message, WebSocketFlowHandler.RawMessage>> org$apache$pekko$http$play$WebSocketHandler$$anon$$in() {
                return this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in;
            }

            public Outlet<Either<WebSocketFlowHandler.RawMessage, Message>> org$apache$pekko$http$play$WebSocketHandler$$anon$$out() {
                return this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out;
            }

            public FlowShape<Either<Message, WebSocketFlowHandler.RawMessage>, Either<WebSocketFlowHandler.RawMessage, Message>> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private boolean closing;
                    private final /* synthetic */ anon.3 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    private boolean closing() {
                        return this.closing;
                    }

                    private void closing_$eq(boolean x$1) {
                        this.closing = x$1;
                    }

                    public void onPush() {
                        Either elem;
                        Either either = elem = (Either)this.grab(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                        if (this.closing()) {
                            this.completeStage();
                            return;
                        }
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            WebSocketFlowHandler.RawMessage message = (WebSocketFlowHandler.RawMessage)right.value();
                            this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), new Left((Object)message));
                            return;
                        }
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            Message close = (Message)left.value();
                            this.closing_$eq(true);
                            this.push(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), new Right((Object)close));
                            return;
                        }
                        throw new MatchError((Object)either);
                    }

                    public void onPull() {
                        this.pull(this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.closing = false;
                        this.setHandlers($outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$in(), $outer.org$apache$pekko$http$play$WebSocketHandler$$anon$$out(), this);
                    }
                };
            }
            {
                this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in = Inlet$.MODULE$.apply("WebSocketHandler.handleProtocolFailures.in");
                this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out = Outlet$.MODULE$.apply("WebSocketHandler.handleProtocolFailures.out");
                this.shape = FlowShape$.MODULE$.of(this.org$apache$pekko$http$play$WebSocketHandler$$anon$$in(), this.org$apache$pekko$http$play$WebSocketHandler$$anon$$out());
            }
        }), (Graph)Merge$.MODULE$.apply(2, true));
    }

    public Left<CloseMessage, Nothing$> org$apache$pekko$http$play$WebSocketHandler$$close(int status, String message) {
        return new Left((Object)new CloseMessage((Option)new Some((Object)BoxesRunTime.boxToInteger((int)status)), message));
    }

    public String org$apache$pekko$http$play$WebSocketHandler$$close$default$2() {
        return "";
    }

    private static final FrameStart frameEvent$1(Protocol.Opcode opcode, ByteString data) {
        return FrameEvent$.MODULE$.fullFrame(opcode, (Option)None$.MODULE$, data, true, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7());
    }

    private WebSocketHandler$() {
    }
}

