/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.pekkohttp;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpHeader$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.TransferEncodings;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Connection$;
import org.apache.pekko.http.scaladsl.model.headers.Raw;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.model.headers.Tls;
import org.apache.pekko.http.scaladsl.model.headers.Transfer;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.libs.typedmap.TypedMap;
import play.api.libs.typedmap.TypedMap$;
import play.api.mvc.Headers;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestHeaderImpl;
import play.api.mvc.Result;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RequestTarget;
import play.core.Execution;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.PathAndQueryParser$;
import play.core.server.common.ServerResultUtils;
import play.core.server.pekkohttp.PekkoHeadersWrapper;
import play.core.server.pekkohttp.PekkoModelConversion$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public class PekkoModelConversion {
    private final ServerResultUtils resultUtils;
    private final ForwardedHeaderHandler forwardedHeaderHandler;
    private final ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValue;
    public final Logger play$core$server$pekkohttp$PekkoModelConversion$$logger;
    private final Set<String> mustParseHeaders;

    public PekkoModelConversion(ServerResultUtils resultUtils, ForwardedHeaderHandler forwardedHeaderHandler, ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValue) {
        this.resultUtils = resultUtils;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.illegalResponseHeaderValue = illegalResponseHeaderValue;
        this.play$core$server$pekkohttp$PekkoModelConversion$$logger = Logger$.MODULE$.apply(this.getClass());
        this.mustParseHeaders = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Type", "Content-Length", "Transfer-Encoding", "Date", "Server", "Connection"}))).map((Function1 & Serializable)_$3 -> _$3.toLowerCase(Locale.ROOT));
    }

    public Try<RequestHeader> convertRequestHeader(InetSocketAddress remoteAddress, boolean secureProtocol, HttpRequest request) {
        return Try$.MODULE$.apply(() -> this.convertRequestHeader$$anonfun$1(request, secureProtocol, remoteAddress));
    }

    public RequestHeader createRequestHeader(Headers headers, boolean secureProtocol, InetSocketAddress remoteAddress, RequestTarget requestTarget, HttpRequest request) {
        InetSocketAddress remoteAddressArg = remoteAddress;
        return new RequestHeaderImpl(this.forwardedHeaderHandler.forwardedConnection(new RemoteConnection(remoteAddressArg, secureProtocol, request){
            private final InetSocketAddress remoteAddressArg$1;
            private final boolean secureProtocol$2;
            private final HttpRequest request$6;
            {
                this.remoteAddressArg$1 = remoteAddressArg$2;
                this.secureProtocol$2 = secureProtocol$3;
                this.request$6 = request$7;
            }

            public InetAddress remoteAddress() {
                return this.remoteAddressArg$1.getAddress();
            }

            public boolean secure() {
                return this.secureProtocol$2;
            }

            public Option clientCertificateChain() {
                None$ none$;
                try {
                    none$ = this.request$6.header(ClassTag$.MODULE$.apply(Tls.minusSession.minusInfo.class)).map(PekkoModelConversion::play$core$server$pekkohttp$PekkoModelConversion$$anon$2$$_$clientCertificateChain$$anonfun$1);
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$pekkohttp$PekkoModelConversion$$anon$2$$_$clientCertificateChain$$anonfun$1(org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo )}, serializedLambda);
            }
        }, headers), request.method().name(), requestTarget, request.protocol().value(), headers, (TypedMap)TypedMap$.MODULE$.empty());
    }

    public PekkoHeadersWrapper convertRequestHeadersPekko(HttpRequest request) {
        None$ knownContentLength = None$.MODULE$;
        ObjectRef isChunked = ObjectRef.create((Object)None$.MODULE$);
        RequestEntity requestEntity = request.entity();
        if (requestEntity instanceof HttpEntity.Strict) {
            ByteString byteString;
            HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)requestEntity);
            ContentType contentType = strict._1();
            ByteString data = byteString = strict._2();
            RequestEntityAcceptance requestEntityAcceptance = request.method().requestEntityAcceptance();
            RequestEntityAcceptance.Expected$ expected$ = RequestEntityAcceptance.Expected$.MODULE$;
            if (!(requestEntityAcceptance == null ? expected$ != null : !requestEntityAcceptance.equals(expected$)) || data.nonEmpty()) {
                knownContentLength = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)data.length()).toString());
            }
        } else if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = HttpEntity.Default$.MODULE$.unapply((HttpEntity.Default)requestEntity);
            ContentType contentType = default_._1();
            long l = default_._2();
            Source source = default_._3();
            long cLength = l;
            RequestEntityAcceptance requestEntityAcceptance = request.method().requestEntityAcceptance();
            RequestEntityAcceptance.Expected$ expected$ = RequestEntityAcceptance.Expected$.MODULE$;
            if (!(requestEntityAcceptance == null ? expected$ != null : !requestEntityAcceptance.equals(expected$)) || cLength > 0L) {
                knownContentLength = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)cLength).toString());
            }
        } else if (requestEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked e = (HttpEntity.Chunked)requestEntity;
            isChunked.elem = Some$.MODULE$.apply((Object)TransferEncodings.chunked$.MODULE$.value());
        } else {
            throw new MatchError((Object)requestEntity);
        }
        ObjectRef requestUri = ObjectRef.create(null);
        request.headers().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Raw.minusRequest.minusURI) {
                String string;
                Raw.minusRequest.minusURI minusURI2 = Raw$minusRequest$minusURI$.MODULE$.unapply((Raw.minusRequest.minusURI)httpHeader);
                String u = string = minusURI2._1();
                requestUri$1.elem = u;
                return;
            }
            if (httpHeader instanceof Transfer.minusEncoding) {
                Transfer.minusEncoding e = (Transfer.minusEncoding)httpHeader;
                isChunked$3.elem = Some$.MODULE$.apply((Object)e.value());
                return;
            }
        });
        if ((String)requestUri.elem == null) {
            requestUri.elem = request.uri().toString();
        }
        return new PekkoHeadersWrapper(request, (Option<String>)knownContentLength, (Seq<HttpHeader>)request.headers(), (Option<String>)((Option)isChunked.elem), (String)requestUri.elem);
    }

    public Either<ByteString, Source<ByteString, Object>> convertRequestBody(HttpRequest request) {
        RequestEntity requestEntity = request.entity();
        if (requestEntity instanceof HttpEntity.Strict) {
            ByteString byteString;
            HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)requestEntity);
            ContentType contentType = strict._1();
            ByteString data = byteString = strict._2();
            return package$.MODULE$.Left().apply((Object)data);
        }
        if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = HttpEntity.Default$.MODULE$.unapply((HttpEntity.Default)requestEntity);
            ContentType contentType = default_._1();
            long l = default_._2();
            Source source = default_._3();
            if (0L == l) {
                return package$.MODULE$.Left().apply((Object)ByteString$.MODULE$.empty());
            }
            ContentType contentType2 = contentType;
            long contentLength = l;
            Source pubr = source;
            return package$.MODULE$.Right().apply((Object)pubr);
        }
        if (requestEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)requestEntity);
            ContentType contentType = chunked._1();
            Source source = chunked._2();
            ContentType contentType3 = contentType;
            Source chunks = source;
            return package$.MODULE$.Right().apply((Object)chunks.filter((Function1 & Serializable)_$1 -> !_$1.isLastChunk()).map((Function1 & Serializable)_$2 -> _$2.data()));
        }
        throw new MatchError((Object)requestEntity);
    }

    public Future<HttpResponse> convertResult(RequestHeader requestHeaders, Result unvalidated2, HttpProtocol protocol, HttpErrorHandler errorHandler, Materializer mat) {
        return this.resultUtils.resultConversionWithErrorHandling(requestHeaders, unvalidated2, errorHandler, (Function1 & Serializable)unvalidated -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture(this.resultUtils.validateResult(requestHeaders, unvalidated, errorHandler, mat));
            Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)validated -> {
                Seq<HttpHeader> convertedHeaders = this.convertHeaders((Iterable<Tuple2<String, String>>)validated.header().headers());
                ResponseEntity entity = this.convertResultBody(requestHeaders, (Result)validated, protocol);
                int intStatus = validated.header().status();
                StatusCode statusCode = (StatusCode)StatusCodes$.MODULE$.getForKey((Object)BoxesRunTime.boxToInteger((int)intStatus)).getOrElse(() -> PekkoModelConversion.$anonfun$1(validated, intStatus));
                HttpResponse response = HttpResponse$.MODULE$.apply(statusCode, convertedHeaders, entity, protocol);
                return response;
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }, () -> PekkoModelConversion.convertResult$$anonfun$2(protocol));
    }

    public ContentType parseContentType(Option<String> contentType) {
        return (ContentType)contentType.fold(PekkoModelConversion::parseContentType$$anonfun$1, (Function1 & Serializable)ct -> {
            Either either = Either$.MODULE$.MergeableEither(ContentType$.MODULE$.parse(ct).left().map((Function1 & Serializable)errors -> {
                throw new RuntimeException("Error parsing response Content-Type: <" + ct + ">: " + errors);
            }));
            return (ContentType)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public ResponseEntity convertResultBody(RequestHeader requestHeaders, Result result, HttpProtocol protocol) {
        HttpEntity.Strict strict;
        ContentType contentType = this.parseContentType((Option<String>)result.body().contentType());
        HttpEntity httpEntity = result.body();
        if (httpEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict2 = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
            ByteString byteString = strict2._1();
            Option option = strict2._2();
            ByteString data = byteString;
            strict = HttpEntity.Strict$.MODULE$.apply(contentType, data);
        } else if (httpEntity instanceof HttpEntity.Streamed) {
            HttpEntity.Streamed streamed = HttpEntity.Streamed$.MODULE$.unapply((HttpEntity.Streamed)httpEntity);
            Source source = streamed._1();
            Option option = streamed._2();
            Option option2 = streamed._3();
            Source data = source;
            if (option instanceof Some) {
                long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                long contentLength = l;
                if (contentLength == 0L) {
                    strict = HttpEntity.Strict$.MODULE$.apply(contentType, ByteString$.MODULE$.empty());
                } else {
                    Source data2 = source;
                    long contentLength2 = l;
                    strict = HttpEntity.Default$.MODULE$.apply(contentType, contentLength2, data2);
                }
            } else {
                Source data3 = source;
                strict = HttpEntity.CloseDelimited$.MODULE$.apply(contentType, data3);
            }
        } else if (httpEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)httpEntity);
            Source source = chunked._1();
            Option option = chunked._2();
            Source data = source;
            Source pekkoChunks = (Source)data.map((Function1 & Serializable)x$1 -> {
                HttpEntity.Chunk chunk;
                HttpChunk httpChunk = x$1;
                if (httpChunk instanceof HttpChunk.Chunk) {
                    ByteString byteString;
                    HttpChunk.Chunk chunk2 = HttpChunk.Chunk$.MODULE$.unapply((HttpChunk.Chunk)httpChunk);
                    ByteString chunk3 = byteString = chunk2._1();
                    chunk = HttpEntity.Chunk$.MODULE$.apply(chunk3, HttpEntity.Chunk$.MODULE$.$lessinit$greater$default$2());
                } else if (httpChunk instanceof HttpChunk.LastChunk) {
                    HttpChunk.LastChunk lastChunk = HttpChunk.LastChunk$.MODULE$.unapply((HttpChunk.LastChunk)httpChunk);
                    Headers headers = lastChunk._1();
                    Headers trailers = headers;
                    if (trailers.headers().isEmpty()) {
                        chunk = HttpEntity.LastChunk$.MODULE$;
                    } else {
                        Headers trailers2 = headers;
                        Seq<HttpHeader> seq = this.convertHeaders((Iterable<Tuple2<String, String>>)trailers2.headers());
                        String string = HttpEntity.LastChunk$.MODULE$.$lessinit$greater$default$1();
                        chunk = HttpEntity.LastChunk$.MODULE$.apply(string, seq);
                    }
                } else {
                    throw new MatchError((Object)httpChunk);
                }
                return (HttpEntity.ChunkStreamPart)chunk;
            });
            strict = HttpEntity.Chunked$.MODULE$.apply(contentType, pekkoChunks);
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return (ResponseEntity)strict;
    }

    private Seq<HttpHeader> convertHeaders(Iterable<Tuple2<String, String>> headers) {
        return headers.iterator().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String lowerName;
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = lowerName = name.toLowerCase(Locale.ROOT);
                String string2 = "set-cookie";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (Seq)this.resultUtils.splitSetCookieHeaderValue(value).map((Function1 & Serializable)_$4 -> RawHeader$.MODULE$.apply("Set-Cookie", _$4));
                }
                if (this.mustParseHeaders.contains((Object)lowerName)) {
                    return this.parseHeader(name, value);
                }
                this.resultUtils.validateHeaderNameChars(name);
                this.resultUtils.validateHeaderValueChars(value);
                RawHeader rawHeader = RawHeader$.MODULE$.apply(name, value);
                return package$.MODULE$.Nil().$colon$colon((Object)rawHeader);
            }
            throw new MatchError((Object)tuple2);
        }).toVector();
    }

    private Seq<HttpHeader> parseHeader(String name, String value) {
        HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(name, value, HttpHeader$.MODULE$.parse$default$3());
        if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
            HttpHeader.ParsingResult$.Ok ok = HttpHeader.ParsingResult$.Ok$.MODULE$.unapply((HttpHeader.ParsingResult$.Ok)parsingResult);
            HttpHeader httpHeader = ok._1();
            List list = ok._2();
            HttpHeader header = httpHeader;
            List errors = list;
            if (!header.renderInResponses()) {
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = this.illegalResponseHeaderValue;
                if (ParserSettings.IllegalResponseHeaderValueProcessingMode$.Warn$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    this.play$core$server$pekkohttp$PekkoModelConversion$$logger.warn(() -> PekkoModelConversion.parseHeader$$anonfun$1(header), MarkerContext$.MODULE$.NoMarker());
                    RawHeader rawHeader = RawHeader$.MODULE$.apply(name, value);
                    return package$.MODULE$.Nil().$colon$colon((Object)rawHeader);
                }
                if (ParserSettings.IllegalResponseHeaderValueProcessingMode$.Ignore$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    RawHeader rawHeader = RawHeader$.MODULE$.apply(name, value);
                    return package$.MODULE$.Nil().$colon$colon((Object)rawHeader);
                }
                if (ParserSettings.IllegalResponseHeaderValueProcessingMode$.Error$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    this.play$core$server$pekkohttp$PekkoModelConversion$$logger.error(() -> PekkoModelConversion.parseHeader$$anonfun$2(header), MarkerContext$.MODULE$.NoMarker());
                    return package$.MODULE$.Nil();
                }
                throw new MatchError((Object)illegalResponseHeaderValueProcessingMode);
            }
            return package$.MODULE$.Nil().$colon$colon((Object)header);
        }
        if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
            ErrorInfo errorInfo;
            HttpHeader.ParsingResult$.Error error = HttpHeader.ParsingResult$.Error$.MODULE$.unapply((HttpHeader.ParsingResult$.Error)parsingResult);
            ErrorInfo error2 = errorInfo = error._1();
            throw scala.sys.package$.MODULE$.error("Error parsing header: " + error2);
        }
        throw new MatchError((Object)parsingResult);
    }

    public static final String play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$1() {
        return "Failed to parse query string; returning empty map.";
    }

    public static final Throwable play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$2(Throwable e$1) {
        return e$1;
    }

    private final RequestHeader convertRequestHeader$$anonfun$1(HttpRequest request$3, boolean secureProtocol$1, InetSocketAddress remoteAddress$1) {
        PekkoHeadersWrapper headers = this.convertRequestHeadersPekko(request$3);
        Tuple2 tuple2 = PathAndQueryParser$.MODULE$.parse(headers.uri());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String parsedPath = (String)tuple2._1();
        String parsedQueryString = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)parsedPath, (Object)parsedQueryString);
        String parsedPath2 = (String)tuple22._1();
        String parsedQueryString2 = (String)tuple22._2();
        RequestTarget rt = new RequestTarget(parsedPath2, parsedQueryString2, headers, request$3, this){
            private final PekkoHeadersWrapper headers$2;
            private final HttpRequest request$5;
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private volatile Object uri$lzy1;
            private final String path;
            private final String queryString;
            private volatile Object queryMap$lzy1;
            private final /* synthetic */ PekkoModelConversion $outer;
            {
                this.headers$2 = headers$1;
                this.request$5 = request$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path = parsedPath$1;
                this.queryString = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(parsedQueryString$1), "?");
            }

            static {
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("queryMap$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("uri$lzy1"));
            }

            public URI uri() {
                Object object = this.uri$lzy1;
                if (object instanceof URI) {
                    return (URI)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (URI)this.uri$lzyINIT1();
            }

            private Object uri$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.uri$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            URI uRI = null;
                            try {
                                uRI = new URI(this.headers$2.uri());
                                object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.uri$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return uRI;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public String uriString() {
                return this.headers$2.uri();
            }

            public String path() {
                return this.path;
            }

            public String queryString() {
                return this.queryString;
            }

            public Map queryMap() {
                Object object = this.queryMap$lzy1;
                if (object instanceof Map) {
                    return (Map)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (Map)this.queryMap$lzyINIT1();
            }

            private Object queryMap$lzyINIT1() {
                Object object;
                block10: {
                    while (true) {
                        if ((object = this.queryMap$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            Map map = null;
                            try {
                                Map map2;
                                try {
                                    Uri.ParsingMode$.Relaxed$ relaxed$ = Uri.ParsingMode$.Relaxed$.MODULE$;
                                    Charset charset = this.request$5.uri().query$default$1();
                                    map2 = this.request$5.uri().query(charset, (Uri.ParsingMode)relaxed$).toMultiMap();
                                }
                                catch (Throwable throwable) {
                                    Option option;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                        Throwable throwable3;
                                        Throwable e = throwable3 = (Throwable)option.get();
                                        this.$outer.play$core$server$pekkohttp$PekkoModelConversion$$logger.warn(PekkoModelConversion::play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$1, () -> PekkoModelConversion.play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                                        map2 = Predef$.MODULE$.Map().empty();
                                    }
                                    throw throwable;
                                }
                                map = map2;
                                object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                            }
                            catch (Throwable throwable) {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.queryMap$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                                throw throwable;
                            }
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.queryMap$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            return map;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$1(), play$core$server$pekkohttp$PekkoModelConversion$$anon$1$$_$queryMap$lzyINIT1$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        };
        return this.createRequestHeader(headers, secureProtocol$1, remoteAddress$1, rt, request$3);
    }

    public static final /* synthetic */ ArraySeq play$core$server$pekkohttp$PekkoModelConversion$$anon$2$$_$clientCertificateChain$$anonfun$1(Tls.minusSession.minusInfo tlsSessionInfo) {
        return (ArraySeq)ArraySeq$.MODULE$.unsafeWrapArray((Object)tlsSessionInfo.getSession().getPeerCertificates()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Certificate x) {
                Certificate certificate = x;
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Certificate x, Function1 function1) {
                Certificate certificate = x;
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    return x509;
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final StatusCode $anonfun$1(Result validated$1, int intStatus$1) {
        String reasonPhrase = (String)validated$1.header().reasonPhrase().getOrElse(PekkoModelConversion::$anonfun$2);
        if (intStatus$1 >= 600 || intStatus$1 < 100) {
            return StatusCodes$.MODULE$.custom(intStatus$1, reasonPhrase, "", false, true);
        }
        return StatusCodes$.MODULE$.custom(intStatus$1, reasonPhrase, StatusCodes$.MODULE$.custom$default$3());
    }

    private static final HttpResponse convertResult$$anonfun$2(HttpProtocol protocol$3) {
        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Seq)((SeqOps)new .colon.colon((Object)Connection$.MODULE$.apply("close", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), (List)Nil$.MODULE$)), (ResponseEntity)HttpEntity$.MODULE$.Empty(), protocol$3);
    }

    private static final ContentType parseContentType$$anonfun$1() {
        return ContentTypes$.MODULE$.NoContentType();
    }

    private static final String parseHeader$$anonfun$1(HttpHeader header$1) {
        return "HTTP Header '" + header$1 + "' is not allowed in responses, you can turn off this warning by setting `play.server.pekko.illegal-response-header-value-processing-mode = ignore`";
    }

    private static final String parseHeader$$anonfun$2(HttpHeader header$2) {
        return "HTTP Header '" + header$2 + "' is not allowed in responses";
    }
}

