/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.CoordinatedShutdown$;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Environment$;
import play.api.Mode;
import play.api.Play$;
import play.core.server.RealServerProcess;
import play.core.server.ReloadableServer;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProcess;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;

public final class ProdServerStart$
implements Serializable {
    public static final ProdServerStart$ MODULE$ = new ProdServerStart$();

    private ProdServerStart$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProdServerStart$.class);
    }

    public void main(String[] args) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        this.start(new RealServerProcess((Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(object)));
    }

    public ReloadableServer start(ServerProcess process) {
        Server server;
        try {
            ServerConfig config = this.readServerConfigSettings(process);
            Option<File> pidFile = this.createPidFile(process, config.configuration());
            try {
                Environment environment = Environment$.MODULE$.apply(config.rootDir(), process.classLoader(), (Mode)Mode.Prod$.MODULE$);
                ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.create(environment, ApplicationLoader.Context$.MODULE$.create$default$2(), ApplicationLoader.Context$.MODULE$.create$default$3(), ApplicationLoader.Context$.MODULE$.create$default$4());
                ApplicationLoader loader = ApplicationLoader$.MODULE$.apply(context);
                Application application = loader.load(context);
                Play$.MODULE$.start(application);
                ServerProvider serverProvider = ServerProvider$.MODULE$.fromConfiguration(process.classLoader(), config.configuration());
                Server server2 = serverProvider.createServer(config, application);
                String phase = CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate();
                application.coordinatedShutdown().addTask(phase, "remove-pid-file", (Function0 & Serializable)() -> {
                    pidFile.foreach((Function1 & Serializable)_$1 -> _$1.delete());
                    if (!pidFile.forall((Function1 & Serializable)_$2 -> !_$2.exists())) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)"PID file should not exist!");
                    }
                    return Future$.MODULE$.successful((Object)Done$.MODULE$);
                });
                process.addShutdownHook((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    ProdServerStart$.start$$anonfun$2(application, server2);
                    return BoxedUnit.UNIT;
                });
                server = server2;
            }
            catch (Throwable e) {
                pidFile.foreach((Function1 & Serializable)_$3 -> _$3.delete());
                throw e;
            }
        }
        catch (Throwable throwable) {
            Nothing$ nothing$;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ServerStartException) {
                ServerStartException serverStartException = ServerStartException$.MODULE$.unapply((ServerStartException)throwable2);
                String string = serverStartException._1();
                Option<Throwable> option = serverStartException._2();
                String message = string;
                Option<Throwable> cause = option;
                nothing$ = process.exit(message, cause, process.exit$default$3());
            } else if (throwable2 != null) {
                Throwable e = throwable2;
                nothing$ = process.exit("Oops, cannot start the server.", (Option<Throwable>)Some$.MODULE$.apply((Object)e), process.exit$default$3());
            } else {
                throw throwable;
            }
            throw nothing$;
        }
        return server;
    }

    public ServerConfig readServerConfigSettings(ServerProcess process) {
        Option rootDirArg = process.args().headOption().map((Function1 & Serializable)_$4 -> new File((String)_$4));
        Map rootDirConfig = (Map)rootDirArg.fold(ProdServerStart$::$anonfun$2, (Function1 & Serializable)_$5 -> ServerConfig$.MODULE$.rootDirConfig((File)_$5));
        Configuration configuration = Configuration$.MODULE$.load(process.classLoader(), process.properties(), rootDirConfig, true);
        String path = (String)configuration.getOptional("play.server.dir", ConfigLoader$.MODULE$.stringLoader()).getOrElse(ProdServerStart$::$anonfun$4);
        File file = new File(path);
        if (!file.isDirectory()) {
            throw ServerStartException$.MODULE$.apply("Bad root server path: " + path, ServerStartException$.MODULE$.$lessinit$greater$default$2());
        }
        File rootDir = file;
        Option httpPort = this.parsePort$1(configuration, "http");
        Option httpsPort = this.parsePort$1(configuration, "https");
        String address = (String)configuration.getOptional("play.server.http.address", ConfigLoader$.MODULE$.stringLoader()).getOrElse(ProdServerStart$::$anonfun$5);
        if (httpPort.orElse(() -> ProdServerStart$.readServerConfigSettings$$anonfun$1(httpsPort)).isEmpty()) {
            throw ServerStartException$.MODULE$.apply("Must provide either an HTTP or HTTPS port", ServerStartException$.MODULE$.$lessinit$greater$default$2());
        }
        return ServerConfig$.MODULE$.apply(rootDir, (Option<Object>)httpPort, (Option<Object>)httpsPort, address, (Mode)Mode.Prod$.MODULE$, process.properties(), configuration);
    }

    public Option<File> createPidFile(ServerProcess process, Configuration configuration) {
        OutputStream outputStream;
        String pidFilePath;
        String string = pidFilePath = (String)configuration.getOptional("play.server.pidfile.path", ConfigLoader$.MODULE$.stringLoader()).getOrElse(ProdServerStart$::$anonfun$6);
        String string2 = "/dev/null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        File pidFile = new File(pidFilePath).getAbsoluteFile();
        String pid = (String)process.pid().getOrElse(ProdServerStart$::$anonfun$7);
        try {
            outputStream = Files.newOutputStream(pidFile.toPath(), StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw ServerStartException$.MODULE$.apply("This application is already running (or delete " + pidFile.getPath() + " file).", ServerStartException$.MODULE$.$lessinit$greater$default$2());
        }
        try (OutputStream out = outputStream;){
            out.write(pid.getBytes());
        }
        return Some$.MODULE$.apply((Object)pidFile);
    }

    private static final void start$$anonfun$2(Application application$1, Server server$1) {
        if (application$1.coordinatedShutdown().shutdownReason().isEmpty()) {
            server$1.stop();
            return;
        }
    }

    private static final Map $anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final String $anonfun$4() {
        throw ServerStartException$.MODULE$.apply("No root server path supplied", ServerStartException$.MODULE$.$lessinit$greater$default$2());
    }

    private final Option parsePort$1(Configuration configuration$1, String portType) {
        return configuration$1.getOptional("play.server." + portType + ".port", ConfigLoader$.MODULE$.stringLoader()).filter((Function1 & Serializable)_$6 -> {
            String string = _$6;
            String string2 = "disabled";
            return string == null ? string2 != null : !string.equals(string2);
        }).map((Function1 & Serializable)str -> {
            int n;
            try {
                n = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerStartException$.MODULE$.apply("Invalid " + portType.toUpperCase() + " port: " + str, ServerStartException$.MODULE$.$lessinit$greater$default$2());
            }
            return n;
        });
    }

    private static final String $anonfun$5() {
        return "0.0.0.0";
    }

    private static final Option readServerConfigSettings$$anonfun$1(Option httpsPort$1) {
        return httpsPort$1;
    }

    private static final String $anonfun$6() {
        throw ServerStartException$.MODULE$.apply("Pid file path not configured", ServerStartException$.MODULE$.$lessinit$greater$default$2());
    }

    private static final String $anonfun$7() {
        throw ServerStartException$.MODULE$.apply("Couldn't determine current process's pid", ServerStartException$.MODULE$.$lessinit$greater$default$2());
    }
}

