/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pekko.stream.javadsl.FileIO;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.stream.javadsl.StreamConverters;
import org.apache.pekko.util.ByteString;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.SourceBodyWritable;

public interface DefaultBodyWritables {
    default public BodyWritable<ByteString> body(String string) {
        return this.body(string, "text/plain");
    }

    default public BodyWritable<ByteString> body(String string, String string2) {
        return new InMemoryBodyWritable(ByteString.fromString((String)string), string2);
    }

    default public BodyWritable<ByteString> body(byte[] byArray) {
        return this.body(byArray, "application/octet-stream");
    }

    default public BodyWritable<ByteString> body(byte[] byArray, String string) {
        return new InMemoryBodyWritable(ByteString.fromArray((byte[])byArray), string);
    }

    default public BodyWritable<ByteString> body(ByteBuffer byteBuffer) {
        return this.body(byteBuffer, "application/octet-stream");
    }

    default public BodyWritable<ByteString> body(ByteBuffer byteBuffer, String string) {
        return new InMemoryBodyWritable(ByteString.fromByteBuffer((ByteBuffer)byteBuffer), string);
    }

    default public BodyWritable<Source<ByteString, ?>> body(Source<ByteString, ?> source) {
        return new SourceBodyWritable(source);
    }

    default public BodyWritable<Source<ByteString, ?>> body(File file) {
        return new SourceBodyWritable(FileIO.fromPath((Path)file.toPath()));
    }

    default public BodyWritable<ByteString> body(Map<String, String> map) {
        try {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>(map.size());
            for (Map.Entry<String, String> byteString2 : map.entrySet()) {
                String string = URLEncoder.encode(byteString2.getKey(), "UTF-8");
                String string2 = URLEncoder.encode(byteString2.getValue(), "UTF-8");
                arrayList.add((CallSite)((Object)(string + "=" + string2)));
            }
            String string = String.join((CharSequence)"&", arrayList);
            ByteString byteString = ByteString.fromString((String)string);
            return new InMemoryBodyWritable(byteString, "application/x-www-form-urlencoded");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    default public BodyWritable<Source<ByteString, ?>> body(Supplier<InputStream> supplier) {
        return new SourceBodyWritable(StreamConverters.fromInputStream(supplier::get));
    }
}

