/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.sslconfig.ssl.SSLConfigParser;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.EnrichedConfig$;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.WSClientConfig$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@Singleton
public class WSConfigParser
implements Provider<WSClientConfig> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WSConfigParser.class.getDeclaredField("get$lzy1"));
    private final Config config;
    private final ClassLoader classLoader;
    private volatile Object get$lzy1;

    @Inject
    public WSConfigParser(Config config, ClassLoader classLoader) {
        this.config = config;
        this.classLoader = classLoader;
    }

    public WSClientConfig parse() {
        None$ none$;
        Config wsConfig = this.config.getConfig("play.ws");
        Duration connectionTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.connection"));
        Duration idleTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.idle"));
        Duration requestTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.request"));
        boolean followRedirects = wsConfig.getBoolean("followRedirects");
        boolean useProxyProperties = wsConfig.getBoolean("useProxyProperties");
        try {
            none$ = Some$.MODULE$.apply((Object)wsConfig.getString("useragent"));
        }
        catch (ConfigException.Null e) {
            none$ = None$.MODULE$;
        }
        None$ userAgent = none$;
        boolean compressionEnabled = wsConfig.getBoolean("compressionEnabled");
        SSLConfigSettings sslConfig = new SSLConfigParser(EnrichedConfig$.MODULE$.apply(wsConfig.getConfig("ssl")), this.classLoader).parse();
        return WSClientConfig$.MODULE$.apply(connectionTimeout, idleTimeout, requestTimeout, followRedirects, useProxyProperties, (Option<String>)userAgent, compressionEnabled, sslConfig);
    }

    public WSClientConfig get() {
        Object object = this.get$lzy1;
        if (object instanceof WSClientConfig) {
            return (WSClientConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (WSClientConfig)this.get$lzyINIT1();
    }

    private Object get$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.get$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    WSClientConfig wSClientConfig = null;
                    try {
                        wSClientConfig = this.parse();
                        object2 = wSClientConfig == null ? LazyVals.NullValue$.MODULE$ : wSClientConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return wSClientConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

