/*
 * Decompiled with CFR 0.152.
 */
package play.libs.crypto;

import javax.inject.Inject;
import javax.inject.Singleton;
import play.libs.crypto.CSRFTokenSigner;
import scala.Option;

@Singleton
public class DefaultCSRFTokenSigner
implements CSRFTokenSigner {
    private final play.api.libs.crypto.CSRFTokenSigner csrfTokenSigner;

    @Inject
    public DefaultCSRFTokenSigner(play.api.libs.crypto.CSRFTokenSigner cSRFTokenSigner) {
        this.csrfTokenSigner = cSRFTokenSigner;
    }

    @Override
    public String signToken(String string) {
        return this.csrfTokenSigner.signToken(string);
    }

    @Override
    public String extractSignedToken(String string) {
        Option<String> option = this.csrfTokenSigner.extractSignedToken(string);
        if (option.isDefined()) {
            return (String)option.get();
        }
        return null;
    }

    @Override
    public String generateToken() {
        return this.csrfTokenSigner.generateToken();
    }

    @Override
    public String generateSignedToken() {
        return this.csrfTokenSigner.generateSignedToken();
    }

    @Override
    public boolean compareSignedTokens(String string, String string2) {
        return this.csrfTokenSigner.compareSignedTokens(string, string2);
    }

    @Override
    public play.api.libs.crypto.CSRFTokenSigner asScala() {
        return this.csrfTokenSigner;
    }
}

