/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.validation;

import java.io.Serializable;
import play.api.data.validation.Constraint;
import play.api.data.validation.Constraint$;
import play.api.data.validation.Invalid$;
import play.api.data.validation.Valid$;
import play.api.data.validation.ValidationError$;
import play.api.data.validation.ValidationResult;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public interface Constraints {
    public static void $init$(Constraints $this) {
        $this.play$api$data$validation$Constraints$_setter_$play$api$data$validation$Constraints$$emailRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[a-zA-Z0-9\\.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$")));
    }

    public Regex play$api$data$validation$Constraints$$emailRegex();

    public void play$api$data$validation$Constraints$_setter_$play$api$data$validation$Constraints$$emailRegex_$eq(Regex var1);

    public static Constraint emailAddress$(Constraints $this, String errorMessage) {
        return $this.emailAddress(errorMessage);
    }

    default public Constraint<String> emailAddress(String errorMessage) {
        return Constraint$.MODULE$.apply("constraint.email", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), (Function1 & Serializable)e -> {
            if (e == null) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            }
            if (e.trim().isEmpty()) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            }
            return (ValidationResult)this.play$api$data$validation$Constraints$$emailRegex().findFirstMatchIn((CharSequence)e).map((Function1 & Serializable)_$1 -> Valid$.MODULE$).getOrElse(() -> Constraints.emailAddress$$anonfun$1$$anonfun$2(errorMessage));
        });
    }

    public static String emailAddress$default$1$(Constraints $this) {
        return $this.emailAddress$default$1();
    }

    default public String emailAddress$default$1() {
        return "error.email";
    }

    public static Constraint emailAddress$(Constraints $this) {
        return $this.emailAddress();
    }

    default public Constraint<String> emailAddress() {
        return this.emailAddress(this.emailAddress$default$1());
    }

    public static Constraint nonEmpty$(Constraints $this, String errorMessage) {
        return $this.nonEmpty(errorMessage);
    }

    default public Constraint<String> nonEmpty(String errorMessage) {
        return Constraint$.MODULE$.apply("constraint.required", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), (Function1 & Serializable)o -> {
            if (o == null) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            }
            return o.trim().isEmpty() ? Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))) : Valid$.MODULE$;
        });
    }

    public static String nonEmpty$default$1$(Constraints $this) {
        return $this.nonEmpty$default$1();
    }

    default public String nonEmpty$default$1() {
        return "error.required";
    }

    public static Constraint nonEmpty$(Constraints $this) {
        return $this.nonEmpty();
    }

    default public Constraint<String> nonEmpty() {
        return this.nonEmpty(this.nonEmpty$default$1());
    }

    public static Constraint min$(Constraints $this, Object minValue, boolean strict, String errorMessage, String strictErrorMessage, Ordering ordering) {
        return $this.min(minValue, strict, errorMessage, strictErrorMessage, ordering);
    }

    default public <T> Constraint<T> min(T minValue, boolean strict, String errorMessage, String strictErrorMessage, Ordering<T> ordering) {
        return Constraint$.MODULE$.apply("constraint.min", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minValue}), (Function1 & Serializable)o -> {
            ValidationResult validationResult;
            int n;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(new RichInt(Predef$.MODULE$.intWrapper(ordering.compare(o, minValue))).sign(), (Object)BoxesRunTime.boxToBoolean((boolean)strict));
            if (tuple2 != null && (1 == (n = tuple2._1$mcI$sp()) || 0 == n && !tuple2._2$mcZ$sp())) {
                validationResult = Valid$.MODULE$;
                return validationResult;
            } else {
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                boolean bl = tuple2._2$mcZ$sp();
                if (!bl) {
                    validationResult = Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minValue})));
                    return validationResult;
                } else {
                    if (!bl) throw new MatchError((Object)tuple2);
                    validationResult = Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(strictErrorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minValue})));
                }
            }
            return validationResult;
        });
    }

    public static boolean min$default$2$(Constraints $this) {
        return $this.min$default$2();
    }

    default public boolean min$default$2() {
        return false;
    }

    public static String min$default$3$(Constraints $this) {
        return $this.min$default$3();
    }

    default public <T> String min$default$3() {
        return "error.min";
    }

    public static String min$default$4$(Constraints $this) {
        return $this.min$default$4();
    }

    default public <T> String min$default$4() {
        return "error.min.strict";
    }

    public static Constraint max$(Constraints $this, Object maxValue, boolean strict, String errorMessage, String strictErrorMessage, Ordering ordering) {
        return $this.max(maxValue, strict, errorMessage, strictErrorMessage, ordering);
    }

    default public <T> Constraint<T> max(T maxValue, boolean strict, String errorMessage, String strictErrorMessage, Ordering<T> ordering) {
        return Constraint$.MODULE$.apply("constraint.max", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxValue}), (Function1 & Serializable)o -> {
            ValidationResult validationResult;
            int n;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(new RichInt(Predef$.MODULE$.intWrapper(ordering.compare(o, maxValue))).sign(), (Object)BoxesRunTime.boxToBoolean((boolean)strict));
            if (tuple2 != null && (-1 == (n = tuple2._1$mcI$sp()) || 0 == n && !tuple2._2$mcZ$sp())) {
                validationResult = Valid$.MODULE$;
                return validationResult;
            } else {
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                boolean bl = tuple2._2$mcZ$sp();
                if (!bl) {
                    validationResult = Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxValue})));
                    return validationResult;
                } else {
                    if (!bl) throw new MatchError((Object)tuple2);
                    validationResult = Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(strictErrorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxValue})));
                }
            }
            return validationResult;
        });
    }

    public static boolean max$default$2$(Constraints $this) {
        return $this.max$default$2();
    }

    default public boolean max$default$2() {
        return false;
    }

    public static String max$default$3$(Constraints $this) {
        return $this.max$default$3();
    }

    default public <T> String max$default$3() {
        return "error.max";
    }

    public static String max$default$4$(Constraints $this) {
        return $this.max$default$4();
    }

    default public <T> String max$default$4() {
        return "error.max.strict";
    }

    public static Constraint minLength$(Constraints $this, int length, String errorMessage) {
        return $this.minLength(length, errorMessage);
    }

    default public Constraint<String> minLength(int length, String errorMessage) {
        return Constraint$.MODULE$.apply("constraint.minLength", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}), (Function1 & Serializable)o -> {
            Predef$.MODULE$.require(length >= 0, Constraints::minLength$$anonfun$1$$anonfun$1);
            if (o == null) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})));
            }
            return StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(o)) >= length ? Valid$.MODULE$ : Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})));
        });
    }

    public static String minLength$default$2$(Constraints $this) {
        return $this.minLength$default$2();
    }

    default public String minLength$default$2() {
        return "error.minLength";
    }

    public static Constraint maxLength$(Constraints $this, int length, String errorMessage) {
        return $this.maxLength(length, errorMessage);
    }

    default public Constraint<String> maxLength(int length, String errorMessage) {
        return Constraint$.MODULE$.apply("constraint.maxLength", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}), (Function1 & Serializable)o -> {
            Predef$.MODULE$.require(length >= 0, Constraints::maxLength$$anonfun$1$$anonfun$1);
            if (o == null) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})));
            }
            return StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(o)) <= length ? Valid$.MODULE$ : Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})));
        });
    }

    public static String maxLength$default$2$(Constraints $this) {
        return $this.maxLength$default$2();
    }

    default public String maxLength$default$2() {
        return "error.maxLength";
    }

    public static Constraint pattern$(Constraints $this, Function0 regex, String name, String error2) {
        return $this.pattern((Function0<Regex>)regex, name, error2);
    }

    default public Constraint<String> pattern(Function0<Regex> regex, String name, String error2) {
        return Constraint$.MODULE$.apply(name, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{regex}), (Function1 & Serializable)o -> {
            Predef$.MODULE$.require(regex.apply() != null, Constraints::pattern$$anonfun$1$$anonfun$1);
            Predef$.MODULE$.require(name != null, Constraints::pattern$$anonfun$1$$anonfun$2);
            Predef$.MODULE$.require(error2 != null, Constraints::pattern$$anonfun$1$$anonfun$3);
            if (o == null) {
                return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(error2, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{regex.apply()})));
            }
            return (ValidationResult)((Regex)regex.apply()).unapplySeq((CharSequence)o).map((Function1 & Serializable)_$2 -> Valid$.MODULE$).getOrElse(() -> Constraints.pattern$$anonfun$1$$anonfun$5(error2, regex));
        });
    }

    public static String pattern$default$2$(Constraints $this) {
        return $this.pattern$default$2();
    }

    default public String pattern$default$2() {
        return "constraint.pattern";
    }

    public static String pattern$default$3$(Constraints $this) {
        return $this.pattern$default$3();
    }

    default public String pattern$default$3() {
        return "error.pattern";
    }

    private static ValidationResult emailAddress$$anonfun$1$$anonfun$2(String errorMessage$2) {
        return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(errorMessage$2, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private static Object minLength$$anonfun$1$$anonfun$1() {
        return "string minLength must not be negative";
    }

    private static Object maxLength$$anonfun$1$$anonfun$1() {
        return "string maxLength must not be negative";
    }

    private static Object pattern$$anonfun$1$$anonfun$1() {
        return "regex must not be null";
    }

    private static Object pattern$$anonfun$1$$anonfun$2() {
        return "name must not be null";
    }

    private static Object pattern$$anonfun$1$$anonfun$3() {
        return "error must not be null";
    }

    private static ValidationResult pattern$$anonfun$1$$anonfun$5(String error$2, Function0 regex$2) {
        return Invalid$.MODULE$.apply(ValidationError$.MODULE$.apply(error$2, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{regex$2.apply()})));
    }
}

