/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.HttpChunk;
import play.api.http.HttpChunk$Chunk$;
import play.api.http.HttpEntity$;
import play.api.http.HttpEntity$Chunked$;
import play.api.http.HttpEntity$Streamed$;
import play.api.http.HttpEntity$Strict$;
import play.http.HttpEntity;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface HttpEntity {
    public static Strict NoEntity() {
        return HttpEntity$.MODULE$.NoEntity();
    }

    public static int ordinal(HttpEntity httpEntity) {
        return HttpEntity$.MODULE$.ordinal(httpEntity);
    }

    public Option<String> contentType();

    public boolean isKnownEmpty();

    public Option<Object> contentLength();

    public Source<ByteString, ?> dataStream();

    public static Future consumeData$(HttpEntity $this, Materializer mat) {
        return $this.consumeData(mat);
    }

    default public Future<ByteString> consumeData(Materializer mat) {
        return this.dataStream().runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(_$1, _$2) -> _$1.$plus$plus(_$2), mat);
    }

    public play.http.HttpEntity asJava();

    public HttpEntity as(String var1);

    public static final class Chunked
    implements HttpEntity,
    Product,
    Serializable {
        private final Source chunks;
        private final Option contentType;

        public static Chunked apply(Source<HttpChunk, ?> source, Option<String> option) {
            return HttpEntity$Chunked$.MODULE$.apply(source, option);
        }

        public static Chunked fromProduct(Product product) {
            return HttpEntity$Chunked$.MODULE$.fromProduct(product);
        }

        public static Chunked unapply(Chunked chunked) {
            return HttpEntity$Chunked$.MODULE$.unapply(chunked);
        }

        public Chunked(Source<HttpChunk, ?> chunks, Option<String> contentType) {
            this.chunks = chunks;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Chunked)) return false;
            Chunked chunked = (Chunked)object;
            Source<HttpChunk, ?> source = this.chunks();
            Source<HttpChunk, ?> source2 = chunked.chunks();
            if (source == null) {
                if (source2 != null) {
                    return false;
                }
            } else if (!source.equals(source2)) return false;
            Option<String> option = this.contentType();
            Option<String> option2 = chunked.contentType();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunked;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Chunked";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "chunks";
            }
            if (1 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Source<HttpChunk, ?> chunks() {
            return this.chunks;
        }

        @Override
        public Option<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return false;
        }

        @Override
        public Option<Object> contentLength() {
            return None$.MODULE$;
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            return (Source)this.chunks().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(HttpChunk x) {
                    HttpChunk httpChunk = x;
                    if (httpChunk instanceof HttpChunk.Chunk) {
                        ByteString byteString;
                        HttpChunk.Chunk chunk = HttpChunk$Chunk$.MODULE$.unapply((HttpChunk.Chunk)httpChunk);
                        ByteString data = byteString = chunk._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(HttpChunk x, Function1 function1) {
                    HttpChunk httpChunk = x;
                    if (httpChunk instanceof HttpChunk.Chunk) {
                        ByteString byteString;
                        HttpChunk.Chunk chunk = HttpChunk$Chunk$.MODULE$.unapply((HttpChunk.Chunk)httpChunk);
                        ByteString data = byteString = chunk._1();
                        return data;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        @Override
        public play.http.HttpEntity asJava() {
            Option option = OptionConverters$.MODULE$.RichOption(this.contentType());
            return new HttpEntity.Chunked(this.chunks().asJava(), OptionConverters.RichOption$.MODULE$.toJava$extension(option));
        }

        @Override
        public HttpEntity as(String contentType) {
            Option option = Option$.MODULE$.apply((Object)contentType);
            Source<HttpChunk, ?> source = this.copy$default$1();
            return this.copy(source, (Option<String>)option);
        }

        public Chunked copy(Source<HttpChunk, ?> chunks, Option<String> contentType) {
            return new Chunked(chunks, contentType);
        }

        public Source<HttpChunk, ?> copy$default$1() {
            return this.chunks();
        }

        public Option<String> copy$default$2() {
            return this.contentType();
        }

        public Source<HttpChunk, ?> _1() {
            return this.chunks();
        }

        public Option<String> _2() {
            return this.contentType();
        }
    }

    public static final class Streamed
    implements HttpEntity,
    Product,
    Serializable {
        private final Source data;
        private final Option contentLength;
        private final Option contentType;

        public static Streamed apply(Source<ByteString, ?> source, Option<Object> option, Option<String> option2) {
            return HttpEntity$Streamed$.MODULE$.apply(source, option, option2);
        }

        public static Streamed fromProduct(Product product) {
            return HttpEntity$Streamed$.MODULE$.fromProduct(product);
        }

        public static Streamed unapply(Streamed streamed) {
            return HttpEntity$Streamed$.MODULE$.unapply(streamed);
        }

        public Streamed(Source<ByteString, ?> data, Option<Object> contentLength, Option<String> contentType) {
            this.data = data;
            this.contentLength = contentLength;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Streamed)) return false;
            Streamed streamed = (Streamed)object;
            Source<ByteString, ?> source = this.data();
            Source<ByteString, ?> source2 = streamed.data();
            if (source == null) {
                if (source2 != null) {
                    return false;
                }
            } else if (!source.equals(source2)) return false;
            Option<Object> option = this.contentLength();
            Option<Object> option2 = streamed.contentLength();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.contentType();
            Option<String> option4 = streamed.contentType();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Streamed;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Streamed";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "data";
                }
                case 1: {
                    return "contentLength";
                }
                case 2: {
                    return "contentType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Source<ByteString, ?> data() {
            return this.data;
        }

        @Override
        public Option<Object> contentLength() {
            return this.contentLength;
        }

        @Override
        public Option<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return false;
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            return this.data();
        }

        @Override
        public play.http.HttpEntity asJava() {
            Option option = OptionConverters$.MODULE$.RichOption(this.contentLength());
            Option option2 = OptionConverters$.MODULE$.RichOption(this.contentType());
            return new HttpEntity.Streamed(this.data().asJava(), OptionConverters.RichOption$.MODULE$.toJava$extension(option), OptionConverters.RichOption$.MODULE$.toJava$extension(option2));
        }

        @Override
        public HttpEntity as(String contentType) {
            Option option = Option$.MODULE$.apply((Object)contentType);
            Source<ByteString, ?> source = this.copy$default$1();
            Option<Object> option2 = this.copy$default$2();
            return this.copy(source, option2, (Option<String>)option);
        }

        public Streamed copy(Source<ByteString, ?> data, Option<Object> contentLength, Option<String> contentType) {
            return new Streamed(data, contentLength, contentType);
        }

        public Source<ByteString, ?> copy$default$1() {
            return this.data();
        }

        public Option<Object> copy$default$2() {
            return this.contentLength();
        }

        public Option<String> copy$default$3() {
            return this.contentType();
        }

        public Source<ByteString, ?> _1() {
            return this.data();
        }

        public Option<Object> _2() {
            return this.contentLength();
        }

        public Option<String> _3() {
            return this.contentType();
        }
    }

    public static final class Strict
    implements HttpEntity,
    Product,
    Serializable {
        private final ByteString data;
        private final Option contentType;

        public static Strict apply(ByteString byteString, Option<String> option) {
            return HttpEntity$Strict$.MODULE$.apply(byteString, option);
        }

        public static Strict fromProduct(Product product) {
            return HttpEntity$Strict$.MODULE$.fromProduct(product);
        }

        public static Strict unapply(Strict strict) {
            return HttpEntity$Strict$.MODULE$.unapply(strict);
        }

        public Strict(ByteString data, Option<String> contentType) {
            this.data = data;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Strict)) return false;
            Strict strict = (Strict)object;
            ByteString byteString = this.data();
            ByteString byteString2 = strict.data();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            Option<String> option = this.contentType();
            Option<String> option2 = strict.contentType();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Strict;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Strict";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString data() {
            return this.data;
        }

        @Override
        public Option<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return this.data().isEmpty();
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(this.data().size())));
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            if (this.data().isEmpty()) {
                return Source$.MODULE$.empty();
            }
            return Source$.MODULE$.single((Object)this.data());
        }

        @Override
        public Future<ByteString> consumeData(Materializer mat) {
            return Future$.MODULE$.successful((Object)this.data());
        }

        @Override
        public play.http.HttpEntity asJava() {
            Option option = OptionConverters$.MODULE$.RichOption(this.contentType());
            return new HttpEntity.Strict(this.data(), OptionConverters.RichOption$.MODULE$.toJava$extension(option));
        }

        @Override
        public HttpEntity as(String contentType) {
            Option option = Option$.MODULE$.apply((Object)contentType);
            ByteString byteString = this.copy$default$1();
            return this.copy(byteString, (Option<String>)option);
        }

        public Strict copy(ByteString data, Option<String> contentType) {
            return new Strict(data, contentType);
        }

        public ByteString copy$default$1() {
            return this.data();
        }

        public Option<String> copy$default$2() {
            return this.contentType();
        }

        public ByteString _1() {
            return this.data();
        }

        public Option<String> _2() {
            return this.contentType();
        }
    }
}

