/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AssetEncoding;
import controllers.AssetEncoding$;
import controllers.AssetsConfiguration;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class AssetsConfiguration$
implements Mirror.Product,
Serializable {
    private static final Logger logger;
    public static final AssetsConfiguration$ MODULE$;

    private AssetsConfiguration$() {
    }

    static {
        MODULE$ = new AssetsConfiguration$();
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AssetsConfiguration$.class);
    }

    public AssetsConfiguration apply(String path, String urlPrefix, String defaultCharSet, boolean enableCaching, boolean enableCacheControl, Map<String, Option<String>> configuredCacheControl, String defaultCacheControl, String aggressiveCacheControl, String digestAlgorithm, boolean checkForMinified, Set<String> textContentTypes, Seq<AssetEncoding> encodings) {
        return new AssetsConfiguration(path, urlPrefix, defaultCharSet, enableCaching, enableCacheControl, configuredCacheControl, defaultCacheControl, aggressiveCacheControl, digestAlgorithm, checkForMinified, textContentTypes, encodings);
    }

    public AssetsConfiguration unapply(AssetsConfiguration x$1) {
        return x$1;
    }

    public String $lessinit$greater$default$1() {
        return "/public";
    }

    public String $lessinit$greater$default$2() {
        return "/assets";
    }

    public String $lessinit$greater$default$3() {
        return "utf-8";
    }

    public boolean $lessinit$greater$default$4() {
        return true;
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public Map<String, Option<String>> $lessinit$greater$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public String $lessinit$greater$default$7() {
        return "public, max-age=3600";
    }

    public String $lessinit$greater$default$8() {
        return "public, max-age=31536000, immutable";
    }

    public String $lessinit$greater$default$9() {
        return "md5";
    }

    public boolean $lessinit$greater$default$10() {
        return true;
    }

    public Set<String> $lessinit$greater$default$11() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application/json", "application/javascript"}));
    }

    public Seq<AssetEncoding> $lessinit$greater$default$12() {
        return (Seq)((SeqOps)new .colon.colon((Object)AssetEncoding$.MODULE$.Brotli(), (List)new .colon.colon((Object)AssetEncoding$.MODULE$.Gzip(), (List)new .colon.colon((Object)AssetEncoding$.MODULE$.Xz(), (List)new .colon.colon((Object)AssetEncoding$.MODULE$.Bzip2(), (List)Nil$.MODULE$)))));
    }

    public AssetsConfiguration fromConfiguration(Configuration c, Mode mode) {
        Mode mode2 = mode;
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        Mode mode3 = mode;
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        AssetsConfiguration assetsConfiguration = this.apply((String)c.get("play.assets.path", ConfigLoader$.MODULE$.stringLoader()), (String)c.get("play.assets.urlPrefix", ConfigLoader$.MODULE$.stringLoader()), (String)c.getDeprecated("play.assets.default.charset", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default.charset"}), ConfigLoader$.MODULE$.stringLoader()), mode2 == null ? dev$ != null : !mode2.equals(dev$), !(mode3 != null ? !mode3.equals(prod$) : prod$ != null), (Map<String, Option<String>>)((Map)c.getOptional("play.assets.cache", ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).getOrElse(AssetsConfiguration$::$anonfun$2)), (String)c.getDeprecated("play.assets.defaultCache", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assets.defaultCache"}), ConfigLoader$.MODULE$.stringLoader()), (String)c.getDeprecated("play.assets.aggressiveCache", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assets.aggressiveCache"}), ConfigLoader$.MODULE$.stringLoader()), (String)c.getDeprecated("play.assets.digest.algorithm", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assets.digest.algorithm"}), ConfigLoader$.MODULE$.stringLoader()), BoxesRunTime.unboxToBoolean((Object)((Option)c.getDeprecated("play.assets.checkForMinified", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assets.checkForMinified"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.booleanLoader()))).getOrElse(() -> AssetsConfiguration$.$anonfun$3(mode))), (Set<String>)((IterableOnceOps)c.get("play.assets.textContentTypes", ConfigLoader$.MODULE$.seqStringLoader())).toSet(), this.getAssetEncodings(c));
        this.logAssetsConfiguration(assetsConfiguration);
        return assetsConfiguration;
    }

    public Mode fromConfiguration$default$2() {
        return Mode.Test$.MODULE$;
    }

    private void logAssetsConfiguration(AssetsConfiguration assetsConfiguration) {
        StringBuffer msg = new StringBuffer();
        msg.append("Using the following cache configuration for assets:\n");
        msg.append("\t enableCaching = " + assetsConfiguration.enableCaching() + "\n");
        msg.append("\t enableCacheControl = " + assetsConfiguration.enableCacheControl() + "\n");
        msg.append("\t defaultCacheControl = " + assetsConfiguration.defaultCacheControl() + "\n");
        msg.append("\t aggressiveCacheControl = " + assetsConfiguration.aggressiveCacheControl() + "\n");
        msg.append("\t configuredCacheControl:");
        msg.append(((IterableOnceOps)assetsConfiguration.configuredCacheControl().map((Function1 & Serializable)c -> "\t\t " + c._1() + " = " + c._2())).mkString("\n", "\n", "\n"));
        logger.debug(() -> AssetsConfiguration$.logAssetsConfiguration$$anonfun$2(msg), MarkerContext$.MODULE$.NoMarker());
    }

    private Seq<AssetEncoding> getAssetEncodings(Configuration c) {
        return (Seq)((IterableOps)c.get("play.assets.encodings", ConfigLoader$.MODULE$.seqConfigurationLoader())).map((Function1 & Serializable)configs -> AssetEncoding$.MODULE$.apply((String)configs.get("accept", ConfigLoader$.MODULE$.stringLoader()), (String)configs.get("extension", ConfigLoader$.MODULE$.stringLoader())));
    }

    public AssetsConfiguration fromProduct(Product x$0) {
        return new AssetsConfiguration((String)x$0.productElement(0), (String)x$0.productElement(1), (String)x$0.productElement(2), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(3)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(4)), (Map<String, Option<String>>)((Map)x$0.productElement(5)), (String)x$0.productElement(6), (String)x$0.productElement(7), (String)x$0.productElement(8), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(9)), (Set<String>)((Set)x$0.productElement(10)), (Seq<AssetEncoding>)((Seq)x$0.productElement(11)));
    }

    private static final Map $anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final boolean $anonfun$3(Mode mode$1) {
        Mode mode = mode$1;
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        return mode == null ? dev$ != null : !mode.equals(dev$);
    }

    private static final String logAssetsConfiguration$$anonfun$2(StringBuffer msg$1) {
        return msg$1.toString();
    }
}

