/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.LoggerConfigurator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class LoggerConfigurator$
implements Serializable {
    public static final LoggerConfigurator$ MODULE$ = new LoggerConfigurator$();

    private LoggerConfigurator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LoggerConfigurator$.class);
    }

    public Option<LoggerConfigurator> apply(ClassLoader classLoader) {
        return this.findFromResources(classLoader).flatMap((Function1 & Serializable)className -> MODULE$.apply((String)className, classLoader));
    }

    public Map<String, String> generateProperties(Environment env, Configuration config, Map<String, String> optionalProperties) {
        HashMap mutableMap = new HashMap();
        mutableMap.put((Object)"application.home", (Object)env.rootPath().getAbsolutePath());
        if (config.getOptional("play.logger.includeConfigProperties", ConfigLoader$.MODULE$.booleanLoader()).contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Set entrySet = CollectionConverters$.MODULE$.SetHasAsScala(config.underlying().entrySet()).asScala();
            entrySet.foreach((Function1 & Serializable)entry -> {
                ConfigValue value = (ConfigValue)entry.getValue();
                ConfigValueType configValueType = value.valueType();
                ConfigValueType configValueType2 = ConfigValueType.STRING;
                ConfigValueType configValueType3 = configValueType;
                if (!(configValueType2 != null ? !configValueType2.equals(configValueType3) : configValueType3 != null)) {
                    return mutableMap.put(entry.getKey(), (Object)((String)value.unwrapped()));
                }
                return mutableMap.put(entry.getKey(), (Object)value.render());
            });
        }
        return mutableMap.$plus$plus(optionalProperties).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<LoggerConfigurator> apply(String loggerConfiguratorClassName, ClassLoader classLoader) {
        Some some;
        try {
            Class<?> loggerConfiguratorClass = classLoader.loadClass(loggerConfiguratorClassName);
            some = Some$.MODULE$.apply((Object)((LoggerConfigurator)loggerConfiguratorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (Exception ex) {
            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |Play cannot load \"" + loggerConfiguratorClassName + "\". Please make sure you have logback (or another module\n             |that implements play.api.LoggerConfigurator) in your classpath.\n             "));
            System.err.println(msg);
            ex.printStackTrace();
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<String> findFromResources(ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream("logger-configurator.properties");
        if (in != null) {
            None$ none$;
            try {
                try {
                    Properties props = new Properties();
                    props.load(in);
                    none$ = Option$.MODULE$.apply((Object)props.getProperty("play.logger.configurator"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    none$ = None$.MODULE$;
                }
            }
            finally {
                in.close();
            }
            return none$;
        }
        return None$.MODULE$;
    }
}

