/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.options;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import io.github.classgraph.ClassGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.initializedfields.qual.InitializedFieldsBottom;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.plumelib.options.Option;
import org.plumelib.options.Options;

public class OptionsDoclet {
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String lineSep = System.lineSeparator();
    private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String USAGE = String.join((CharSequence)System.lineSeparator(), "Provided by Options doclet:", "-docfile <file>        Specify file into which options documentation is inserted", "-outfile <file>        Specify destination for resulting output", "-d <directory>         Destination directory for -outfile", "-i                     Edit the docfile in-place", "-format javadoc        Format output as a Javadoc comment", "-classdoc              Include 'main' class documentation in output", "-singledash            Use single dashes for long options (see org.plumelib.options.Options)", "See the OptionsDoclet documentation for more details.");
    private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String LIST_HELP = "<code>[+]</code> means option can be specified multiple times";
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String startDelim = "<!-- start options doc (DO NOT EDIT BY HAND) -->";
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String endDelim = "<!-- end options doc -->";
    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) File docFile = null;
    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) File outFile = null;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean inPlace = false;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean formatJavadoc = false;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean includeClassDoc = false;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) RootDoc root;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Options options;

    public OptionsDoclet(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) RootDoc root, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Options options) {
        this.root = root;
        this.options = options;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean start(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) RootDoc root) {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (ClassDoc doc : root.specifiedClasses()) {
            Class<?> clazz;
            if (doc.containingClass() != null) continue;
            try {
                @BinaryName String className = doc.qualifiedName();
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                for (URI uri : new ClassGraph().getClasspathURIs()) {
                    System.out.println(uri);
                }
                return false;
            }
            if (OptionsDoclet.needsInstantiation(clazz)) {
                try {
                    Constructor<?> c = clazz.getDeclaredConstructor(new Class[0]);
                    c.setAccessible(true);
                    objs.add(c.newInstance(new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            objs.add(clazz);
        }
        if (objs.isEmpty()) {
            System.out.println("Error: no classes found");
            return false;
        }
        Object[] objarray = objs.toArray();
        Options options = new Options(objarray);
        if (options.getOptions().size() < 1) {
            System.out.println("Error: no @Option-annotated fields found");
            return false;
        }
        OptionsDoclet o = new OptionsDoclet(root, options);
        String[] @MinLen(value=1) [] rootOptions = root.options();
        o.setOptions(rootOptions);
        o.processJavadoc();
        try {
            o.write();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int optionLength(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String option) {
        if (option.equals("-help")) {
            System.out.println(USAGE);
            return 1;
        }
        if (option.equals("-i") || option.equals("-classdoc") || option.equals("-singledash")) {
            return 1;
        }
        if (option.equals("-docfile") || option.equals("-outfile") || option.equals("-format") || option.equals("-d")) {
            return 2;
        }
        return 0;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean validOptions(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] options, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) DocErrorReporter reporter) {
        boolean hasDocFile = false;
        boolean hasOutFile = false;
        boolean hasDestDir = false;
        boolean hasFormat = false;
        boolean inPlace = false;
        String docFile = null;
        String outFile = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                if (hasDocFile) {
                    reporter.printError("-docfile option specified twice");
                    return false;
                }
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"docfile\")==2";
                docFile = os[1];
                File f = new File(docFile);
                if (!f.exists()) {
                    reporter.printError("-docfile file not found: " + docFile);
                    return false;
                }
                hasDocFile = true;
            }
            if (opt.equals("-outfile")) {
                if (hasOutFile) {
                    reporter.printError("-outfile option specified twice");
                    return false;
                }
                if (inPlace) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"outfile\")==2";
                outFile = os[1];
                hasOutFile = true;
            }
            if (opt.equals("-i")) {
                if (hasOutFile) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                inPlace = true;
            }
            if (opt.equals("-format")) {
                if (hasFormat) {
                    reporter.printError("-format option specified twice");
                    return false;
                }
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"format\")==2";
                String format = os[1];
                if (!format.equals("javadoc") && !format.equals("html")) {
                    reporter.printError("unrecognized output format: " + format);
                    return false;
                }
                hasFormat = true;
            }
            if (!opt.equals("-d")) continue;
            if (hasDestDir) {
                reporter.printError("-d specified twice");
                return false;
            }
            hasDestDir = true;
        }
        if (docFile != null && outFile != null && outFile.equals(docFile)) {
            reporter.printError("docfile must be different from outfile");
            return false;
        }
        if (inPlace && docFile == null) {
            reporter.printError("-i supplied but -docfile was not");
            return false;
        }
        return true;
    }

    public void setOptions(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] options) {
        String outFilename = null;
        File destDir = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"docfile\")==2";
                this.docFile = new File(os[1]);
                continue;
            }
            if (opt.equals("-d")) {
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"d\")==2";
                destDir = new File(os[1]);
                continue;
            }
            if (opt.equals("-outfile")) {
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"outfile\")==2";
                outFilename = os[1];
                continue;
            }
            if (opt.equals("-i")) {
                this.inPlace = true;
                continue;
            }
            if (opt.equals("-format")) {
                assert (os.length == 2) : "@AssumeAssertion(value): dependent: optionLength(\"format\")==2";
                if (!os[1].equals("javadoc")) continue;
                this.setFormatJavadoc(true);
                continue;
            }
            if (opt.equals("-classdoc")) {
                this.includeClassDoc = true;
                continue;
            }
            if (!opt.equals("-singledash")) continue;
            this.setUseSingleDash(true);
        }
        if (outFilename != null) {
            this.outFile = destDir != null ? new File(destDir, outFilename) : new File(outFilename);
        }
    }

    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean needsInstantiation(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Class<@UnknownFormat @FormatBottom @SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownInterned @InternedDistinct @LockPossiblyHeld @GuardedBy(value={}) @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownRegex @RegexBottom @SignatureUnknown @SignatureBottom @UnknownThis @UnknownThis @InitializedFields(value={}) @InitializedFieldsBottom ?> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Option.class) || Modifier.isStatic(f.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public void write() throws @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Exception {
        PrintWriter out;
        String output = this.output();
        if (this.outFile != null) {
            out = new PrintWriter(Files.newBufferedWriter(this.outFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        } else if (this.inPlace) {
            assert (this.docFile != null) : "@AssumeAssertion(nullness): dependent: docFile is non-null if inPlace is true";
            out = new PrintWriter(Files.newBufferedWriter(this.docFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        } else {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        }
        out.println(output);
        out.flush();
        out.close();
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String output() throws @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Exception {
        if (this.docFile == null) {
            if (this.formatJavadoc) {
                return this.optionsToJavadoc(0, 99);
            }
            return this.optionsToHtml(0);
        }
        return this.newDocFileText();
    }

    @RequiresNonNull(value={"docFile"})
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String newDocFileText() throws @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Exception {
        String docline;
        StringJoiner b = new StringJoiner(lineSep);
        BufferedReader doc = Files.newBufferedReader(this.docFile.toPath(), StandardCharsets.UTF_8);
        boolean replacing = false;
        boolean replacedOnce = false;
        while ((docline = doc.readLine()) != null) {
            if (replacing) {
                if (!docline.trim().equals(this.endDelim)) continue;
                replacing = false;
            }
            b.add(docline);
            if (replacedOnce || !docline.trim().equals(this.startDelim)) continue;
            if (this.formatJavadoc) {
                int starIndex = docline.indexOf(42);
                b.add(docline.substring(0, starIndex + 1));
                String jdoc = this.optionsToJavadoc(starIndex, 100);
                b.add(jdoc);
                if (jdoc.endsWith("</ul>")) {
                    b.add(docline.substring(0, starIndex + 1));
                }
            } else {
                b.add(this.optionsToHtml(0));
            }
            replacedOnce = true;
            replacing = true;
        }
        if (!replacedOnce) {
            System.err.println("Did not find start delimiter: " + this.startDelim);
        }
        doc.close();
        return b.toString();
    }

    public void processJavadoc() {
        for (Options.OptionInfo oi : this.options.getOptions()) {
            @BinaryName String className = oi.getDeclaringClass().getName();
            ClassDoc optDoc = this.root.classNamed(className);
            if (optDoc != null) {
                String nameWithUnderscores = oi.longName.replace('-', '_');
                for (FieldDoc fd : optDoc.fields()) {
                    if (!fd.name().equals(nameWithUnderscores)) continue;
                    if (fd.getRawCommentText().length() == 0) {
                        oi.jdoc = StringEscapeUtils.escapeHtml4((String)oi.description);
                        break;
                    }
                    if (this.formatJavadoc) {
                        oi.jdoc = fd.commentText();
                        break;
                    }
                    oi.jdoc = OptionsDoclet.javadocToHtml((Doc)fd);
                    break;
                }
            }
            if (!oi.baseType.isEnum()) continue;
            this.processEnumJavadoc(oi);
        }
    }

    private void processEnumJavadoc(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Options. @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) OptionInfo oi) {
        Enum[] constants = (Enum[])oi.baseType.getEnumConstants();
        if (constants == null) {
            return;
        }
        oi.enumJdoc = new LinkedHashMap<String, String>();
        for (Enum constant : constants) {
            assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
            oi.enumJdoc.put(constant.name(), "");
        }
        @BinaryName String className = oi.baseType.getName();
        ClassDoc enumDoc = this.root.classNamed(className);
        if (enumDoc == null) {
            return;
        }
        assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
        block1: for (String name : oi.enumJdoc.keySet()) {
            for (FieldDoc fd : enumDoc.fields()) {
                if (!fd.name().equals(name)) continue;
                if (this.formatJavadoc) {
                    oi.enumJdoc.put(name, fd.commentText());
                    continue block1;
                }
                oi.enumJdoc.put(name, OptionsDoclet.javadocToHtml((Doc)fd));
                continue block1;
            }
        }
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String optionsToHtml(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int refillWidth) {
        StringJoiner b = new StringJoiner(lineSep);
        ClassDoc[] classes = this.root.classes();
        if (this.includeClassDoc && classes.length > 0) {
            b.add(OptionsDoclet.javadocToHtml((Doc)classes[0]));
            b.add("<p>Command line options:</p>");
        }
        b.add("<ul>");
        if (!this.options.hasGroups()) {
            b.add(this.optionListToHtml(this.options.getOptions(), 6, 2, refillWidth));
        } else {
            for (Options.OptionGroupInfo gi : this.options.getOptionGroups()) {
                if (!gi.anyPublicized()) continue;
                String ogroupHeader = "  <li id=\"optiongroup:" + gi.name.replace(" ", "-").replace("/", "-") + "\">" + gi.name;
                b.add(this.refill(ogroupHeader, 6, 2, refillWidth));
                b.add("      <ul>");
                b.add(this.optionListToHtml(gi.optionList, 12, 8, refillWidth));
                b.add("      </ul>");
            }
        }
        b.add("</ul>");
        for (Options.OptionInfo oi : this.options.getOptions()) {
            if (oi.list == null || oi.unpublicized) continue;
            b.add("");
            b.add(LIST_HELP);
            break;
        }
        return b.toString();
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String optionsToJavadoc(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int padding, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int refillWidth) {
        StringJoiner b = new StringJoiner(lineSep);
        Scanner s = new Scanner(this.optionsToHtml(refillWidth - padding - 2));
        while (s.hasNextLine()) {
            String line = s.nextLine();
            StringBuilder bb = new StringBuilder();
            bb.append(StringUtils.repeat((String)" ", (int)padding));
            if (line.trim().equals("")) {
                bb.append("*");
            } else {
                bb.append("* ").append(line);
            }
            b.add(bb);
        }
        return b.toString();
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String optionListToHtml(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) List<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Options. @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) OptionInfo> optList, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int padding, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int firstLinePadding, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int refillWidth) {
        StringJoiner b = new StringJoiner(lineSep);
        for (Options.OptionInfo oi : optList) {
            if (oi.unpublicized) continue;
            StringBuilder bb = new StringBuilder();
            String optHtml = this.optionToHtml(oi, padding);
            bb.append(StringUtils.repeat((String)" ", (int)padding));
            bb.append("<li id=\"option:" + oi.longName + "\">").append(optHtml);
            if (refillWidth <= 0) {
                b.add(bb);
                continue;
            }
            b.add(this.refill(bb.toString(), padding, firstLinePadding, refillWidth));
        }
        return b.toString();
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String refill(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String in, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int padding, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int firstLinePadding, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int refillWidth) {
        String firstPart;
        int breakLoc;
        if (refillWidth <= 0) {
            return in;
        }
        String suffix = null;
        int ulPos = in.indexOf(lineSep + "<ul>" + lineSep);
        if (ulPos != -1) {
            String suffixTemp;
            suffix = suffixTemp = in.substring(ulPos + lineSep.length());
            in = in.substring(0, ulPos);
        }
        String compressedSpaces = in.replaceAll("[ \n\r]+", " ");
        if ((compressedSpaces = compressedSpaces.replaceAll("<code> ", "<code>")).startsWith(" ")) {
            compressedSpaces = compressedSpaces.substring(1);
        }
        String oneLine = StringUtils.repeat((String)" ", (int)firstLinePadding) + compressedSpaces;
        StringJoiner multiLine = new StringJoiner(lineSep);
        while (oneLine.length() > refillWidth && (breakLoc = oneLine.lastIndexOf(32, refillWidth)) != -1 && !(firstPart = oneLine.substring(0, breakLoc)).trim().isEmpty()) {
            multiLine.add(firstPart);
            oneLine = StringUtils.repeat((String)" ", (int)padding) + oneLine.substring(breakLoc + 1);
        }
        multiLine.add(oneLine);
        if (suffix != null) {
            Scanner s = new Scanner(suffix);
            while (s.hasNextLine()) {
                multiLine.add(StringUtils.repeat((String)" ", (int)padding) + s.nextLine());
            }
        }
        return multiLine.toString();
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String optionToHtml(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Options. @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) OptionInfo oi, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int padding) {
        String jdoc;
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b);
        if (oi.shortName != null) {
            f.format("<b>-%s</b> ", oi.shortName);
        }
        for (String a : oi.aliases) {
            f.format("<b>%s</b> ", a);
        }
        String prefix = this.getUseSingleDash() ? "-" : "--";
        f.format("<b>%s%s=</b><i>%s</i>", prefix, oi.longName, oi.typeName);
        if (oi.list != null) {
            b.append(" <code>[+]</code>");
        }
        f.format(".%n ", new Object[0]);
        f.format("%s", StringUtils.repeat((String)" ", (int)padding));
        String string = jdoc = oi.jdoc == null ? "" : oi.jdoc;
        if (oi.noDocDefault || oi.defaultStr == null) {
            f.format("%s", jdoc);
        } else {
            String defaultStr = "default: " + oi.defaultStr;
            String suffix = "";
            if (jdoc.endsWith("</p>")) {
                suffix = "</p>";
                jdoc = jdoc.substring(0, jdoc.length() - suffix.length());
            }
            f.format("%s [%s]%s", jdoc, StringEscapeUtils.escapeHtml4((String)defaultStr), suffix);
        }
        if (oi.baseType.isEnum()) {
            b.append(lineSep).append("<ul>").append(lineSep);
            assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): dependent: non-null if oi.baseType is an enum";
            for (Map.Entry<String, String> entry : oi.enumJdoc.entrySet()) {
                b.append("  <li><b>").append(entry.getKey()).append("</b>");
                if (entry.getValue().length() != 0) {
                    b.append(" ").append(entry.getValue());
                }
                b.append(lineSep);
            }
            b.append("</ul>").append(lineSep);
        }
        return b.toString();
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String javadocToHtml(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Doc doc) {
        Tag[] tags;
        StringBuilder b = new StringBuilder();
        for (Tag tag : tags = doc.inlineTags()) {
            String kind = tag.kind();
            String text = tag.text();
            if (tag instanceof SeeTag) {
                b.append("<code>" + text.replace('#', '.') + "</code>");
                continue;
            }
            if (kind.equals("@code")) {
                b.append("<code>" + StringEscapeUtils.escapeHtml4((String)text) + "</code>");
                continue;
            }
            b.append(text);
        }
        SeeTag[] seetags = doc.seeTags();
        if (seetags.length > 0) {
            b.append(" See: ");
            StringJoiner bb = new StringJoiner(", ");
            for (SeeTag tag : seetags) {
                bb.add("<code>" + tag.text() + "</code>");
            }
            b.append(bb);
            b.append(".");
        }
        return b.toString();
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean getFormatJavadoc() {
        return this.formatJavadoc;
    }

    public void setFormatJavadoc(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean val) {
        if (val && !this.formatJavadoc) {
            this.startDelim = "* " + this.startDelim;
            this.endDelim = "* " + this.endDelim;
        } else if (!val && this.formatJavadoc) {
            this.startDelim = StringUtils.removeStart((String)"* ", (String)this.startDelim);
            this.endDelim = StringUtils.removeStart((String)"* ", (String)this.endDelim);
        }
        this.formatJavadoc = val;
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean getUseSingleDash() {
        return this.options.getUseSingleDash();
    }

    public void setUseSingleDash(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean val) {
        this.options.setUseSingleDash(true);
    }
}

